/*
 * Decompiled with CFR 0.152.
 */
package console.options;

import console.ConsolePlugin;
import console.commando.CommandoCommand;
import console.commando.CommandoToolBar;
import java.awt.GridLayout;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.jEdit;

public class ToolBarOptionPane
extends AbstractOptionPane {
    private JCheckBox enabledCheckBox;
    TreeMap<String, JCheckBox> checkBoxes = new TreeMap();

    public ToolBarOptionPane() {
        super("console.toolbar");
    }

    protected void _init() {
        this.enabledCheckBox = new JCheckBox(jEdit.getProperty((String)"options.console.general.commando.toolbar"));
        this.addComponent(this.enabledCheckBox);
        this.enabledCheckBox.getModel().setSelected(jEdit.getBooleanProperty((String)"commando.toolbar.enabled"));
        this.createButtons();
    }

    protected void createButtons() {
        this.checkBoxes.clear();
        ActionSet allActions = ConsolePlugin.getAllCommands();
        GridLayout glayout = new GridLayout(0, 3);
        this.addSeparator("options.console.toolbar.buttons");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(glayout);
        for (EditAction ea : allActions.getActions()) {
            CommandoCommand cc = (CommandoCommand)ea;
            String label = cc.getShortLabel();
            JCheckBox cb = new JCheckBox(label);
            boolean selected = jEdit.getBooleanProperty((String)("commando.visible." + label), (boolean)true);
            cb.setSelected(selected);
            this.checkBoxes.put(label, cb);
            buttonPanel.add(cb);
        }
        this.addComponent(buttonPanel);
    }

    protected void _save() {
        jEdit.setBooleanProperty((String)"commando.toolbar.enabled", (boolean)this.enabledCheckBox.isSelected());
        for (JCheckBox cb : this.checkBoxes.values()) {
            jEdit.setBooleanProperty((String)("commando.visible." + cb.getText()), (boolean)cb.isSelected());
        }
        jEdit.saveSettings();
        CommandoToolBar.init();
    }
}

