/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import scala.actors.threadpool.Callable;
import scala.actors.threadpool.CancellationException;
import scala.actors.threadpool.ExecutionException;
import scala.actors.threadpool.ExecutorCompletionService;
import scala.actors.threadpool.ExecutorService;
import scala.actors.threadpool.Future;
import scala.actors.threadpool.FutureTask;
import scala.actors.threadpool.RunnableFuture;
import scala.actors.threadpool.TimeUnit;
import scala.actors.threadpool.TimeoutException;
import scala.actors.threadpool.helpers.Utils;

public abstract class AbstractExecutorService
implements ExecutorService {
    protected RunnableFuture newTaskFor(Runnable runnable, Object value) {
        return new FutureTask(runnable, value);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new FutureTask(callable);
    }

    @Override
    public Future submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, null);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public Future submit(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, result);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task);
        this.execute(ftask);
        return ftask;
    }

    /*
     * Unable to fully structure code
     */
    private Object doInvokeAny(Collection tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        block18: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            ntasks = tasks.size();
            if (ntasks == 0) {
                throw new IllegalArgumentException();
            }
            futures = new ArrayList<Future>(ntasks);
            ecs = new ExecutorCompletionService(this);
            ee = null;
            lastTime = timed != false ? Utils.nanoTime() : 0L;
            it = tasks.iterator();
            futures.add(ecs.submit((Callable)it.next()));
            --ntasks;
            active = 1;
            while (true) lbl-1000:
            // 4 sources

            {
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit((Callable)it.next()));
                        ++active;
                    } else {
                        if (active == 0) ** break;
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            now = Utils.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now = f.get();
                    return now;
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (ExecutionException eex) {
                    ee = eex;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            if (ee != null) break block18;
            ee = new ExecutionException();
        }
        throw ee;
        finally {
            f = futures.iterator();
            while (f.hasNext()) {
                ((Future)f.next()).cancel(true);
            }
        }
    }

    @Override
    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            assert (false);
            return null;
        }
    }

    @Override
    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Future> invokeAll(Collection tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ArrayList<Future> futures = new ArrayList<Future>(tasks.size());
        boolean done = false;
        try {
            Iterator t = tasks.iterator();
            while (t.hasNext()) {
                Future f = this.newTaskFor((Callable)t.next());
                futures.add(f);
                this.execute((Runnable)((Object)f));
            }
            for (Future f : futures) {
                if (f.isDone()) continue;
                try {
                    f.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException ignore) {}
            }
            done = true;
            ArrayList<Future> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future f : futures) {
                    f.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Future> invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || unit == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        ArrayList<Future> futures = new ArrayList<Future>(tasks.size());
        boolean done = false;
        try {
            Iterator t = tasks.iterator();
            while (t.hasNext()) {
                futures.add(this.newTaskFor((Callable)t.next()));
            }
            long lastTime = Utils.nanoTime();
            Iterator it = futures.iterator();
            while (it.hasNext()) {
                this.execute((Runnable)it.next());
                long now = Utils.nanoTime();
                lastTime = now;
                if ((nanos -= now - lastTime) > 0L) continue;
                ArrayList<Future> arrayList = futures;
                return arrayList;
            }
            for (Future f : futures) {
                if (f.isDone()) continue;
                if (nanos <= 0L) {
                    ArrayList<Future> arrayList = futures;
                    return arrayList;
                }
                try {
                    f.get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException ignore) {
                }
                catch (TimeoutException toe) {
                    ArrayList<Future> arrayList = futures;
                    if (!done) {
                        for (Future f2 : futures) {
                            f2.cancel(true);
                        }
                    }
                    return arrayList;
                }
                long now = Utils.nanoTime();
                nanos -= now - lastTime;
                lastTime = now;
            }
            done = true;
            ArrayList<Future> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                for (Future f : futures) {
                    f.cancel(true);
                }
            }
        }
    }
}

