/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.HighlightManagerTableModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.regex.PatternSyntaxException;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;

class Highlighter
extends TextAreaExtension
implements HighlightChangeListener {
    private final JEditTextArea textArea;
    private final Point point = new Point();
    private final HighlightManager highlightManager;
    private AlphaComposite blend;
    private float alpha = (float)jEdit.getIntegerProperty((String)"gatchan.highlight.alpha", (int)50) / 100.0f;
    public static boolean square;
    public static Color squareColor;
    public static final int MAX_LINE_LENGTH = 10000;
    private boolean roundcorner;
    private final TextAreaPainter painter;

    Highlighter(JEditTextArea textArea) {
        this.blend = AlphaComposite.getInstance(3, this.alpha);
        this.highlightManager = HighlightManagerTableModel.getManager();
        this.textArea = textArea;
        this.painter = textArea.getPainter();
    }

    public void setAlphaComposite(float alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.blend = AlphaComposite.getInstance(3, alpha);
        }
    }

    public void setRoundcorner(boolean roundcorner) {
        this.roundcorner = roundcorner;
    }

    public void paintScreenLineRange(Graphics2D gfx, int firstLine, int lastLine, int[] physicalLines, int[] start, int[] end, int y, int lineHeight) {
        if (this.highlightManager.isHighlightEnable() && this.highlightManager.countHighlights() != 0 || HighlightManagerTableModel.currentWordHighlight.isEnabled() || HighlightManagerTableModel.selectionHighlight.isEnabled()) {
            super.paintScreenLineRange(gfx, firstLine, lastLine, physicalLines, start, end, y, lineHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        CharSequence lineContent;
        int screenToPhysicalOffset;
        JEditBuffer buffer = this.textArea.getBuffer();
        int lineStartOffset = buffer.getLineStartOffset(physicalLine);
        int lineEndOffset = buffer.getLineEndOffset(physicalLine);
        int length = buffer.getLineLength(physicalLine);
        int l = length - (screenToPhysicalOffset = start - lineStartOffset) - lineEndOffset + end;
        if (l > 10000) {
            l = 10000;
        }
        if ((lineContent = buffer.getSegment(lineStartOffset + screenToPhysicalOffset, l)).length() == 0) {
            return;
        }
        CharSequence tempLineContent = lineContent;
        try {
            this.highlightManager.getReadLock();
            for (int i = 0; i < this.highlightManager.countHighlights(); ++i) {
                Highlight highlight = this.highlightManager.getHighlight(i);
                this.highlight(highlight, buffer, gfx, physicalLine, y, screenToPhysicalOffset, tempLineContent);
                tempLineContent = lineContent;
            }
        }
        finally {
            this.highlightManager.releaseLock();
        }
        tempLineContent = lineContent;
        if (this.textArea.getSelectionCount() == 0) {
            this.highlight(HighlightManagerTableModel.currentWordHighlight, buffer, gfx, physicalLine, y, screenToPhysicalOffset, tempLineContent);
        } else {
            this.highlight(HighlightManagerTableModel.selectionHighlight, buffer, gfx, physicalLine, y, screenToPhysicalOffset, tempLineContent);
        }
    }

    private void highlight(Highlight highlight, JEditBuffer buffer, Graphics2D gfx, int physicalLine, int y, int screenToPhysicalOffset, CharSequence tempLineContent) {
        if (!highlight.isEnabled() || !highlight.isValid() || highlight.getScope() == 2 && highlight.getBuffer() != buffer) {
            return;
        }
        SearchMatcher searchMatcher = highlight.getSearchMatcher();
        try {
            int i = 0;
            SearchMatcher.Match match = null;
            while ((match = searchMatcher.nextMatch(tempLineContent, i == 0, true, match == null, false)) != null && match.end != match.start) {
                int offset = match.start + i + screenToPhysicalOffset + this.textArea.getLineStartOffset(physicalLine);
                Selection selectionAtOffset = this.textArea.getSelectionAtOffset(offset);
                if (selectionAtOffset == null) {
                    int caretOffsetInLine = this.textArea.getCaretPosition() - this.textArea.getLineStartOffset(this.textArea.getCaretLine());
                    int endOffset = match.end + i + screenToPhysicalOffset;
                    int startOffset = match.start + i + screenToPhysicalOffset;
                    if (highlight != HighlightManagerTableModel.currentWordHighlight || this.textArea.getCaretLine() != physicalLine || caretOffsetInLine < startOffset || caretOffsetInLine > endOffset) {
                        this._highlight(highlight.getColor(), gfx, physicalLine, startOffset, endOffset, y, true);
                    } else {
                        this._highlight(highlight.getColor(), gfx, physicalLine, startOffset, endOffset, y, false);
                    }
                }
                highlight.updateLastSeen();
                i += match.end;
                int length = tempLineContent.length() - match.end;
                if (length > 0) {
                    tempLineContent = tempLineContent.subSequence(match.end, length + match.end);
                    continue;
                }
                break;
            }
        }
        catch (PatternSyntaxException e) {
            highlight.setValid(false);
        }
        catch (InterruptedException ie) {
            highlight.setValid(false);
        }
    }

    private void _highlight(Color highlightColor, Graphics2D gfx, int physicalLine, int startOffset, int endOffset, int y, boolean filled) {
        Point p = this.textArea.offsetToXY(physicalLine, startOffset, this.point);
        if (p == null) {
            return;
        }
        int startX = p.x;
        p = this.textArea.offsetToXY(physicalLine, endOffset, this.point);
        if (p == null) {
            return;
        }
        int endX = p.x;
        Color oldColor = gfx.getColor();
        Composite oldComposite = gfx.getComposite();
        gfx.setColor(highlightColor);
        gfx.setComposite(this.blend);
        if (filled) {
            int lineHeight = this.painter.getLineHeight();
            int charHeight = this.painter.getFontHeight();
            int charOffset = lineHeight - charHeight;
            if (this.roundcorner) {
                gfx.fillRoundRect(startX, y + charOffset, endX - startX, charHeight - 1, 5, 5);
            } else {
                gfx.fillRect(startX, y + charOffset, endX - startX, charHeight - 1);
            }
        }
        if (square) {
            gfx.setColor(squareColor);
            this.drawRect(gfx, y, startX, endX);
        } else if (!filled) {
            this.drawRect(gfx, y, startX, endX);
        }
        gfx.setColor(oldColor);
        gfx.setComposite(oldComposite);
    }

    private void drawRect(Graphics2D gfx, int y, int startX, int endX) {
        int lineHeight = this.painter.getLineHeight();
        int charHeight = this.painter.getFontHeight();
        int charOffset = lineHeight - charHeight;
        if (this.roundcorner) {
            gfx.drawRoundRect(startX, y + charOffset, endX - startX, charHeight - 1, 5, 5);
        } else {
            gfx.drawRect(startX, y + charOffset, endX - startX, charHeight - 1);
        }
    }

    @Override
    public void highlightUpdated(boolean highlightEnabled) {
        int firstLine = this.textArea.getFirstPhysicalLine();
        int lastLine = this.textArea.getLastPhysicalLine();
        this.textArea.invalidateLineRange(firstLine, lastLine);
    }
}

