/*
 * Decompiled with CFR 0.152.
 */
package gatchan.highlight;

import gatchan.highlight.Highlight;
import gatchan.highlight.HighlightChangeListener;
import gatchan.highlight.HighlightManager;
import gatchan.highlight.Highlighter;
import gatchan.highlight.InvalidHighlightException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class HighlightManagerTableModel
extends AbstractTableModel
implements HighlightManager {
    private static final String ENABLED_PROP = "plugin.Highlight.enabled";
    private final List<Highlight> datas = new ArrayList<Highlight>();
    private static HighlightManagerTableModel highlightManagerTableModel;
    private final List<HighlightChangeListener> highlightChangeListeners = new ArrayList<HighlightChangeListener>(2);
    private final File highlights;
    private final ReentrantReadWriteLock lock;
    public static Highlight currentWordHighlight;
    public static Highlight selectionHighlight;
    private boolean highlightWordAtCaret;
    private boolean highlightWordAtCaretEntireWord;
    private boolean highlightWordAtCaretWhitespace;
    private boolean highlightWordAtCaretOnlyWords;
    private boolean highlightSelection;
    private boolean highlightSelectionEntireWord;
    private boolean appendHighlight = jEdit.getBooleanProperty((String)"gatchan.highlight.appendHighlight");
    public static final String FILE_VERSION = "Highlight file v2";
    private Timer timer;

    static HighlightManager createInstance(File highlightFile) {
        highlightManagerTableModel = new HighlightManagerTableModel(highlightFile);
        return highlightManagerTableModel;
    }

    public static HighlightManagerTableModel getInstance() {
        return highlightManagerTableModel;
    }

    public static HighlightManager getManager() {
        return HighlightManagerTableModel.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HighlightManagerTableModel(File highlightFile) {
        this.lock = new ReentrantReadWriteLock();
        this.highlights = highlightFile;
        currentWordHighlight = new Highlight();
        selectionHighlight = new Highlight();
        if (this.highlights != null && this.highlights.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.highlights));
                String line = reader.readLine();
                boolean getStatus = false;
                if (FILE_VERSION.equals(line)) {
                    getStatus = true;
                    line = reader.readLine();
                }
                while (line != null) {
                    try {
                        this.addElement(Highlight.unserialize(line, getStatus), false);
                    }
                    catch (InvalidHighlightException e) {
                        Log.log((int)7, (Object)this, (Object)("Unable to read this highlight, please report it : " + line));
                    }
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException e) {
                Log.log((int)9, (Object)this, (Object)e);
                IOUtilities.closeQuietly((Closeable)reader);
            }
            catch (IOException e2) {
                Log.log((int)9, (Object)this, (Object)e2);
                {
                    catch (Throwable throwable) {
                        IOUtilities.closeQuietly(reader);
                        throw throwable;
                    }
                }
                IOUtilities.closeQuietly((Closeable)reader);
            }
            IOUtilities.closeQuietly((Closeable)reader);
        }
        this.highlightWordAtCaret = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight");
        this.highlightSelection = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight");
        this.highlightSelectionEntireWord = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.entireWord");
        this.highlightWordAtCaretEntireWord = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.entireWord");
        this.highlightWordAtCaretWhitespace = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.whitespace");
        this.highlightWordAtCaretOnlyWords = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.onlyWords");
        currentWordHighlight.init(" ", this.highlightWordAtCaretEntireWord, jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.ignoreCase"), jEdit.getColorProperty((String)"gatchan.highlight.caretHighlight.color"));
        selectionHighlight.init(" ", this.highlightSelectionEntireWord, jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.ignoreCase"), jEdit.getColorProperty((String)"gatchan.highlight.selectionHighlight.color"));
        currentWordHighlight.setEnabled(false);
        selectionHighlight.setEnabled(false);
        this.timer = new Timer(1000, new RemoveExpired());
        this.timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        try {
            this.lock.readLock().lock();
            int n = this.datas.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    public Class getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : Highlight.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Highlight o;
        try {
            this.lock.readLock().lock();
            o = this.datas.get(rowIndex);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (columnIndex == 0) {
            return o.isEnabled();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            Highlight highlight;
            try {
                this.lock.readLock().lock();
                highlight = this.datas.get(rowIndex);
            }
            finally {
                this.lock.readLock().unlock();
            }
            highlight.setEnabled((Boolean)aValue);
        } else {
            try {
                this.lock.writeLock().lock();
                this.datas.set(rowIndex, (Highlight)aValue);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public Highlight getHighlight(int i) {
        return this.datas.get(i);
    }

    @Override
    public void addElement(Highlight highlight) {
        this.addElement(highlight, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addElement(Highlight highlight, boolean enable) {
        if (this.indexOf(highlight) == -1) {
            if (this.appendHighlight || this.datas.isEmpty()) {
                int firstRow;
                try {
                    this.lock.writeLock().lock();
                    this.datas.add(highlight);
                    firstRow = this.datas.size() - 1;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                this.fireTableRowsInserted(firstRow, firstRow);
            } else {
                Highlight replacedHighlight;
                int firstRow;
                try {
                    this.lock.readLock().lock();
                    firstRow = this.datas.size() - 1;
                    replacedHighlight = this.datas.get(firstRow);
                }
                finally {
                    this.lock.readLock().unlock();
                }
                replacedHighlight.init(highlight.getStringToHighlight(), highlight.isRegexp(), highlight.isIgnoreCase(), highlight.getColor());
                this.fireTableRowsUpdated(firstRow, firstRow);
            }
        }
        if (enable) {
            this.setHighlightEnable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRow(int index) {
        try {
            this.lock.writeLock().lock();
            this.datas.remove(index);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.fireTableRowsDeleted(index, index);
    }

    private void removeRow(Highlight item) {
        int index = this.indexOf(item);
        if (index != -1) {
            this.removeRow(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int indexOf(Highlight highlight) {
        try {
            int i;
            this.lock.readLock().lock();
            int n = i = this.datas.indexOf(highlight);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void bufferClosed(Buffer buffer) {
        List highlights = (List)buffer.getProperty((Object)"highlights");
        if (highlights != null) {
            for (int i = 0; i < highlights.size(); ++i) {
                this.removeRow((Highlight)highlights.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        int rowMax;
        try {
            this.lock.writeLock().lock();
            rowMax = this.datas.size();
            this.datas.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (rowMax != 0) {
            this.fireTableRowsDeleted(0, rowMax - 1);
        }
    }

    @Override
    public void dispose() {
        this.timer.stop();
        this.timer = null;
        highlightManagerTableModel = null;
        selectionHighlight = null;
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        if (this.highlights != null) {
            PrintWriter writer = null;
            try {
                File parentFile = this.highlights.getParentFile();
                if (!parentFile.isDirectory()) {
                    parentFile.mkdirs();
                }
                writer = new PrintWriter(this.highlights);
                writer.println(FILE_VERSION);
                try {
                    this.lock.writeLock().lock();
                    ListIterator<Highlight> listIterator = this.datas.listIterator();
                    while (listIterator.hasNext()) {
                        Highlight highlight = listIterator.next();
                        if (highlight.getScope() == 0) {
                            writer.println(highlight.serialize());
                            continue;
                        }
                        listIterator.remove();
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                IOUtilities.closeQuietly((Closeable)writer);
            }
            catch (IOException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
            finally {
                IOUtilities.closeQuietly(writer);
            }
        } else {
            Log.log((int)9, (Object)this, (Object)"No settings");
        }
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        super.fireTableChanged(e);
        this.fireHighlightChangeListener(this.isHighlightEnable());
    }

    @Override
    public void addHighlightChangeListener(HighlightChangeListener listener) {
        if (!this.highlightChangeListeners.contains(listener)) {
            this.highlightChangeListeners.add(listener);
        }
    }

    @Override
    public void removeHighlightChangeListener(HighlightChangeListener listener) {
        this.highlightChangeListeners.remove(listener);
    }

    @Override
    public void fireHighlightChangeListener(boolean highlightEnable) {
        for (int i = 0; i < this.highlightChangeListeners.size(); ++i) {
            HighlightChangeListener listener = this.highlightChangeListeners.get(i);
            listener.highlightUpdated(highlightEnable);
        }
    }

    @Override
    public int countHighlights() {
        return this.getRowCount();
    }

    @Override
    public boolean isHighlightEnable() {
        return jEdit.getBooleanProperty((String)ENABLED_PROP);
    }

    @Override
    public void setHighlightEnable(boolean highlightEnable) {
        jEdit.setBooleanProperty((String)ENABLED_PROP, (boolean)highlightEnable);
        this.fireHighlightChangeListener(highlightEnable);
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        JEditTextArea textArea = (JEditTextArea)e.getSource();
        this.caretUpdate(textArea);
    }

    public void caretUpdate(JEditTextArea textArea) {
        int line = textArea.getCaretLine();
        boolean updated = false;
        if (this.highlightWordAtCaret) {
            if (textArea.getLineLength(line) == 0 || textArea.getSelectionCount() != 0) {
                if (currentWordHighlight.isEnabled()) {
                    updated = true;
                    currentWordHighlight.setEnabled(false);
                }
            } else {
                int lineStart = textArea.getLineStartOffset(line);
                int offset = textArea.getCaretPosition() - lineStart;
                JEditBuffer buffer = textArea.getBuffer();
                CharSequence lineText = buffer.getLineSegment(line);
                String noWordSep = buffer.getStringProperty("noWordSep");
                if (offset != 0) {
                    --offset;
                }
                int wordStart = TextUtilities.findWordStart((CharSequence)lineText, (int)offset, (String)noWordSep);
                char ch = lineText.charAt(wordStart);
                if (!this.highlightWordAtCaretWhitespace && Character.isWhitespace(ch) || this.highlightWordAtCaretOnlyWords && !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1) {
                    if (currentWordHighlight.isEnabled()) {
                        updated = true;
                        currentWordHighlight.setEnabled(false);
                    }
                } else {
                    int wordEnd = TextUtilities.findWordEnd((CharSequence)lineText, (int)(offset + 1), (String)noWordSep);
                    if (wordEnd - wordStart < 2) {
                        if (currentWordHighlight.isEnabled()) {
                            updated = true;
                            currentWordHighlight.setEnabled(false);
                        }
                    } else {
                        if (!currentWordHighlight.isEnabled()) {
                            updated = true;
                            currentWordHighlight.setEnabled(true);
                        }
                        String stringToHighlight = ((Object)lineText.subSequence(wordStart, wordEnd)).toString();
                        if (this.highlightWordAtCaretEntireWord) {
                            stringToHighlight = "\\b" + stringToHighlight + "\\b";
                            if (!stringToHighlight.equals(currentWordHighlight.getStringToHighlight())) {
                                updated = true;
                                currentWordHighlight.init(stringToHighlight, true, currentWordHighlight.isIgnoreCase(), currentWordHighlight.getColor());
                            }
                        } else if (!stringToHighlight.equals(currentWordHighlight.getStringToHighlight())) {
                            updated = true;
                            currentWordHighlight.setStringToHighlight(stringToHighlight);
                        }
                    }
                }
            }
        }
        if (this.highlightSelection) {
            Selection selectionatOffset = textArea.getSelectionAtOffset(textArea.getCaretPosition());
            if (textArea.getLineLength(line) == 0 || selectionatOffset == null || selectionatOffset.getStartLine() != selectionatOffset.getEndLine() || selectionatOffset.getEnd() - selectionatOffset.getStart() == 0) {
                if (selectionHighlight.isEnabled()) {
                    updated = true;
                    selectionHighlight.setEnabled(false);
                }
            } else {
                String stringToHighlight = textArea.getSelectedText(selectionatOffset);
                if (this.highlightSelectionEntireWord) {
                    stringToHighlight = "\\b" + stringToHighlight + "\\b";
                    if (!selectionHighlight.isEnabled() || !stringToHighlight.equals(selectionHighlight.getStringToHighlight())) {
                        updated = true;
                        selectionHighlight.setEnabled(true);
                        selectionHighlight.init(stringToHighlight, true, selectionHighlight.isIgnoreCase(), selectionHighlight.getColor());
                    }
                } else if (!selectionHighlight.isEnabled() || !stringToHighlight.equals(selectionHighlight.getStringToHighlight())) {
                    updated = true;
                    selectionHighlight.setEnabled(true);
                    selectionHighlight.setStringToHighlight(stringToHighlight);
                }
            }
        }
        if (updated) {
            this.fireHighlightChangeListener(this.isHighlightEnable());
        }
    }

    @Override
    public boolean isHighlightWordAtCaret() {
        return this.highlightWordAtCaret;
    }

    @Override
    public boolean isHighlightSelection() {
        return this.highlightSelection;
    }

    @Override
    public void propertiesChanged() {
        boolean selectionEntireWord;
        boolean onlyWords;
        boolean whitespace;
        boolean entireWord;
        boolean highlightSelection;
        if (jEdit.getBooleanProperty((String)"gatchan.highlight.cycleColor")) {
            Highlight.setDefaultColor(null);
        } else {
            Highlight.setDefaultColor(jEdit.getColorProperty((String)"gatchan.highlight.defaultColor"));
        }
        this.appendHighlight = jEdit.getBooleanProperty((String)"gatchan.highlight.appendHighlight");
        boolean changed = false;
        boolean changedSelection = false;
        boolean shouldUpdateCaret = false;
        boolean highlightWordAtCaret = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight");
        if (this.highlightWordAtCaret != highlightWordAtCaret) {
            changed = true;
            this.highlightWordAtCaret = highlightWordAtCaret;
            currentWordHighlight.setEnabled(highlightWordAtCaret);
            if (highlightWordAtCaret) {
                shouldUpdateCaret = true;
            }
        }
        if (this.highlightSelection != (highlightSelection = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight"))) {
            changedSelection = true;
            this.highlightSelection = highlightSelection;
            selectionHighlight.setEnabled(highlightSelection);
            if (highlightSelection) {
                shouldUpdateCaret = true;
            }
        }
        if (shouldUpdateCaret) {
            this.caretUpdate(jEdit.getActiveView().getTextArea());
        }
        if (this.highlightWordAtCaretEntireWord != (entireWord = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.entireWord"))) {
            changed = true;
            this.highlightWordAtCaretEntireWord = entireWord;
            if (entireWord) {
                String s = currentWordHighlight.getStringToHighlight();
                currentWordHighlight.setStringToHighlight("\\b" + s + "\\b");
            }
        }
        if (this.highlightWordAtCaretWhitespace != (whitespace = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.whitespace"))) {
            changed = true;
            this.highlightWordAtCaretWhitespace = whitespace;
        }
        if (this.highlightWordAtCaretOnlyWords != (onlyWords = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.onlyWords"))) {
            changed = true;
            this.highlightWordAtCaretOnlyWords = onlyWords;
        }
        boolean ignoreCase = jEdit.getBooleanProperty((String)"gatchan.highlight.caretHighlight.ignoreCase");
        if (currentWordHighlight.isIgnoreCase() != ignoreCase) {
            changed = true;
        }
        boolean selectionIgnoreCase = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.ignoreCase");
        if (selectionHighlight.isIgnoreCase() != ignoreCase) {
            changedSelection = true;
        }
        Color newColor = jEdit.getColorProperty((String)"gatchan.highlight.caretHighlight.color");
        if (!currentWordHighlight.getColor().equals(newColor)) {
            changed = true;
        }
        if (this.highlightSelectionEntireWord != (selectionEntireWord = jEdit.getBooleanProperty((String)"gatchan.highlight.selectionHighlight.entireWord"))) {
            changed = true;
            this.highlightSelectionEntireWord = selectionEntireWord;
            if (selectionEntireWord) {
                String s = selectionHighlight.getStringToHighlight();
                selectionHighlight.setStringToHighlight("\\b" + s + "\\b");
            }
        }
        Color selectionNewColor = jEdit.getColorProperty((String)"gatchan.highlight.selectionHighlight.color");
        if (!selectionHighlight.getColor().equals(selectionNewColor)) {
            changedSelection = true;
        }
        Highlighter.square = jEdit.getBooleanProperty((String)"gatchan.highlight.square");
        Highlighter.squareColor = jEdit.getColorProperty((String)"gatchan.highlight.square.color");
        if (changed) {
            currentWordHighlight.init(currentWordHighlight.getStringToHighlight(), entireWord, ignoreCase, newColor);
        }
        if (changedSelection) {
            selectionHighlight.init(selectionHighlight.getStringToHighlight(), false, selectionIgnoreCase, selectionNewColor);
        }
        if (changed || changedSelection) {
            this.fireHighlightChangeListener(this.isHighlightEnable());
        }
    }

    @Override
    public void getReadLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void releaseLock() {
        this.lock.readLock().unlock();
    }

    private class RemoveExpired
    implements ActionListener {
        private RemoveExpired() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Highlight highlight;
            int i;
            ArrayList<Highlight> expired = null;
            try {
                HighlightManagerTableModel.this.lock.readLock().lock();
                for (i = 0; i < HighlightManagerTableModel.this.datas.size(); ++i) {
                    highlight = (Highlight)HighlightManagerTableModel.this.datas.get(i);
                    if (!highlight.isExpired()) continue;
                    if (expired == null) {
                        expired = new ArrayList<Highlight>();
                    }
                    expired.add(highlight);
                }
            }
            finally {
                HighlightManagerTableModel.this.lock.readLock().unlock();
            }
            if (expired != null) {
                for (i = 0; i < expired.size(); ++i) {
                    highlight = (Highlight)expired.get(i);
                    HighlightManagerTableModel.this.removeRow(highlight);
                }
            }
        }
    }
}

