/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.renderer.BaseInputControl;

public class InputFileControl
extends BaseInputControl {
    private final JTextField textField = new JTextField();
    private final JButton browseButton = new JButton();
    private File fileValue;

    public InputFileControl(HTMLBaseInputElement hTMLBaseInputElement) {
        super(hTMLBaseInputElement);
        this.setLayout(new BoxLayout(this, 0));
        JButton jButton = this.browseButton;
        jButton.setAction(new BrowseAction());
        jButton.setText("Browse");
        Dimension dimension = this.textField.getPreferredSize();
        this.textField.setPreferredSize(new Dimension(128, dimension.height));
        this.textField.setEditable(false);
        this.add(this.textField);
        this.add(Box.createHorizontalStrut(4));
        this.add(jButton);
    }

    public String getValue() {
        return this.textField.getText();
    }

    public void setDisabled(boolean bl) {
        this.browseButton.setEnabled(!bl);
    }

    public void setValue(String string) {
    }

    private void setFileValue(File file) {
        this.fileValue = file;
        if (file == null) {
            this.textField.setText("");
        } else {
            this.textField.setText(file.getAbsolutePath());
        }
    }

    public File getFileValue() {
        return this.fileValue;
    }

    public void resetInput() {
        this.setFileValue(null);
    }

    private class BrowseAction
    extends AbstractAction {
        private BrowseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(InputFileControl.this) == 0) {
                InputFileControl.this.setFileValue(jFileChooser.getSelectedFile());
            } else {
                InputFileControl.this.setFileValue(null);
            }
        }
    }
}

