/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.js;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLIFrameElementImpl;
import org.lobobrowser.html.domimpl.HTMLImageElementImpl;
import org.lobobrowser.html.domimpl.HTMLOptionElementImpl;
import org.lobobrowser.html.domimpl.HTMLScriptElementImpl;
import org.lobobrowser.html.domimpl.HTMLSelectElementImpl;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.js.History;
import org.lobobrowser.html.js.Location;
import org.lobobrowser.html.js.Navigator;
import org.lobobrowser.html.js.Screen;
import org.lobobrowser.html.js.XMLHttpRequest;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.js.JavaClassWrapper;
import org.lobobrowser.js.JavaClassWrapperFactory;
import org.lobobrowser.js.JavaInstantiator;
import org.lobobrowser.js.JavaObjectWrapper;
import org.lobobrowser.js.JavaScript;
import org.lobobrowser.util.ID;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSS2Properties;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class Window
extends AbstractScriptableDelegate
implements AbstractView {
    private static final Logger logger = Logger.getLogger(Window.class.getName());
    private static final Map CONTEXT_WINDOWS = new WeakHashMap();
    private static final JavaClassWrapper XMLHTTPREQUEST_WRAPPER = JavaClassWrapperFactory.getInstance().getClassWrapper(XMLHttpRequest.class);
    private static int timerIdCounter = 0;
    private final HtmlRendererContext rcontext;
    private final UserAgentContext uaContext;
    private Navigator navigator;
    private Screen screen;
    private Location location;
    private Map taskMap;
    private volatile HTMLDocumentImpl document;
    private ScriptableObject windowScope;
    private int length;
    private boolean lengthSet = false;
    private History history;
    private Function onunload;

    public Window(HtmlRendererContext htmlRendererContext, UserAgentContext userAgentContext) {
        this.rcontext = htmlRendererContext;
        this.uaContext = userAgentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int generateTimerID() {
        Logger logger = Window.logger;
        synchronized (logger) {
            return timerIdCounter++;
        }
    }

    public HtmlRendererContext getHtmlRendererContext() {
        return this.rcontext;
    }

    public UserAgentContext getUserAgentContext() {
        return this.uaContext;
    }

    private void clearState() {
        Scriptable scriptable = this.getWindowScope();
        if (scriptable != null) {
            Object[] objectArray = scriptable.getIds();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof String) {
                    scriptable.delete((String)object);
                    continue;
                }
                if (!(object instanceof Integer)) continue;
                scriptable.delete(((Integer)object).intValue());
            }
        }
    }

    public void setDocument(HTMLDocumentImpl hTMLDocumentImpl) {
        HTMLDocumentImpl hTMLDocumentImpl2 = this.document;
        if (hTMLDocumentImpl2 != hTMLDocumentImpl) {
            if (hTMLDocumentImpl2 != null) {
                this.clearState();
            }
            this.initWindowScope(hTMLDocumentImpl);
            this.forgetAllTasks();
            Function function = this.onunload;
            if (function != null) {
                HTMLDocumentImpl hTMLDocumentImpl3 = this.document;
                Executor.executeFunction(this.getWindowScope(), function, hTMLDocumentImpl3.getDocumentURL(), this.uaContext);
                this.onunload = null;
            }
            this.document = hTMLDocumentImpl;
        }
    }

    public DocumentView getDocument() {
        return this.document;
    }

    public Document getDocumentNode() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndStartTask(Integer n, Timer timer, Object object) {
        TaskWrapper taskWrapper = null;
        Window window = this;
        synchronized (window) {
            HashMap<Integer, TaskWrapper> hashMap = this.taskMap;
            if (hashMap == null) {
                this.taskMap = hashMap = new HashMap<Integer, TaskWrapper>(4);
            } else {
                taskWrapper = (TaskWrapper)hashMap.get(n);
            }
            hashMap.put(n, new TaskWrapper(timer, object));
        }
        if (taskWrapper != null) {
            taskWrapper.timer.stop();
        }
        timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetTask(Integer n, boolean bl) {
        TaskWrapper taskWrapper = null;
        Window window = this;
        synchronized (window) {
            Map map = this.taskMap;
            if (map != null) {
                taskWrapper = (TaskWrapper)map.remove(n);
            }
        }
        if (taskWrapper != null && bl) {
            taskWrapper.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetAllTasks() {
        Object object;
        TaskWrapper[] taskWrapperArray = null;
        Window window = this;
        synchronized (window) {
            object = this.taskMap;
            if (object != null) {
                taskWrapperArray = object.values().toArray(new TaskWrapper[0]);
                this.taskMap = null;
            }
        }
        if (taskWrapperArray != null) {
            for (int i = 0; i < taskWrapperArray.length; ++i) {
                object = taskWrapperArray[i];
                ((TaskWrapper)object).timer.stop();
            }
        }
    }

    public int setInterval(Function function, double d) {
        if (d > 2.147483647E9 || d < 0.0) {
            throw new IllegalArgumentException("Timeout value " + d + " is not supported.");
        }
        int n = Window.generateTimerID();
        Integer n2 = new Integer(n);
        FunctionTimerTask functionTimerTask = new FunctionTimerTask(this, n2, function, false);
        int n3 = (int)d;
        if (n3 < 1) {
            n3 = 1;
        }
        Timer timer = new Timer(n3, functionTimerTask);
        timer.setRepeats(true);
        this.putAndStartTask(n2, timer, function);
        return n;
    }

    public int setInterval(String string, double d) {
        if (d > 2.147483647E9 || d < 0.0) {
            throw new IllegalArgumentException("Timeout value " + d + " is not supported.");
        }
        int n = Window.generateTimerID();
        Integer n2 = new Integer(n);
        ExpressionTimerTask expressionTimerTask = new ExpressionTimerTask(this, n2, string, false);
        int n3 = (int)d;
        if (n3 < 1) {
            n3 = 1;
        }
        Timer timer = new Timer(n3, expressionTimerTask);
        timer.setRepeats(false);
        this.putAndStartTask(n2, timer, null);
        return n;
    }

    public void clearInterval(int n) {
        Integer n2 = new Integer(n);
        this.forgetTask(n2, true);
    }

    public void alert(String string) {
        if (this.rcontext != null) {
            this.rcontext.alert(string);
        }
    }

    public void back() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            htmlRendererContext.back();
        }
    }

    public void blur() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            htmlRendererContext.blur();
        }
    }

    public void clearTimeout(int n) {
        Integer n2 = new Integer(n);
        this.forgetTask(n2, true);
    }

    public void close() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            htmlRendererContext.close();
        }
    }

    public boolean confirm(String string) {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            return htmlRendererContext.confirm(string);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String string) {
        HTMLDocumentImpl hTMLDocumentImpl = this.document;
        if (hTMLDocumentImpl == null) {
            throw new IllegalStateException("Cannot evaluate if document is not set.");
        }
        Context context = Executor.createContext(hTMLDocumentImpl.getDocumentURL(), this.uaContext);
        try {
            Scriptable scriptable = this.getWindowScope();
            if (scriptable == null) {
                throw new IllegalStateException("Scriptable (scope) instance was expected to be keyed as UserData to document using cobra.js.scope");
            }
            String string2 = "window.eval";
            if (logger.isLoggable(Level.INFO)) {
                logger.info("eval(): javascript follows...\r\n" + string);
            }
            Object object = context.evaluateString(scriptable, string, string2, 1, null);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public void focus() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            htmlRendererContext.focus();
        }
    }

    private void initWindowScope(final Document document) {
        final Scriptable scriptable = this.getWindowScope();
        JavaInstantiator javaInstantiator = new JavaInstantiator(){

            public Object newInstance() {
                HTMLDocumentImpl hTMLDocumentImpl;
                Document document2 = document;
                if (document2 == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                try {
                    hTMLDocumentImpl = (HTMLDocumentImpl)document2;
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalStateException("Cannot perform operation with documents of type " + document2.getClass().getName() + ".");
                }
                return new XMLHttpRequest(Window.this.uaContext, hTMLDocumentImpl.getDocumentURL(), scriptable);
            }
        };
        Function function = JavaObjectWrapper.getConstructor("XMLHttpRequest", XMLHTTPREQUEST_WRAPPER, scriptable, javaInstantiator);
        ScriptableObject.defineProperty((Scriptable)scriptable, (String)"XMLHttpRequest", (Object)function, (int)1);
        this.defineElementClass(scriptable, document, "Image", "img", HTMLImageElementImpl.class);
        this.defineElementClass(scriptable, document, "Script", "script", HTMLScriptElementImpl.class);
        this.defineElementClass(scriptable, document, "IFrame", "iframe", HTMLIFrameElementImpl.class);
        this.defineElementClass(scriptable, document, "Option", "option", HTMLOptionElementImpl.class);
        this.defineElementClass(scriptable, document, "Select", "select", HTMLSelectElementImpl.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scriptable getWindowScope() {
        Window window = this;
        synchronized (window) {
            ScriptableObject scriptableObject;
            ScriptableObject scriptableObject2 = this.windowScope;
            if (scriptableObject2 != null) {
                return scriptableObject2;
            }
            Context context = Context.enter();
            try {
                scriptableObject2 = (ScriptableObject)JavaScript.getInstance().getJavascriptObject(this, null);
                context.initStandardObjects(scriptableObject2);
                this.windowScope = scriptableObject2;
                scriptableObject = scriptableObject2;
            }
            catch (Throwable throwable) {
                Context.exit();
                throw throwable;
            }
            Context.exit();
            return scriptableObject;
        }
    }

    private final void defineElementClass(Scriptable scriptable, final Document document, String string, final String string2, Class clazz) {
        JavaInstantiator javaInstantiator = new JavaInstantiator(){

            public Object newInstance() {
                Document document2 = document;
                if (document2 == null) {
                    throw new IllegalStateException("Document not set in current context.");
                }
                return document2.createElement(string2);
            }
        };
        JavaClassWrapper javaClassWrapper = JavaClassWrapperFactory.getInstance().getClassWrapper(clazz);
        Function function = JavaObjectWrapper.getConstructor(string, javaClassWrapper, scriptable, javaInstantiator);
        ScriptableObject.defineProperty((Scriptable)scriptable, (String)string, (Object)function, (int)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window getWindow(HtmlRendererContext htmlRendererContext) {
        if (htmlRendererContext == null) {
            return null;
        }
        Map map = CONTEXT_WINDOWS;
        synchronized (map) {
            Window window;
            Reference reference = (Reference)CONTEXT_WINDOWS.get(htmlRendererContext);
            if (reference != null && (window = (Window)reference.get()) != null) {
                return window;
            }
            window = new Window(htmlRendererContext, htmlRendererContext.getUserAgentContext());
            CONTEXT_WINDOWS.put(htmlRendererContext, new WeakReference<Window>(window));
            return window;
        }
    }

    public Window open(String string, String string2, String string3, boolean bl) {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            URL uRL;
            HTMLDocumentImpl hTMLDocumentImpl = this.document;
            if (hTMLDocumentImpl instanceof HTMLDocumentImpl) {
                uRL = hTMLDocumentImpl.getFullURL(string);
            } else {
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IllegalArgumentException("Malformed URI: " + string);
                }
            }
            HtmlRendererContext htmlRendererContext2 = htmlRendererContext.open(uRL, string2, string3, bl);
            return Window.getWindow(htmlRendererContext2);
        }
        return null;
    }

    public Window open(String string) {
        return this.open(string, "window:" + String.valueOf(ID.generateLong()));
    }

    public Window open(String string, String string2) {
        return this.open(string, string2, "", false);
    }

    public Window open(String string, String string2, String string3) {
        return this.open(string, string2, string3, false);
    }

    public String prompt(String string) {
        return this.prompt(string, "");
    }

    public String prompt(String string, int n) {
        return this.prompt(string, String.valueOf(n));
    }

    public String prompt(String string, String string2) {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            return htmlRendererContext.prompt(string, string2);
        }
        return null;
    }

    public void scrollTo(int n, int n2) {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            htmlRendererContext.scroll(n, n2);
        }
    }

    public void scrollBy(int n, int n2) {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            htmlRendererContext.scrollBy(n, n2);
        }
    }

    public void resizeTo(int n, int n2) {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            htmlRendererContext.resizeTo(n, n2);
        }
    }

    public void resizeBy(int n, int n2) {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            htmlRendererContext.resizeBy(n, n2);
        }
    }

    public int setTimeout(String string, double d) {
        if (d > 2.147483647E9 || d < 0.0) {
            throw new IllegalArgumentException("Timeout value " + d + " is not supported.");
        }
        int n = Window.generateTimerID();
        Integer n2 = new Integer(n);
        ExpressionTimerTask expressionTimerTask = new ExpressionTimerTask(this, n2, string, true);
        int n3 = (int)d;
        if (n3 < 1) {
            n3 = 1;
        }
        Timer timer = new Timer(n3, expressionTimerTask);
        timer.setRepeats(false);
        this.putAndStartTask(n2, timer, null);
        return n;
    }

    public int setTimeout(Function function, double d) {
        if (d > 2.147483647E9 || d < 0.0) {
            throw new IllegalArgumentException("Timeout value " + d + " is not supported.");
        }
        int n = Window.generateTimerID();
        Integer n2 = new Integer(n);
        FunctionTimerTask functionTimerTask = new FunctionTimerTask(this, n2, function, true);
        int n3 = (int)d;
        if (n3 < 1) {
            n3 = 1;
        }
        Timer timer = new Timer(n3, functionTimerTask);
        timer.setRepeats(false);
        this.putAndStartTask(n2, timer, function);
        return n;
    }

    public boolean isClosed() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            return htmlRendererContext.isClosed();
        }
        return false;
    }

    public String getDefaultStatus() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            return htmlRendererContext.getDefaultStatus();
        }
        return null;
    }

    public HTMLCollection getFrames() {
        HTMLDocumentImpl hTMLDocumentImpl = this.document;
        if (hTMLDocumentImpl instanceof HTMLDocumentImpl) {
            return hTMLDocumentImpl.getFrames();
        }
        return null;
    }

    public int getLength() {
        if (this.lengthSet) {
            return this.length;
        }
        HTMLCollection hTMLCollection = this.getFrames();
        return hTMLCollection == null ? 0 : hTMLCollection.getLength();
    }

    public void setLength(int n) {
        this.lengthSet = true;
        this.length = n;
    }

    public String getName() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            return htmlRendererContext.getName();
        }
        return null;
    }

    public Window getParent() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            return Window.getWindow(htmlRendererContext.getParent());
        }
        return null;
    }

    public Window getOpener() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            return Window.getWindow(htmlRendererContext.getOpener());
        }
        return null;
    }

    public void setOpener(Window window) {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            if (window == null) {
                htmlRendererContext.setOpener(null);
            } else {
                htmlRendererContext.setOpener(window.rcontext);
            }
        }
    }

    public Window getSelf() {
        return this;
    }

    public String getStatus() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            return htmlRendererContext.getStatus();
        }
        return null;
    }

    public void setStatus(String string) {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            htmlRendererContext.setStatus(string);
        }
    }

    public Window getTop() {
        HtmlRendererContext htmlRendererContext = this.rcontext;
        if (htmlRendererContext != null) {
            return Window.getWindow(htmlRendererContext.getTop());
        }
        return null;
    }

    public Window getWindow() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Navigator getNavigator() {
        Window window = this;
        synchronized (window) {
            Navigator navigator = this.navigator;
            if (navigator == null) {
                this.navigator = navigator = new Navigator(this.uaContext);
            }
            return navigator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Screen getScreen() {
        Window window = this;
        synchronized (window) {
            Screen screen = this.screen;
            if (screen == null) {
                this.screen = screen = new Screen();
            }
            return screen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation() {
        Window window = this;
        synchronized (window) {
            Location location = this.location;
            if (location == null) {
                this.location = location = new Location(this);
            }
            return location;
        }
    }

    public void setLocation(String string) {
        this.getLocation().setHref(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public History getHistory() {
        Window window = this;
        synchronized (window) {
            History history = this.history;
            if (history == null) {
                this.history = history = new History(this);
            }
            return history;
        }
    }

    public CSS2Properties getComputedStyle(HTMLElement hTMLElement, String string) {
        if (hTMLElement instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)hTMLElement).getComputedStyle(string);
        }
        throw new IllegalArgumentException("Element implementation unknown: " + hTMLElement);
    }

    public Function getOnload() {
        HTMLDocumentImpl hTMLDocumentImpl = this.document;
        if (hTMLDocumentImpl instanceof HTMLDocumentImpl) {
            return hTMLDocumentImpl.getOnloadHandler();
        }
        return null;
    }

    public void setOnload(Function function) {
        HTMLDocumentImpl hTMLDocumentImpl = this.document;
        if (hTMLDocumentImpl instanceof HTMLDocumentImpl) {
            hTMLDocumentImpl.setOnloadHandler(function);
        }
    }

    public Function getOnunload() {
        return this.onunload;
    }

    public void setOnunload(Function function) {
        this.onunload = function;
    }

    public Node namedItem(String string) {
        HTMLDocumentImpl hTMLDocumentImpl = this.document;
        if (hTMLDocumentImpl == null) {
            return null;
        }
        Element element = hTMLDocumentImpl.getElementById(string);
        if (element != null) {
            return element;
        }
        return null;
    }

    public void forceGC() {
        System.gc();
    }

    private static class TaskWrapper {
        public final Timer timer;
        private final Object retained;

        public TaskWrapper(Timer timer, Object object) {
            this.timer = timer;
            this.retained = object;
        }
    }

    private static class ExpressionTimerTask
    extends WeakWindowTask {
        private final Integer timeIDInt;
        private final String expression;
        private final boolean removeTask;

        public ExpressionTimerTask(Window window, Integer n, String string, boolean bl) {
            super(window);
            this.timeIDInt = n;
            this.expression = string;
            this.removeTask = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HTMLDocumentImpl hTMLDocumentImpl;
                Window window = this.getWindow();
                if (window == null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("actionPerformed(): Window is no longer available.");
                    }
                    return;
                }
                if (this.removeTask) {
                    window.forgetTask(this.timeIDInt, false);
                }
                if ((hTMLDocumentImpl = (HTMLDocumentImpl)window.getDocument()) == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                window.eval(this.expression);
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "actionPerformed()", throwable);
            }
        }
    }

    private static class FunctionTimerTask
    extends WeakWindowTask {
        private final Integer timeIDInt;
        private final WeakReference functionRef;
        private final boolean removeTask;

        public FunctionTimerTask(Window window, Integer n, Function function, boolean bl) {
            super(window);
            this.timeIDInt = n;
            this.functionRef = new WeakReference<Function>(function);
            this.removeTask = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                HTMLDocumentImpl hTMLDocumentImpl;
                Window window = this.getWindow();
                if (window == null) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("actionPerformed(): Window is no longer available.");
                    }
                    return;
                }
                if (this.removeTask) {
                    window.forgetTask(this.timeIDInt, false);
                }
                if ((hTMLDocumentImpl = (HTMLDocumentImpl)window.getDocument()) == null) {
                    throw new IllegalStateException("Cannot perform operation when document is unset.");
                }
                Function function = (Function)this.functionRef.get();
                if (function == null) {
                    throw new IllegalStateException("Cannot perform operation. Function is no longer available.");
                }
                Executor.executeFunction(window.getWindowScope(), function, hTMLDocumentImpl.getDocumentURL(), window.getUserAgentContext());
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "actionPerformed()", throwable);
            }
        }
    }

    private static abstract class WeakWindowTask
    implements ActionListener {
        private final WeakReference windowRef;

        public WeakWindowTask(Window window) {
            this.windowRef = new WeakReference<Window>(window);
        }

        protected Window getWindow() {
            WeakReference weakReference = this.windowRef;
            return weakReference == null ? null : (Window)weakReference.get();
        }
    }
}

