/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.lobobrowser.html.domimpl.AttrImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NamedNodeMapImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.NodeListImpl;
import org.lobobrowser.html.parser.HtmlParser;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.Strings;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element {
    private final String name;
    protected Map attributes;
    private String id;

    public ElementImpl(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedNodeMap getAttributes() {
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            HashMap hashMap = this.attributes;
            if (hashMap == null) {
                this.attributes = hashMap = new HashMap();
            }
            return new NamedNodeMapImpl(this, this.attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttributes() {
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map map = this.attributes;
            return map == null ? false : !map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equalAttributes(Node node) {
        if (node instanceof ElementImpl) {
            ElementImpl elementImpl = this;
            synchronized (elementImpl) {
                Map map;
                Map map2 = this.attributes;
                if (map2 == null) {
                    map2 = Collections.EMPTY_MAP;
                }
                if ((map = ((ElementImpl)node).attributes) == null) {
                    map = Collections.EMPTY_MAP;
                }
                return Objects.equals(map2, map);
            }
        }
        return false;
    }

    public String getId() {
        String string = this.id;
        return string == null ? "" : string;
    }

    public void setId(String string) {
        this.setAttribute("id", string);
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public void setTitle(String string) {
        this.setAttribute("title", string);
    }

    public String getLang() {
        return this.getAttribute("lang");
    }

    public void setLang(String string) {
        this.setAttribute("lang", string);
    }

    public String getDir() {
        return this.getAttribute("dir");
    }

    public void setDir(String string) {
        this.setAttribute("dir", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getAttribute(String string) {
        String string2 = this.normalizeAttributeName(string);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map map = this.attributes;
            return map == null ? null : (String)map.get(string2);
        }
    }

    private Attr getAttr(String string, String string2) {
        return new AttrImpl(string, string2, true, this, "id".equals(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attr getAttributeNode(String string) {
        String string2 = this.normalizeAttributeName(string);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map map = this.attributes;
            String string3 = map == null ? null : (String)map.get(string2);
            return string3 == null ? null : this.getAttr(string2, string3);
        }
    }

    public Attr getAttributeNodeNS(String string, String string2) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public String getAttributeNS(String string, String string2) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    protected static boolean isTagName(Node node, String string) {
        return node.getNodeName().equalsIgnoreCase(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeList getElementsByTagName(String string) {
        boolean bl = "*".equals(string);
        LinkedList linkedList = new LinkedList();
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                for (Object e : arrayList) {
                    if (!(e instanceof Element)) continue;
                    Element element = (Element)e;
                    if (bl || ElementImpl.isTagName(element, string)) {
                        linkedList.add(e);
                    }
                    NodeList nodeList = element.getElementsByTagName(string);
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        linkedList.add(nodeList.item(i));
                    }
                }
            }
        }
        return new NodeListImpl(linkedList);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new DOMException(9, "Namespaces not supported");
    }

    public String getTagName() {
        return this.getNodeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAttribute(String string) {
        String string2 = this.normalizeAttributeName(string);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map map = this.attributes;
            return map == null ? false : map.containsKey(string2);
        }
    }

    public boolean hasAttributeNS(String string, String string2) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String string) throws DOMException {
        String string2 = this.normalizeAttributeName(string);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map map = this.attributes;
            if (map == null) {
                return;
            }
            map.remove(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attr removeAttributeNode(Attr attr) throws DOMException {
        String string = this.normalizeAttributeName(attr.getName());
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            Map map = this.attributes;
            if (map == null) {
                return null;
            }
            String string2 = (String)map.remove(string);
            Attr attr2 = string2 == null ? null : this.getAttr(string, string2);
            return attr2;
        }
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    protected void assignAttributeField(String string, String string2) {
        boolean bl = false;
        if ("id".equals(string) || (bl = "name".equals(string))) {
            HTMLDocumentImpl hTMLDocumentImpl;
            if (!bl) {
                this.id = string2;
            }
            if ((hTMLDocumentImpl = (HTMLDocumentImpl)this.document) != null) {
                hTMLDocumentImpl.setElementById(string2, this);
                if (bl) {
                    String string3 = this.getAttribute("name");
                    if (string3 != null) {
                        hTMLDocumentImpl.removeNamedItem(string3);
                    }
                    hTMLDocumentImpl.setNamedItem(string2, this);
                }
            }
        }
    }

    protected final String normalizeAttributeName(String string) {
        return string.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, String string2) throws DOMException {
        String string3 = this.normalizeAttributeName(string);
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            HashMap<String, String> hashMap = this.attributes;
            if (hashMap == null) {
                this.attributes = hashMap = new HashMap<String, String>(2);
            }
            hashMap.put(string3, string2);
        }
        this.assignAttributeField(string3, string2);
    }

    public void setAttributeImpl(String string, String string2) throws DOMException {
        String string3 = this.normalizeAttributeName(string);
        HashMap<String, String> hashMap = this.attributes;
        if (hashMap == null) {
            this.attributes = hashMap = new HashMap<String, String>(2);
        }
        this.assignAttributeField(string3, string2);
        hashMap.put(string3, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attr setAttributeNode(Attr attr) throws DOMException {
        String string = this.normalizeAttributeName(attr.getName());
        String string2 = attr.getValue();
        ElementImpl elementImpl = this;
        synchronized (elementImpl) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(string, string2);
        }
        this.assignAttributeField(string, string2);
        return attr;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public void setIdAttribute(String string, boolean bl) throws DOMException {
        String string2 = this.normalizeAttributeName(string);
        if (!"id".equals(string2)) {
            throw new DOMException(9, "IdAttribute can't be anything other than ID");
        }
    }

    public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
        String string = this.normalizeAttributeName(attr.getName());
        if (!"id".equals(string)) {
            throw new DOMException(9, "IdAttribute can't be anything other than ID");
        }
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
        throw new DOMException(9, "Namespaces not supported");
    }

    public String getLocalName() {
        return this.getNodeName();
    }

    public String getNodeName() {
        return this.name;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getRawInnerText(boolean bl) {
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                StringBuffer stringBuffer = null;
                while (iterator.hasNext()) {
                    String string;
                    Node node;
                    Object e = iterator.next();
                    if (e instanceof Text) {
                        node = (Text)e;
                        string = node.getNodeValue();
                        if ("".equals(string)) continue;
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        stringBuffer.append(string);
                        continue;
                    }
                    if (e instanceof ElementImpl) {
                        node = (ElementImpl)e;
                        string = ((ElementImpl)node).getRawInnerText(bl);
                        if ("".equals(string)) continue;
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        stringBuffer.append(string);
                        continue;
                    }
                    if (!bl || !(e instanceof Comment) || "".equals(string = (node = (Comment)e).getNodeValue())) continue;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(string);
                }
                return stringBuffer == null ? "" : stringBuffer.toString();
            }
            return "";
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getNodeName());
        stringBuffer.append(" [");
        NamedNodeMap namedNodeMap = this.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            stringBuffer.append(attr.getNodeName());
            stringBuffer.append('=');
            stringBuffer.append(attr.getNodeValue());
            if (i + 1 >= n) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInnerText(String string) {
        Document document = this.document;
        if (document == null) {
            this.warn("setInnerText(): Element " + this + " does not belong to a document.");
            return;
        }
        Object object = this.treeLock;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                arrayList.clear();
            }
        }
        object = document.createTextNode(string);
        this.appendChild((Node)object);
    }

    protected Node createSimilarNode() {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        return hTMLDocumentImpl == null ? null : hTMLDocumentImpl.createElement(this.getTagName());
    }

    protected String htmlEncodeChildText(String string) {
        if (HtmlParser.isDecodeEntities(this.name)) {
            return Strings.strictHtmlEncode(string, false);
        }
        return string;
    }
}

