/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.gjt.sp.util.StandardUtilities;

public class IOUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFile(File source, File dest) {
        boolean ok;
        block5: {
            ok = false;
            if ((!dest.exists() || !dest.canWrite()) && (dest.exists() || !dest.getParentFile().canWrite())) break block5;
            FileOutputStream fos = null;
            FileInputStream fis = null;
            try {
                fos = new FileOutputStream(dest);
                fis = new FileInputStream(source);
                ok = IOUtilities.copyStream(32768, null, fis, fos, false);
            }
            catch (IOException ioe) {
                try {
                    Log.log(7, IOUtilities.class, "Error moving file: " + ioe + " : " + ioe.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(fos);
                    IOUtilities.closeQuietly(fis);
                    throw throwable;
                }
                IOUtilities.closeQuietly(fos);
                IOUtilities.closeQuietly(fis);
            }
            IOUtilities.closeQuietly(fos);
            IOUtilities.closeQuietly(fis);
            if (ok) {
                source.delete();
            }
        }
        return ok;
    }

    public static boolean copyStream(int bufferSize, ProgressObserver progress, InputStream in, OutputStream out, boolean canStop) throws IOException {
        int n;
        byte[] buffer = new byte[bufferSize];
        long copied = 0L;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
            copied += (long)n;
            if (progress != null) {
                progress.setStatus(StandardUtilities.formatFileSize(copied));
                progress.setValue(copied);
            }
            if (!canStop || !Thread.interrupted()) continue;
            return false;
        }
        return true;
    }

    public static boolean copyStream(ProgressObserver progress, InputStream in, OutputStream out, boolean canStop) throws IOException {
        return IOUtilities.copyStream(4096, progress, in, out, canStop);
    }

    public static long fileLength(File file) {
        long length = 0L;
        if (file.isFile()) {
            length = file.length();
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                length += IOUtilities.fileLength(files[i]);
            }
        }
        return length;
    }

    public static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream out) {
        if (out != null) {
            try {
                out.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Reader r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Writer out) {
        if (out != null) {
            try {
                out.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                if (closeable instanceof Flushable) {
                    ((Flushable)((Object)closeable)).flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private IOUtilities() {
    }
}

