/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.WorkThreadPool;

public class VFSManager {
    public static final String SERVICE = "org.gjt.sp.jedit.io.VFS";
    private static WorkThreadPool ioThreadPool;
    private static VFS fileVFS;
    private static VFS urlVFS;
    private static boolean error;
    private static final Object errorLock;
    private static final Vector<ErrorListDialog.ErrorEntry> errors;
    private static final Object vfsUpdateLock;
    private static final List<VFSUpdate> vfsUpdates;

    public static void init() {
        int count = jEdit.getIntegerProperty("ioThreadCount", 4);
        ioThreadPool = new WorkThreadPool("jEdit I/O", count);
        JARClassLoader classLoader = new JARClassLoader();
        for (int i = 0; i < ioThreadPool.getThreadCount(); ++i) {
            ioThreadPool.getThread(i).setContextClassLoader(classLoader);
        }
    }

    public static void start() {
        ioThreadPool.start();
    }

    public static VFS getFileVFS() {
        return fileVFS;
    }

    public static VFS getUrlVFS() {
        return urlVFS;
    }

    public static VFS getVFSForProtocol(String protocol) {
        if (protocol.equals("file")) {
            return fileVFS;
        }
        VFS vfs = (VFS)ServiceManager.getService(SERVICE, protocol);
        if (vfs != null) {
            return vfs;
        }
        return urlVFS;
    }

    public static VFS getVFSForPath(String path) {
        if (MiscUtilities.isURL(path)) {
            return VFSManager.getVFSForProtocol(MiscUtilities.getProtocolOfURL(path));
        }
        return fileVFS;
    }

    public static String[] getVFSs() {
        LinkedList<String> returnValue = new LinkedList<String>();
        String[] newAPI = ServiceManager.getServiceNames(SERVICE);
        if (newAPI != null) {
            for (int i = 0; i < newAPI.length; ++i) {
                returnValue.add(newAPI[i]);
            }
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    public static WorkThreadPool getIOThreadPool() {
        return ioThreadPool;
    }

    public static void waitForRequests() {
        ioThreadPool.waitForRequests();
    }

    public static boolean errorOccurred() {
        return error;
    }

    public static int getRequestCount() {
        return ioThreadPool.getRequestCount();
    }

    @Deprecated
    public static void runInAWTThread(Runnable run) {
        ioThreadPool.addWorkRequest(run, true);
    }

    @Deprecated
    public static void runInWorkThread(Runnable run) {
        ioThreadPool.addWorkRequest(run, false);
    }

    public static void error(IOException e, String path, Component comp) {
        Log.log(9, VFSManager.class, e);
        VFSManager.error(comp, path, "ioerror", new String[]{e.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(Component comp, String path, String messageProp, Object[] args) {
        final Frame frame = JOptionPane.getFrameForComponent(comp);
        Object object = errorLock;
        synchronized (object) {
            error = true;
            errors.add(new ErrorListDialog.ErrorEntry(path, messageProp, args));
            if (errors.size() == 1) {
                VFSManager.runInAWTThread(new Runnable(){

                    @Override
                    public void run() {
                        String caption = jEdit.getProperty("ioerror.caption" + (errors.size() == 1 ? "-1" : ""), new Integer[]{errors.size()});
                        new ErrorListDialog(frame.isShowing() ? frame : jEdit.getFirstView(), jEdit.getProperty("ioerror.title"), caption, errors, false);
                        errors.clear();
                        error = false;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendVFSUpdate(VFS vfs, String path, boolean parent) {
        if (parent) {
            VFSManager.sendVFSUpdate(vfs, vfs.getParentOfPath(path), false);
            VFSManager.sendVFSUpdate(vfs, path, false);
        } else {
            if (path.length() != 1 && (path.endsWith("/") || path.endsWith(File.separator))) {
                path = path.substring(0, path.length() - 1);
            }
            Object object = vfsUpdateLock;
            synchronized (object) {
                for (int i = 0; i < vfsUpdates.size(); ++i) {
                    VFSUpdate msg = vfsUpdates.get(i);
                    if (!msg.getPath().equals(path)) continue;
                    return;
                }
                vfsUpdates.add(new VFSUpdate(path));
                if (vfsUpdates.size() == 1) {
                    VFSManager.runInAWTThread(new SendVFSUpdatesSafely());
                }
            }
        }
    }

    private VFSManager() {
    }

    static {
        errorLock = new Object();
        vfsUpdateLock = new Object();
        errors = new Vector();
        fileVFS = new FileVFS();
        urlVFS = new UrlVFS();
        vfsUpdates = new ArrayList<VFSUpdate>(10);
    }

    static class SendVFSUpdatesSafely
    implements Runnable {
        SendVFSUpdatesSafely() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = vfsUpdateLock;
            synchronized (object) {
                Collections.sort(vfsUpdates, new StandardUtilities.StringCompare());
                for (int i = 0; i < vfsUpdates.size(); ++i) {
                    EditBus.send((EBMessage)vfsUpdates.get(i));
                }
                vfsUpdates.clear();
            }
        }
    }
}

