/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class EnhancedButton
extends RolloverButton {
    private String action;

    public EnhancedButton(Icon icon, String toolTip, String action, ActionContext context) {
        super(icon);
        this.action = action;
        if (action != null) {
            int iSuffix = action.lastIndexOf(46);
            if (iSuffix < 0 || iSuffix == action.length() - 1) {
                this.setName(action);
            } else {
                this.setName(action.substring(iSuffix + 1));
            }
            this.setEnabled(true);
            this.addActionListener(new EditAction.Wrapper(context, action));
            this.addMouseListener(new MouseHandler());
        } else {
            this.setEnabled(false);
        }
        this.setToolTipText(toolTip);
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    class MouseHandler
    extends MouseAdapter {
        boolean msgSet = false;

        MouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            String msg = jEdit.getProperty(EnhancedButton.this.action + ".mouse-over");
            if (msg != null) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(msg);
                this.msgSet = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (this.msgSet) {
                GUIUtilities.getView((Component)evt.getSource()).getStatus().setMessage(null);
                this.msgSet = false;
            }
        }
    }
}

