/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.RegisterSaver;
import org.gjt.sp.jedit.RegistersListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.datatransfer.JEditDataFlavor;
import org.gjt.sp.jedit.datatransfer.JEditRichText;
import org.gjt.sp.jedit.datatransfer.TransferHandler;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class Registers {
    private static Register[] registers = new Register[256];
    private static boolean loaded;
    private static boolean loading;
    private static RegisterSaver saver;
    private static RegistersListener listener;
    private static boolean modified;

    public static void copy(TextArea textArea, char register) {
        String selection = textArea.getSelectedText();
        if (selection == null) {
            return;
        }
        Transferable transferable = TransferHandler.getInstance().getTransferable(textArea, selection);
        Registers.setRegister(register, transferable);
        HistoryModel.getModel("clipboard").addItem(selection);
    }

    public static void cut(TextArea textArea, char register) {
        if (textArea.isEditable()) {
            String selection = textArea.getSelectedText();
            if (selection == null) {
                return;
            }
            Transferable transferable = TransferHandler.getInstance().getTransferable(textArea, selection);
            Registers.setRegister(register, transferable);
            HistoryModel.getModel("clipboard").addItem(selection);
            textArea.setSelectedText("");
        } else {
            textArea.getToolkit().beep();
        }
    }

    public static void append(TextArea textArea, char register) {
        Registers.append(textArea, register, "\n", false);
    }

    public static void append(TextArea textArea, char register, String separator) {
        Registers.append(textArea, register, separator, false);
    }

    public static void append(TextArea textArea, char register, String separator, boolean cut) {
        Transferable transferable;
        if (cut && !textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        String selection = textArea.getSelectedText();
        if (selection == null) {
            return;
        }
        Register reg = Registers.getRegister(register);
        if (reg != null && (transferable = reg.getTransferable()).isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String registerContents = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (registerContents != null) {
                    selection = registerContents.endsWith(separator) ? registerContents + selection : registerContents + separator + selection;
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException e) {
                Log.log(9, Registers.class, e);
            }
        }
        transferable = TransferHandler.getInstance().getTransferable(textArea, selection);
        Registers.setRegister(register, transferable);
        HistoryModel.getModel("clipboard").addItem(selection);
        if (cut) {
            textArea.setSelectedText("");
        }
    }

    public static void paste(TextArea textArea, char register) {
        Registers.paste(textArea, register, false);
    }

    public static void paste(TextArea textArea, char register, DataFlavor preferredDataFlavor) {
        Registers.paste(textArea, register, false, preferredDataFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paste(TextArea textArea, char register, boolean vertical) {
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        Register reg = Registers.getRegister(register);
        if (reg == null) {
            textArea.getToolkit().beep();
            return;
        }
        Transferable transferable = reg.getTransferable();
        Mode mode = null;
        String selection = null;
        if (transferable.isDataFlavorSupported(JEditDataFlavor.jEditRichTextDataFlavor)) {
            try {
                JEditRichText data = (JEditRichText)transferable.getTransferData(JEditDataFlavor.jEditRichTextDataFlavor);
                mode = data.getMode();
                selection = data.getText();
            }
            catch (UnsupportedFlavorException e) {
                Log.log(9, Registers.class, e);
            }
            catch (IOException e) {
                Log.log(9, Registers.class, e);
            }
        } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            selection = Registers.getTextFromTransferable(transferable, DataFlavor.stringFlavor);
        }
        if (selection == null) {
            textArea.getToolkit().beep();
            return;
        }
        JEditBuffer buffer = textArea.getBuffer();
        Registers.applyMode(mode, buffer);
        try {
            buffer.beginCompoundEdit();
            if (vertical && textArea.getSelectionCount() == 0) {
                int caret = textArea.getCaretPosition();
                int caretLine = textArea.getCaretLine();
                Selection.Rect rect = new Selection.Rect(caretLine, caret, caretLine, caret);
                textArea.setSelectedText(rect, selection);
                caretLine = textArea.getCaretLine();
                if (caretLine != textArea.getLineCount() - 1) {
                    int startColumn = rect.getStartColumn(buffer);
                    int offset = buffer.getOffsetOfVirtualColumn(caretLine + 1, startColumn, null);
                    if (offset == -1) {
                        buffer.insertAtColumn(caretLine + 1, startColumn, "");
                        textArea.setCaretPosition(buffer.getLineEndOffset(caretLine + 1) - 1);
                    } else {
                        textArea.setCaretPosition(buffer.getLineStartOffset(caretLine + 1) + offset);
                    }
                }
            } else {
                textArea.replaceSelection(selection);
            }
        }
        finally {
            buffer.endCompoundEdit();
        }
        HistoryModel.getModel("clipboard").addItem(selection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paste(TextArea textArea, char register, boolean vertical, DataFlavor preferredDataFlavor) {
        if (JEditDataFlavor.jEditRichTextDataFlavor.equals(preferredDataFlavor)) {
            Registers.paste(textArea, register, vertical);
            return;
        }
        if (!textArea.isEditable()) {
            textArea.getToolkit().beep();
            return;
        }
        Register reg = Registers.getRegister(register);
        if (reg == null) {
            textArea.getToolkit().beep();
            return;
        }
        Transferable transferable = reg.getTransferable();
        String selection = null;
        if (transferable.isDataFlavorSupported(preferredDataFlavor)) {
            selection = Registers.getTextFromTransferable(transferable, preferredDataFlavor);
        } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            selection = Registers.getTextFromTransferable(transferable, DataFlavor.stringFlavor);
        }
        if (selection == null) {
            textArea.getToolkit().beep();
            return;
        }
        JEditBuffer buffer = textArea.getBuffer();
        try {
            buffer.beginCompoundEdit();
            if (vertical && textArea.getSelectionCount() == 0) {
                int caret = textArea.getCaretPosition();
                int caretLine = textArea.getCaretLine();
                Selection.Rect rect = new Selection.Rect(caretLine, caret, caretLine, caret);
                textArea.setSelectedText(rect, selection);
                caretLine = textArea.getCaretLine();
                if (caretLine != textArea.getLineCount() - 1) {
                    int startColumn = rect.getStartColumn(buffer);
                    int offset = buffer.getOffsetOfVirtualColumn(caretLine + 1, startColumn, null);
                    if (offset == -1) {
                        buffer.insertAtColumn(caretLine + 1, startColumn, "");
                        textArea.setCaretPosition(buffer.getLineEndOffset(caretLine + 1) - 1);
                    } else {
                        textArea.setCaretPosition(buffer.getLineStartOffset(caretLine + 1) + offset);
                    }
                }
            } else {
                textArea.replaceSelection(selection);
            }
        }
        finally {
            buffer.endCompoundEdit();
        }
        HistoryModel.getModel("clipboard").addItem(selection);
    }

    private static void applyMode(Mode mode, JEditBuffer buffer) {
        if (mode != null && "text".equals(buffer.getMode().getName()) && !mode.equals(buffer.getMode()) && buffer.getLength() == 0) {
            buffer.setMode(mode);
        }
    }

    private static String getTextFromTransferable(Transferable transferable, DataFlavor dataFlavor) {
        try {
            Object data = transferable.getTransferData(dataFlavor);
            return Registers.stripEOLChars(data.toString());
        }
        catch (UnsupportedFlavorException e) {
            Log.log(9, Registers.class, e);
        }
        catch (IOException e) {
            Log.log(9, Registers.class, e);
        }
        return null;
    }

    public static Register getRegister(char name) {
        if (name != '$' && name != '%' && !loaded) {
            Registers.loadRegisters();
        }
        if (registers == null || name >= registers.length) {
            return null;
        }
        return registers[name];
    }

    public static void setRegister(char name, Register newRegister) {
        Registers.touchRegister(name);
        if (name >= registers.length) {
            Register[] newRegisters = new Register[Math.min(65536, name << 1)];
            System.arraycopy(registers, 0, newRegisters, 0, registers.length);
            registers = newRegisters;
        }
        Registers.registers[name] = newRegister;
        if (listener != null) {
            listener.registerChanged(name);
        }
    }

    public static void setRegister(char name, String value) {
        Registers.setRegister(name, new StringSelection(value));
    }

    public static void setRegister(char name, Transferable transferable) {
        Registers.touchRegister(name);
        Register register = Registers.getRegister(name);
        if (register != null) {
            register.setTransferable(transferable);
            if (listener != null) {
                listener.registerChanged(name);
            }
        } else {
            DefaultRegister defaultRegister = new DefaultRegister();
            defaultRegister.setTransferable(transferable);
            Registers.setRegister(name, defaultRegister);
        }
    }

    public static void clearRegister(char name) {
        if (name >= registers.length) {
            return;
        }
        Register register = registers[name];
        if (name == '$' || name == '%') {
            register.setTransferable(new StringSelection(""));
        } else {
            Registers.registers[name] = null;
            modified = true;
            if (listener != null) {
                listener.registerChanged(name);
            }
        }
    }

    public static Register[] getRegisters() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        return registers;
    }

    public static String getRegisterNameString() {
        if (!loaded) {
            Registers.loadRegisters();
        }
        StringBuilder buf = new StringBuilder(registers.length << 1);
        for (int i = 0; i < registers.length; ++i) {
            if (registers[i] == null) continue;
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append((char)i);
        }
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    public static void saveRegisters() {
        if (!loaded || !modified) {
            return;
        }
        if (saver != null) {
            saver.saveRegisters();
            modified = false;
        }
    }

    public static void setListener(RegistersListener listener) {
        Registers.listener = listener;
    }

    public static void setSaver(RegisterSaver saver) {
        Registers.saver = saver;
    }

    public static boolean isLoading() {
        return loading;
    }

    public static void setLoading(boolean loading) {
        Registers.loading = loading;
    }

    private Registers() {
    }

    private static void touchRegister(char name) {
        if (name == '%' || name == '$') {
            return;
        }
        if (!loaded) {
            Registers.loadRegisters();
        }
        if (!loading) {
            modified = true;
        }
    }

    private static void loadRegisters() {
        if (saver != null) {
            loaded = true;
            saver.loadRegisters();
        }
    }

    private static String stripEOLChars(String selection) throws IOException {
        String line;
        boolean trailingEOL = selection.endsWith("\n") || selection.endsWith(System.getProperty("line.separator"));
        BufferedReader in = new BufferedReader(new StringReader(selection));
        StringBuilder buf = new StringBuilder(selection.length());
        while ((line = in.readLine()) != null) {
            if (line.endsWith("\u0000")) {
                line = line.substring(0, line.length() - 1);
            }
            buf.append(line);
            buf.append('\n');
        }
        if (!trailingEOL && buf.length() != 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    protected static void debugListDataFlavors(Transferable transferable) {
        DataFlavor[] dataFlavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < dataFlavors.length; ++i) {
            DataFlavor dataFlavor = dataFlavors[i];
            Log.log(1, Registers.class, "debugListDataFlavors(): dataFlavor=" + dataFlavor + '.');
        }
        if (dataFlavors.length == 0) {
            Log.log(1, Registers.class, "debugListDataFlavors(): no dataFlavor supported.");
        }
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Registers.registers[36] = new ClipboardRegister(toolkit.getSystemClipboard());
        Clipboard selection = toolkit.getSystemSelection();
        if (selection != null) {
            Registers.registers[37] = new ClipboardRegister(selection);
        }
    }

    private static class DefaultRegister
    implements Register {
        private Transferable transferable;

        private DefaultRegister() {
        }

        @Override
        public void setValue(String value) {
            this.transferable = new StringSelection(value);
        }

        @Override
        public String toString() {
            if (this.transferable == null) {
                return null;
            }
            if (this.transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    return this.transferable.getTransferData(DataFlavor.stringFlavor).toString();
                }
                catch (UnsupportedFlavorException e) {
                    Log.log(9, this, e);
                }
                catch (IOException e) {
                    Log.log(9, this, e);
                }
            }
            return this.transferable.toString();
        }

        @Override
        public Transferable getTransferable() {
            return this.transferable;
        }

        @Override
        public void setTransferable(Transferable transferable) {
            this.transferable = transferable;
        }
    }

    public static class ClipboardRegister
    implements Register {
        Clipboard clipboard;

        public ClipboardRegister(Clipboard clipboard) {
            this.clipboard = clipboard;
        }

        @Override
        public void setValue(String value) {
            StringSelection selection = new StringSelection(value);
            this.clipboard.setContents(selection, null);
        }

        @Override
        public String toString() {
            try {
                String selection = (String)this.clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                return Registers.stripEOLChars(selection);
            }
            catch (Exception e) {
                Log.log(5, this, e);
                return null;
            }
        }

        @Override
        public Transferable getTransferable() {
            return this.clipboard.getContents(this);
        }

        @Override
        public void setTransferable(Transferable transferable) {
            this.clipboard.setContents(transferable, null);
        }
    }

    public static interface Register {
        @Deprecated
        public String toString();

        @Deprecated
        public void setValue(String var1);

        public Transferable getTransferable();

        public void setTransferable(Transferable var1);
    }
}

