/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.MalformedInputException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.AutoDetection;
import org.gjt.sp.jedit.io.EncodingServer;
import org.gjt.sp.jedit.io.UrlVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class MiscUtilities {
    static final String varPatternString = "(\\$([a-zA-Z0-9_]+))";
    static final String varPatternString2 = "(\\$\\{([^}]+)\\})";
    static final String winPatternString = "(%([^%]+)%)";
    static final Pattern varPattern = Pattern.compile("(\\$([a-zA-Z0-9_]+))");
    static final Pattern varPattern2 = Pattern.compile("(\\$\\{([^}]+)\\})");
    static final Pattern winPattern = Pattern.compile("(%([^%]+)%)");
    static VarCompressor svc = null;

    public static String canonPath(String path) {
        if (path.length() == 0) {
            return path;
        }
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        } else if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        } else if (MiscUtilities.isURL(path)) {
            return path;
        }
        if (File.separatorChar == '\\') {
            path = path.replace('/', '\\');
            int trim = path.length();
            while (path.charAt(trim - 1) == ' ') {
                --trim;
            }
            if (path.charAt(trim - 1) == '\\') {
                while (trim > 1 && path.charAt(trim - 2) == '\\') {
                    --trim;
                }
            }
            path = path.substring(0, trim);
        }
        if (path.startsWith('~' + File.separator)) {
            path = path.substring(2);
            String home = System.getProperty("user.home");
            if (home.endsWith(File.separator)) {
                return home + path;
            }
            return home + File.separator + path;
        }
        if ("~".equals(path)) {
            return System.getProperty("user.home");
        }
        if ("-".equals(path)) {
            return MiscUtilities.getParentOfPath(jEdit.getActiveView().getBuffer().getPath());
        }
        return path;
    }

    public static String expandVariables(String arg) {
        if (arg.startsWith("~/") || arg.startsWith("~\\")) {
            return System.getProperty("user.home") + arg.substring(1);
        }
        Pattern p = varPattern;
        Matcher m = p.matcher(arg);
        if (!m.find() && !(m = (p = OperatingSystem.isWindows() ? winPattern : varPattern2).matcher(arg)).find()) {
            return arg;
        }
        String varName = m.group(2);
        String expansion = System.getenv(varName);
        if (expansion == null) {
            varName = varName.toUpperCase();
            String uparg = arg.toUpperCase();
            m = p.matcher(uparg);
            expansion = System.getenv(varName);
        }
        if (expansion != null) {
            expansion = expansion.replace("\\", "\\\\");
            return m.replaceFirst(expansion);
        }
        return arg;
    }

    public static String abbreviate(String path) {
        if (svc == null) {
            svc = new VarCompressor();
        }
        return svc.compress(path);
    }

    public static String resolveSymlinks(String path) {
        if (MiscUtilities.isURL(path)) {
            return path;
        }
        if (OperatingSystem.isOS2()) {
            return path;
        }
        if (OperatingSystem.isDOSDerived() && (path.length() == 2 || path.length() == 3) && path.charAt(1) == ':') {
            return path;
        }
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException io) {
            return path;
        }
    }

    public static boolean isAbsolutePath(String path) {
        if (MiscUtilities.isURL(path)) {
            return true;
        }
        if (path.startsWith("~/") || path.startsWith('~' + File.separator) || "~".equals(path)) {
            return true;
        }
        if ("-".equals(path)) {
            return true;
        }
        if (OperatingSystem.isDOSDerived()) {
            if (path.length() == 2 && path.charAt(1) == ':') {
                return true;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && (path.charAt(2) == '\\' || path.charAt(2) == '/')) {
                return true;
            }
            if (path.startsWith("\\\\") || path.startsWith("//")) {
                return true;
            }
        } else if ((OperatingSystem.isUnix() || OperatingSystem.isVMS()) && path.length() > 0 && path.charAt(0) == '/') {
            return true;
        }
        return false;
    }

    public static String constructPath(String parent, String path) {
        if (MiscUtilities.isAbsolutePath(path)) {
            return MiscUtilities.canonPath(path);
        }
        if (parent == null) {
            parent = System.getProperty("user.dir");
        }
        if (path == null || path.length() == 0) {
            return parent;
        }
        if (OperatingSystem.isDOSDerived()) {
            if (path.length() == 2 && path.charAt(1) == ':') {
                return path;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) != '\\') {
                path = path.substring(0, 2) + '\\' + path.substring(2);
                return MiscUtilities.canonPath(path);
            }
        }
        String dd = ".." + File.separator;
        String d = '.' + File.separator;
        while (true) {
            if (".".equals(path)) {
                return parent;
            }
            if ("..".equals(path)) {
                return MiscUtilities.getParentOfPath(parent);
            }
            if (path.startsWith(dd) || path.startsWith("../")) {
                parent = MiscUtilities.getParentOfPath(parent);
                path = path.substring(3);
                continue;
            }
            if (!path.startsWith(d) && !path.startsWith("./")) break;
            path = path.substring(2);
        }
        if (path.length() == 0) {
            return parent;
        }
        if (OperatingSystem.isDOSDerived() && !MiscUtilities.isURL(parent) && path.charAt(0) == '\\') {
            parent = parent.substring(0, 2);
        }
        VFS vfs = VFSManager.getVFSForPath(parent);
        return MiscUtilities.canonPath(vfs.constructPath(parent, path));
    }

    public static String constructPath(String parent, String path1, String path2) {
        return MiscUtilities.constructPath(MiscUtilities.constructPath(parent, path1), path2);
    }

    public static String concatPath(String parent, String path) {
        parent = MiscUtilities.canonPath(parent);
        if ((path = MiscUtilities.canonPath(path)).startsWith(File.separator)) {
            path = path.substring(1);
        } else if (path.length() >= 3 && path.charAt(1) == ':') {
            path = path.replace(':', File.separatorChar);
        }
        if (parent == null) {
            parent = System.getProperty("user.dir");
        }
        if (parent.endsWith(File.separator)) {
            return parent + path;
        }
        return parent + File.separator + path;
    }

    public static int getFirstSeparatorIndex(String path) {
        int start = MiscUtilities.getPathStart(path);
        int index = path.indexOf(47, start);
        if (index == -1) {
            index = path.indexOf(File.separatorChar, start);
        }
        return index;
    }

    public static int getLastSeparatorIndex(String path) {
        int index;
        int start = MiscUtilities.getPathStart(path);
        if (start != 0) {
            path = path.substring(start);
        }
        if ((index = Math.max(path.lastIndexOf(47), path.lastIndexOf(File.separatorChar))) == -1) {
            return index;
        }
        return index + start;
    }

    public static String getFileExtension(String path) {
        int fsIndex = MiscUtilities.getLastSeparatorIndex(path);
        int index = path.lastIndexOf(46);
        if (index == -1 || index < fsIndex) {
            return "";
        }
        return path.substring(index);
    }

    public static String getFileName(String path) {
        return VFSManager.getVFSForPath(path).getFileName(path);
    }

    public static String getFileNameNoExtension(String path) {
        String name = MiscUtilities.getFileName(path);
        int index = name.indexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    public static String getParentOfPath(String path) {
        return VFSManager.getVFSForPath(path).getParentOfPath(path);
    }

    public static String getProtocolOfURL(String url) {
        return url.substring(0, url.indexOf(58));
    }

    public static boolean isURL(String str) {
        int fsIndex = MiscUtilities.getLastSeparatorIndex(str);
        if (fsIndex == 0) {
            return false;
        }
        if (fsIndex == 2) {
            return false;
        }
        int cIndex = str.indexOf(58);
        if (cIndex <= 1) {
            return false;
        }
        String protocol = str.substring(0, cIndex);
        VFS vfs = VFSManager.getVFSForProtocol(protocol);
        if (vfs != null && !(vfs instanceof UrlVFS)) {
            return true;
        }
        try {
            new URL(str);
            return true;
        }
        catch (MalformedURLException mf) {
            return false;
        }
    }

    public static void saveBackup(File file, int backups, String backupPrefix, String backupSuffix, String backupDirectory) {
        MiscUtilities.saveBackup(file, backups, backupPrefix, backupSuffix, backupDirectory, 0);
    }

    public static void saveBackup(File file, int backups, String backupPrefix, String backupSuffix, String backupDirectory, int backupTimeDistance) {
        if (backupPrefix == null) {
            backupPrefix = "";
        }
        if (backupSuffix == null) {
            backupSuffix = "";
        }
        String name = file.getName();
        if (backups == 1) {
            File backupFile = new File(backupDirectory, backupPrefix + name + backupSuffix);
            long modTime = backupFile.lastModified();
            if (System.currentTimeMillis() - modTime >= (long)backupTimeDistance) {
                Log.log(1, MiscUtilities.class, "Saving backup of file \"" + file.getAbsolutePath() + "\" to \"" + backupFile.getAbsolutePath() + '\"');
                backupFile.delete();
                if (!file.renameTo(backupFile)) {
                    IOUtilities.moveFile(file, backupFile);
                }
            }
        } else {
            new File(backupDirectory, backupPrefix + name + backupSuffix + backups + backupSuffix).delete();
            File firstBackup = new File(backupDirectory, backupPrefix + name + backupSuffix + '1' + backupSuffix);
            long modTime = firstBackup.lastModified();
            if (System.currentTimeMillis() - modTime >= (long)backupTimeDistance) {
                for (int i = backups - 1; i > 0; --i) {
                    File backup = new File(backupDirectory, backupPrefix + name + backupSuffix + i + backupSuffix);
                    backup.renameTo(new File(backupDirectory, backupPrefix + name + backupSuffix + (i + 1) + backupSuffix));
                }
                File backupFile = new File(backupDirectory, backupPrefix + name + backupSuffix + '1' + backupSuffix);
                Log.log(1, MiscUtilities.class, "Saving backup of file \"" + file.getAbsolutePath() + "\" to \"" + backupFile.getAbsolutePath() + '\"');
                if (!file.renameTo(backupFile)) {
                    IOUtilities.moveFile(file, backupFile);
                }
            }
        }
    }

    public static boolean isBinary(InputStream in) throws IOException {
        AutoDetection.Result detection = new AutoDetection.Result(in);
        if (detection.getDetectedEncoding() != null) {
            return false;
        }
        try {
            return MiscUtilities.containsNullCharacter(new InputStreamReader(detection.getRewindedStream()));
        }
        catch (MalformedInputException mie) {
            return true;
        }
    }

    public static boolean isBackup(String filename) {
        if (filename.startsWith("#")) {
            return true;
        }
        if (filename.endsWith("~")) {
            return true;
        }
        return filename.endsWith(".bak");
    }

    public static Reader autodetect(InputStream in, Buffer buffer) throws IOException {
        String encoding = buffer == null ? System.getProperty("file.encoding") : buffer.getStringProperty("encoding");
        boolean gzipped = false;
        if (buffer == null || buffer.getBooleanProperty("encodingAutodetect")) {
            String detected;
            AutoDetection.Result detection = new AutoDetection.Result(in);
            gzipped = detection.streamIsGzipped();
            if (gzipped) {
                Log.log(1, MiscUtilities.class, "Stream is Gzipped");
            }
            if ((detected = detection.getDetectedEncoding()) != null) {
                encoding = detected;
                Log.log(1, MiscUtilities.class, "Stream encoding detected is " + detected);
            }
            in = detection.getRewindedStream();
        } else {
            in = AutoDetection.getMarkedStream(in);
        }
        Reader result = EncodingServer.getTextReader(in, encoding);
        if (buffer != null) {
            if (gzipped) {
                buffer.setBooleanProperty("gzipped", true);
            }
            buffer.setProperty("encoding", encoding);
        }
        return result;
    }

    public static String fileToClass(String name) {
        char[] clsName = name.toCharArray();
        for (int i = clsName.length - 6; i >= 0; --i) {
            if (clsName[i] != '/') continue;
            clsName[i] = 46;
        }
        return new String(clsName, 0, clsName.length - 6);
    }

    public static String classToFile(String name) {
        return name.replace('.', '/').concat(".class");
    }

    public static boolean pathsEqual(String p1, String p2) {
        VFS v2;
        VFS v1 = VFSManager.getVFSForPath(p1);
        if (v1 != (v2 = VFSManager.getVFSForPath(p2))) {
            return false;
        }
        if (p1.endsWith("/") || p1.endsWith(File.separator)) {
            p1 = p1.substring(0, p1.length() - 1);
        }
        if (p2.endsWith("/") || p2.endsWith(File.separator)) {
            p2 = p2.substring(0, p2.length() - 1);
        }
        if ((v1.getCapabilities() & 0x80) != 0) {
            return p1.equalsIgnoreCase(p2);
        }
        return p1.equals(p2);
    }

    public static String escapesToChars(String str) {
        StringBuilder buf = new StringBuilder();
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\\': {
                    if (i == str.length() - 1) {
                        buf.append('\\');
                        continue block7;
                    }
                    c = str.charAt(++i);
                    switch (c) {
                        case 'n': {
                            buf.append('\n');
                            continue block7;
                        }
                        case 't': {
                            buf.append('\t');
                            continue block7;
                        }
                    }
                    buf.append(c);
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String getLongestPrefix(List<String> str, boolean ignoreCase) {
        String s;
        int prefixLength;
        if (str.isEmpty()) {
            return "";
        }
        block0: for (prefixLength = 0; prefixLength < (s = str.get(0)).length(); ++prefixLength) {
            char ch = s.charAt(prefixLength);
            for (int i = 1; i < str.size(); ++i) {
                s = str.get(i);
                if (prefixLength >= s.length() || !MiscUtilities.compareChars(s.charAt(prefixLength), ch, ignoreCase)) break block0;
            }
        }
        return str.get(0).substring(0, prefixLength);
    }

    public static String getLongestPrefix(String[] str, boolean ignoreCase) {
        return MiscUtilities.getLongestPrefix((Object[])str, ignoreCase);
    }

    public static String getLongestPrefix(Object[] str, boolean ignoreCase) {
        int prefixLength;
        if (str.length == 0) {
            return "";
        }
        String first = str[0].toString();
        block0: for (prefixLength = 0; prefixLength < first.length(); ++prefixLength) {
            char ch = first.charAt(prefixLength);
            for (int i = 1; i < str.length; ++i) {
                String s = str[i].toString();
                if (prefixLength >= s.length() || !MiscUtilities.compareChars(s.charAt(prefixLength), ch, ignoreCase)) break block0;
            }
        }
        return first.substring(0, prefixLength);
    }

    public static String buildToVersion(String build) {
        if (build.length() != 11) {
            return "<unknown version: " + build + '>';
        }
        int major = Integer.parseInt(build.substring(0, 2));
        int minor = Integer.parseInt(build.substring(3, 5));
        int beta = Integer.parseInt(build.substring(6, 8));
        int bugfix = Integer.parseInt(build.substring(9, 11));
        return major + "." + minor + (beta != 99 ? "pre" + beta : (bugfix != 0 ? "." + bugfix : ""));
    }

    public static boolean isToolsJarAvailable() {
        Log.log(1, MiscUtilities.class, "Searching for tools.jar...");
        LinkedList<String> paths = new LinkedList<String>();
        paths.add("System classpath: " + System.getProperty("java.class.path"));
        try {
            try {
                Class.forName("sun.tools.javac.Main");
            }
            catch (ClassNotFoundException e1) {
                Class.forName("com.sun.tools.javac.Main");
            }
            Log.log(1, MiscUtilities.class, "- is in classpath. Fine.");
            return true;
        }
        catch (ClassNotFoundException e) {
            String toolsPath;
            String jEditDir;
            String settingsDir = jEdit.getSettingsDirectory();
            if (settingsDir != null) {
                String toolsPath2 = MiscUtilities.constructPath(settingsDir, "jars", "tools.jar");
                paths.add(toolsPath2);
                if (new File(toolsPath2).exists()) {
                    Log.log(1, MiscUtilities.class, "- is in the user's jars folder. Fine.");
                    return true;
                }
            }
            if ((jEditDir = jEdit.getJEditHome()) != null) {
                toolsPath = MiscUtilities.constructPath(jEditDir, "jars", "tools.jar");
                paths.add(toolsPath);
                if (new File(toolsPath).exists()) {
                    Log.log(1, MiscUtilities.class, "- is in jEdit's system jars folder. Fine.");
                    return true;
                }
            }
            if ((toolsPath = System.getProperty("java.home")).toLowerCase().endsWith(File.separator + "jre")) {
                toolsPath = toolsPath.substring(0, toolsPath.length() - 4);
            }
            toolsPath = MiscUtilities.constructPath(toolsPath, "lib", "tools.jar");
            paths.add(toolsPath);
            if (!new File(toolsPath).exists()) {
                Log.log(7, MiscUtilities.class, "Could not find tools.jar.\nI checked the following locations:\n" + ((Object)paths).toString());
                return false;
            }
            PluginJAR jar = jEdit.getPluginJAR(toolsPath);
            if (jar == null) {
                Log.log(1, MiscUtilities.class, "- adding " + toolsPath + " to jEdit plugins.");
                jEdit.addPluginJAR(toolsPath);
            } else {
                Log.log(1, MiscUtilities.class, "- has been loaded before.");
            }
            return true;
        }
    }

    public static int parsePermissions(String s) {
        int permissions = 0;
        if (s.length() == 9) {
            if (s.charAt(0) == 'r') {
                permissions += 256;
            }
            if (s.charAt(1) == 'w') {
                permissions += 128;
            }
            if (s.charAt(2) == 'x') {
                permissions += 64;
            } else if (s.charAt(2) == 's') {
                permissions += 2112;
            } else if (s.charAt(2) == 'S') {
                permissions += 2048;
            }
            if (s.charAt(3) == 'r') {
                permissions += 32;
            }
            if (s.charAt(4) == 'w') {
                permissions += 16;
            }
            if (s.charAt(5) == 'x') {
                permissions += 8;
            } else if (s.charAt(5) == 's') {
                permissions += 1032;
            } else if (s.charAt(5) == 'S') {
                permissions += 1024;
            }
            if (s.charAt(6) == 'r') {
                permissions += 4;
            }
            if (s.charAt(7) == 'w') {
                permissions += 2;
            }
            if (s.charAt(8) == 'x') {
                ++permissions;
            } else if (s.charAt(8) == 't') {
                permissions += 513;
            } else if (s.charAt(8) == 'T') {
                permissions += 512;
            }
        }
        return permissions;
    }

    public static String[] getEncodings(boolean getSelected) {
        Set<String> set = getSelected ? EncodingServer.getSelectedNames() : EncodingServer.getAvailableNames();
        return set.toArray(new String[set.size()]);
    }

    public static String throwableToString(Throwable t) {
        StringWriter s = new StringWriter();
        t.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    private MiscUtilities() {
    }

    private static boolean compareChars(char ch1, char ch2, boolean ignoreCase) {
        if (ignoreCase) {
            return Character.toUpperCase(ch1) == Character.toUpperCase(ch2);
        }
        return ch1 == ch2;
    }

    private static int getPathStart(String path) {
        if (path.startsWith("/")) {
            return 0;
        }
        if (OperatingSystem.isDOSDerived() && path.length() >= 3 && path.charAt(1) == ':' && (path.charAt(2) == '/' || path.charAt(2) == '\\')) {
            return 3;
        }
        return 0;
    }

    private static boolean containsNullCharacter(Reader reader) throws IOException {
        int nbChars = jEdit.getIntegerProperty("vfs.binaryCheck.length", 100);
        int authorized = jEdit.getIntegerProperty("vfs.binaryCheck.count", 1);
        for (long i = 0L; i < (long)nbChars; ++i) {
            int c = reader.read();
            if (c == -1) {
                return false;
            }
            if (c != 0 || --authorized != 0) continue;
            return true;
        }
        return false;
    }

    static class VarCompressor {
        final Map<String, String> prefixMap = new HashMap<String, String>();
        final Map<String, String> previous = new HashMap<String, String>();

        VarCompressor() {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            Map<String, String> env = pb.environment();
            if (OperatingSystem.isUnix()) {
                this.prefixMap.put(System.getProperty("user.home"), "~");
            }
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String otherKey;
                String v;
                String k = entry.getKey();
                if (k.equalsIgnoreCase("pwd") || k.equalsIgnoreCase("oldpwd") || !Character.isLetter(k.charAt(0)) || !this.canBePathPrefix(v = entry.getValue())) continue;
                if (v.endsWith(File.separator)) {
                    v = v.substring(0, v.length() - 1);
                }
                if (OperatingSystem.isWindows() && (k.length() + 2 > v.length() || k.length() + 1 > v.length())) continue;
                if (OperatingSystem.isWindows()) {
                    v = v.toLowerCase();
                    k = k.toLowerCase();
                }
                if (this.prefixMap.containsKey(v) && (otherKey = this.prefixMap.get(v)).length() < k.length()) continue;
                this.prefixMap.put(v, k);
            }
        }

        String compress(String path) {
            String bestPrefix;
            String original = path;
            if (this.previous.containsKey(path)) {
                return this.previous.get(path);
            }
            String verifiedPrefix = bestPrefix = "/";
            for (String tryPrefix : this.prefixMap.keySet()) {
                if (tryPrefix.length() < bestPrefix.length()) continue;
                if (OperatingSystem.isWindows() && path.toLowerCase().startsWith(tryPrefix)) {
                    bestPrefix = tryPrefix;
                } else if (path.startsWith(tryPrefix)) {
                    bestPrefix = tryPrefix;
                }
                if (bestPrefix.equals(verifiedPrefix)) continue;
                String remainder = original.substring(bestPrefix.length());
                if (remainder.length() < 1 || remainder.startsWith(File.separator)) {
                    verifiedPrefix = bestPrefix;
                    continue;
                }
                bestPrefix = verifiedPrefix;
            }
            if (bestPrefix.length() > 1) {
                String remainder = original.substring(bestPrefix.length());
                String envvar = this.prefixMap.get(bestPrefix);
                path = envvar.equals("~") ? envvar + remainder : (OperatingSystem.isWindows() ? '%' + envvar.toUpperCase() + '%' + remainder : '$' + envvar + remainder);
            }
            this.previous.put(original, path);
            return path;
        }

        private boolean canBePathPrefix(String s) {
            return !s.contains(File.pathSeparator) && new File(s).isAbsolute();
        }
    }
}

