/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import sidekick.SideKickActions;

public abstract class SideKickCompletion {
    protected View view;
    protected JEditTextArea textArea;
    protected String text;
    protected List items = new ArrayList();

    public SideKickCompletion() {
    }

    public SideKickCompletion(View view, String string) {
        this.view = view;
        this.textArea = view.getTextArea();
        this.text = string;
    }

    public SideKickCompletion(View view, String string, List list) {
        this(view, string);
        this.items = list;
    }

    public SideKickCompletion(View view, String string, Object[] objectArray) {
        this(view, string);
        this.items = Arrays.asList(objectArray);
    }

    public int size() {
        return this.items.size();
    }

    public Object get(int n) {
        return this.items.get(n);
    }

    public String getCompletionDescription(int n) {
        return null;
    }

    @Deprecated
    public boolean isCompletionSelectable(int n) {
        return true;
    }

    public boolean updateInPlace(EditPane editPane, int n) {
        return false;
    }

    public ListCellRenderer getRenderer() {
        return new DefaultListCellRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int n) {
        String string = String.valueOf(this.get(n));
        int n2 = this.textArea.getCaretPosition();
        Selection selection = this.textArea.getSelectionAtOffset(n2);
        int n3 = selection == null ? n2 : selection.getStart();
        int n4 = selection == null ? n2 : selection.getEnd();
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        try {
            jEditBuffer.beginCompoundEdit();
            jEditBuffer.remove(n3 - this.text.length(), this.text.length());
            jEditBuffer.insert(n3 - this.text.length(), string);
        }
        finally {
            jEditBuffer.endCompoundEdit();
        }
    }

    public int getTokenLength() {
        return this.text.length();
    }

    public boolean handleKeystroke(int n, char c) {
        if (SideKickActions.acceptChars.indexOf(c) > -1) {
            this.insert(n);
            if (SideKickActions.insertChars.indexOf(c) > -1) {
                this.textArea.userInput(c);
            }
            return false;
        }
        this.textArea.userInput(c);
        return true;
    }
}

