/*
 * Decompiled with CFR 0.152.
 */
package console;

import console.Console;
import console.ConsolePane;
import console.ConsolePlugin;
import console.ConsoleProcess;
import console.Output;
import console.ProcessRunner;
import console.Shell;
import console.SystemShellBuiltIn;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StringList;

public class SystemShell
extends Shell {
    private String userHome;
    Map<String, String> variables;
    private Hashtable<Console, ConsoleState> consoleStateMap;
    private static final char dosSlash = '\u007f';
    private Hashtable<String, String> aliases;
    private Hashtable<String, SystemShellBuiltIn> commands;
    private boolean initialized;
    private byte[] lineSep = SystemShell.toBytes(System.getProperty("line.separator"));
    static final String varPatternString = "([$%])([a-zA-Z0-9_]+)(\\1?)";
    static final String varPatternString2 = "([$%])\\{([^}]+)\\}";
    static final Pattern varPattern = Pattern.compile("([$%])([a-zA-Z0-9_]+)(\\1?)");
    static final Pattern varPattern2 = Pattern.compile("([$%])\\{([^}]+)\\}");
    static final Pattern homeDir = Pattern.compile("^~");

    public SystemShell() {
        super("System");
        this.consoleStateMap = new Hashtable();
        this.userHome = System.getProperty("user.home");
        if (File.separator.equals("\\")) {
            this.userHome = this.userHome.replace("\\", "\\\\");
        }
    }

    @Override
    public void openConsole(Console console) {
        String propName;
        String val;
        ConsoleState cs = new ConsoleState();
        this.consoleStateMap.put(console, cs);
        if (jEdit.getBooleanProperty((String)"console.rememberCWD") && !(val = jEdit.getProperty((String)(propName = "console.cwd." + console.getId()), (String)"null")).equals("null")) {
            cs.currentDirectory = val;
        }
    }

    @Override
    public void closeConsole(Console console) {
        ConsoleProcess process = this.getConsoleState(console).process;
        if (process != null) {
            process.stop();
        }
        this.consoleStateMap.remove(console);
    }

    @Override
    public void printInfoMessage(Output output) {
        if (jEdit.getBooleanProperty((String)"console.shell.info.toggle")) {
            output.print(null, jEdit.getProperty((String)"console.shell.info"));
        }
    }

    @Override
    public void printPrompt(Console console, Output output) {
        ConsoleState cstate = this.getConsoleState(console);
        String currentDirectory = cstate == null ? System.getProperty("user.dir") : cstate.currentDirectory;
        output.writeAttrs(ConsolePane.colorAttributes(console.getPlainColor()), jEdit.getProperty((String)"console.shell.prompt", (Object[])new String[]{MiscUtilities.abbreviate((String)currentDirectory)}) + " ");
    }

    public void executeBuiltIn(Console console, Output output, Output error, String command, Vector<String> args) {
        SystemShellBuiltIn builtIn = this.commands.get(command);
        if (builtIn == null) {
            Object[] pp = new String[]{command};
            error.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.unknown-builtin", (Object[])pp));
        } else {
            builtIn.execute(console, output, error, args);
        }
    }

    public void executeInDir(Console console, String input, Output output, Output error, String command, String dir) {
        ConsoleState state = this.getConsoleState(console);
        String cwd = state.currentDirectory;
        state.setCurrentDirectory(console, dir);
        this.execute(console, input, output, error, command);
        state.setCurrentDirectory(console, cwd);
    }

    @Override
    public void execute(Console console, String input, Output output, Output error, String command) {
        PipedOutputStream out;
        ConsoleState state;
        if (error == null) {
            error = output;
        }
        if ((state = this.getConsoleState(console)).process != null && (out = state.process.getPipeOutput()) != null) {
            try {
                out.write(SystemShell.toBytes(command));
                out.write(this.lineSep);
                out.flush();
            }
            catch (IOException e) {
                Log.log((int)9, (Object)this, (Object)"execute()", (Throwable)e);
            }
            return;
        }
        if (command.startsWith("#")) {
            output.commandDone();
            return;
        }
        this.init();
        Vector<String> args = this.parse(command);
        if (args == null) {
            output.commandDone();
            return;
        }
        args = this.preprocess(console.getView(), console, args);
        String commandName = args.elementAt(0);
        if (OperatingSystem.isWindows() && commandName.endsWith(":")) {
            char driveLetter = commandName.charAt(0);
            args = state.changeDrive(driveLetter);
            commandName = args.elementAt(0);
        }
        if (commandName.charAt(0) == '%') {
            args.removeElementAt(0);
            this.executeBuiltIn(console, output, error, commandName, args);
            output.commandDone();
            return;
        }
        String cwd = state.currentDirectory;
        if (!new File(cwd).exists()) {
            output.print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.error.working-dir", (Object[])new String[]{cwd}));
            output.commandDone();
            return;
        }
        String fullPath = MiscUtilities.constructPath((String)cwd, (String)commandName);
        if (commandName.startsWith("./") || commandName.startsWith("." + File.separator)) {
            args.setElementAt(fullPath, 0);
        }
        if (new File(fullPath).isDirectory() && args.size() == 1) {
            args.setElementAt(fullPath, 0);
            this.executeBuiltIn(console, output, error, "%cd", args);
            output.commandDone();
        } else {
            boolean foreground;
            if (args.elementAt(args.size() - 1).equals("&")) {
                args.removeElementAt(args.size() - 1);
                foreground = false;
                output.commandDone();
            } else {
                foreground = true;
            }
            Object[] _args = new String[args.size()];
            args.copyInto(_args);
            state.currentDirectory = cwd;
            ConsoleProcess proc = new ConsoleProcess(console, output, (String[])_args, this.variables, state, foreground);
            if (foreground && proc.isRunning()) {
                console.getErrorSource().clear();
                state.process = proc;
            }
            if (input != null) {
                Log.log((int)1, (Object)this, (Object)("sending input to system shell: " + input));
                PipedOutputStream out2 = proc.getPipeOutput();
                if (out2 != null) {
                    try {
                        out2.write(SystemShell.toBytes(input));
                        ((OutputStream)out2).close();
                    }
                    catch (IOException e) {
                        Log.log((int)9, (Object)this, (Object)"execute.pipeout", (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public void stop(Console console) {
        ConsoleState consoleState = this.getConsoleState(console);
        if (consoleState == null) {
            return;
        }
        ConsoleProcess process = consoleState.process;
        if (process != null) {
            process.stop();
        } else {
            console.getOutput().print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.noproc"));
        }
    }

    @Override
    public boolean waitFor(Console console) {
        ConsoleState consoleState = this.getConsoleState(console);
        if (consoleState == null) {
            return true;
        }
        ConsoleProcess process = consoleState.process;
        if (process != null) {
            try {
                return process.waitFor() == 0;
            }
            catch (InterruptedException e) {
                return process.getExitStatus() == 0;
            }
        }
        return true;
    }

    @Override
    public void endOfFile(Console console) {
        ConsoleState state = this.getConsoleState(console);
        if (state.process != null) {
            console.getOutput().writeAttrs(ConsolePane.colorAttributes(console.getInfoColor()), "^D\n");
            PipedOutputStream out = state.process.getPipeOutput();
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void detach(Console console) {
        ConsoleState state = this.getConsoleState(console);
        ConsoleProcess process = state.process;
        if (process == null) {
            console.getOutput().print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.noproc"));
            return;
        }
        process.detach();
    }

    @Override
    public Shell.CompletionInfo getCompletions(Console console, String command) {
        boolean isDoubleQuoted;
        String lastArg;
        String lastArgEscaped;
        this.init();
        View view = console.getView();
        String currentDirectory = console == null ? System.getProperty("user.dir") : this.getConsoleState((Console)console).currentDirectory;
        String fileDelimiters = "='\" \\" + File.pathSeparator;
        Shell.CompletionInfo completionInfo = new Shell.CompletionInfo();
        completionInfo.offset = 0;
        if (File.separatorChar == '\\') {
            lastArgEscaped = this.parse(command).lastElement();
            lastArg = lastArgEscaped.replace('/', File.separatorChar);
            if (lastArg.startsWith("\\")) {
                ConsoleState state = this.getConsoleState(console);
                char drive = state.currentDirectory.charAt(0);
                lastArg = drive + ":\\" + lastArg.substring(1);
                completionInfo.offset = 2;
            }
        } else {
            lastArgEscaped = SystemShell.findLastArgument(command, fileDelimiters);
            lastArg = SystemShell.unescape(lastArgEscaped, fileDelimiters);
        }
        completionInfo.offset += command.length() - lastArg.length();
        Matcher m = homeDir.matcher(lastArg);
        lastArg = m.replaceFirst(System.getProperty("user.home"));
        completionInfo.completions = completionInfo.offset == 0 ? this.getCommandCompletions(view, currentDirectory, lastArg).toArray(new String[0]) : this.getFileCompletions(view, currentDirectory, lastArg, false).toArray(new String[0]);
        if (File.separatorChar != '\\') {
            for (int i = 0; i < completionInfo.completions.length; ++i) {
                completionInfo.completions[i] = SystemShell.escape(completionInfo.completions[i], fileDelimiters);
            }
        }
        boolean bl = isDoubleQuoted = completionInfo.offset > 0 && command.charAt(completionInfo.offset - 1) == '\"';
        if (!isDoubleQuoted) {
            String specialCharacters = File.separatorChar == '\\' ? " " : fileDelimiters;
            for (int i = 0; i < completionInfo.completions.length; ++i) {
                String result = completionInfo.completions[i];
                if (SystemShell.containsCharacters(result, specialCharacters)) {
                    result = "\"" + result;
                }
                completionInfo.completions[i] = result;
            }
        }
        return completionInfo;
    }

    String expandVariables(View view, String arg) {
        String varName = null;
        Matcher m = homeDir.matcher(arg);
        if (m.find()) {
            arg = m.replaceFirst(this.userHome);
        }
        if (!(m = varPattern.matcher(arg)).find() && !(m = varPattern2.matcher(arg)).find()) {
            return arg;
        }
        varName = m.group(2);
        String expansion = this.getVariableValue(view, varName);
        if (expansion == null) {
            varName = varName.toUpperCase();
            expansion = this.getVariableValue(view, varName);
        }
        if (expansion != null) {
            expansion = expansion.replace("\\", "\\\\");
            return m.replaceFirst(expansion);
        }
        return arg;
    }

    public String getVariableValue(View view, String varName) {
        Object expansion;
        this.init();
        if (view == null) {
            return this.variables.get(varName);
        }
        ConsoleState cs = this.getConsoleState(ConsolePlugin.getConsole(view));
        Buffer buffer = view.getBuffer();
        if (varName.equals("$") || varName.equals("%")) {
            expansion = varName;
        } else if (varName.equals("d")) {
            expansion = MiscUtilities.getParentOfPath((String)buffer.getPath());
            if (((String)expansion).endsWith("/") || ((String)expansion).endsWith(File.separator)) {
                expansion = ((String)expansion).substring(0, ((String)expansion).length() - 1);
            }
        } else if (varName.equals("l")) {
            int line = view.getTextArea().getCaretLine() + 1;
            expansion = new Integer(line).toString();
        } else if (varName.equals("u")) {
            expansion = buffer.getPath();
            if (!MiscUtilities.isURL((String)expansion)) {
                expansion = "file:/" + ((String)expansion).replace(File.separatorChar, '/');
            }
        } else if (varName.equals("f")) {
            expansion = buffer.getPath();
        } else if (varName.equalsIgnoreCase("pwd")) {
            expansion = cs.currentDirectory;
        } else if (varName.equals("n")) {
            expansion = buffer.getName();
        } else if (varName.equals("c")) {
            expansion = ConsolePlugin.getClassName(buffer);
        } else if (varName.equals("PKG")) {
            expansion = ConsolePlugin.getPackageName(buffer);
            if (expansion == null) {
                expansion = "";
            }
        } else {
            VFSBrowser browser;
            expansion = varName.equals("ROOT") ? ConsolePlugin.getPackageRoot(buffer) : (varName.equals("p") ? BeanShell.eval((View)view, (NameSpace)BeanShell.getNameSpace(), (String)"getProjectRoot(view, buffer)").toString() : (varName.equals("BROWSER_DIR") ? ((browser = (VFSBrowser)view.getDockableWindowManager().getDockable("vfs.browser")) == null ? null : browser.getDirectory()) : this.variables.get(varName)));
        }
        return expansion;
    }

    public Hashtable<String, String> getAliases() {
        this.init();
        return this.aliases;
    }

    ConsoleState getConsoleState(Console console) {
        ConsoleState retval = this.consoleStateMap.get(console);
        if (retval == null) {
            this.openConsole(console);
        }
        return this.consoleStateMap.get(console);
    }

    Map<String, String> getVariables() {
        this.init();
        return this.variables;
    }

    static void propertiesChanged() {
    }

    private static byte[] toBytes(String str) {
        try {
            return str.getBytes(jEdit.getProperty((String)"console.encoding"));
        }
        catch (UnsupportedEncodingException e) {
            Log.log((int)9, SystemShell.class, (Object)"toBytes()", (Throwable)e);
            return null;
        }
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initCommands();
        this.initAliases();
        this.initVariables();
    }

    private void initCommands() {
        this.commands = new Hashtable();
        this.commands.put("%alias", new SystemShellBuiltIn.alias());
        this.commands.put("%aliases", new SystemShellBuiltIn.aliases());
        this.commands.put("%browse", new SystemShellBuiltIn.browse());
        this.commands.put("%cd", new SystemShellBuiltIn.cd());
        this.commands.put("%clear", new SystemShellBuiltIn.clear());
        this.commands.put("%dirstack", new SystemShellBuiltIn.dirstack());
        this.commands.put("%echo", new SystemShellBuiltIn.echo());
        this.commands.put("%edit", new SystemShellBuiltIn.edit());
        this.commands.put("%env", new SystemShellBuiltIn.env());
        this.commands.put("%help", new SystemShellBuiltIn.help());
        this.commands.put("%kill", new SystemShellBuiltIn.kill());
        this.commands.put("%popd", new SystemShellBuiltIn.popd());
        this.commands.put("%pushd", new SystemShellBuiltIn.pushd());
        this.commands.put("%printwd", new SystemShellBuiltIn.pwd());
        this.commands.put("%run", new SystemShellBuiltIn.run());
        this.commands.put("%set", new SystemShellBuiltIn.set());
        this.commands.put("%unalias", new SystemShellBuiltIn.unalias());
        this.commands.put("%unset", new SystemShellBuiltIn.unset());
        this.commands.put("%version", new SystemShellBuiltIn.version());
    }

    private void initAliases() {
        String alias2;
        this.aliases = new Hashtable();
        ProcessRunner pr = ProcessRunner.getProcessRunner();
        pr.setUpDefaultAliases(this.aliases);
        this.aliases.put("cd", "%cd");
        this.aliases.put("pushd", "%pushd");
        this.aliases.put("popd", "%popd");
        this.aliases.put("pwd", "%printwd");
        this.aliases.put("aliases", "%aliases");
        this.aliases.put("alias", "%alias");
        this.aliases.put("ver", "%version");
        this.aliases.put("-", "%cd -");
        this.aliases.put("ant", "ant -emacs");
        int i = 0;
        while ((alias2 = jEdit.getProperty((String)("console.shell.alias." + i))) != null) {
            this.aliases.put(alias2, jEdit.getProperty((String)("console.shell.alias." + i + ".expansion")));
            ++i;
        }
    }

    private void initVariables() {
        String varname;
        this.variables = new HashMap<String, String>();
        this.variables.putAll(System.getenv());
        if (File.separator.equals("\\")) {
            HashMap<String, String> upcased = new HashMap<String, String>();
            for (String key : this.variables.keySet()) {
                upcased.put(key.toUpperCase(), this.variables.get(key));
            }
            this.variables = upcased;
        }
        if (jEdit.getJEditHome() != null) {
            this.variables.put("JEDIT_HOME", jEdit.getJEditHome());
        }
        if (jEdit.getSettingsDirectory() != null) {
            this.variables.put("JEDIT_SETTINGS", jEdit.getSettingsDirectory());
        }
        this.variables.put("TERM", "dumb");
        int i = 0;
        while ((varname = jEdit.getProperty((String)("console.shell.variable." + i))) != null) {
            this.variables.put(varname, jEdit.getProperty((String)("console.shell.variable." + i + ".value")));
            ++i;
        }
    }

    private Vector<String> parse(String command) {
        Vector<String> args;
        block10: {
            args = new Vector<String>();
            if (File.separatorChar == '\\') {
                command = command.replace('\\', '\u007f');
            }
            StreamTokenizer st = new StreamTokenizer(new StringReader(command));
            st.resetSyntax();
            st.wordChars(33, 255);
            st.whitespaceChars(0, 32);
            st.quoteChar(34);
            st.quoteChar(39);
            try {
                while (true) {
                    switch (st.nextToken()) {
                        case -1: {
                            break block10;
                        }
                        case -3: 
                        case 34: 
                        case 39: {
                            if (File.separatorChar == '\\') {
                                args.addElement(st.sval.replace('\u007f', '\\'));
                                break;
                            }
                            args.addElement(st.sval);
                        }
                    }
                }
            }
            catch (IOException io) {
                // empty catch block
            }
        }
        if (args.size() == 0) {
            return null;
        }
        return args;
    }

    private Vector<String> preprocess(View view, Console console, Vector<String> args) {
        Vector<String> newArgs = new Vector<String>();
        String commandName = args.elementAt(0);
        String expansion = this.aliases.get(commandName);
        if (expansion != null) {
            Vector<String> expansionArgs = this.parse(expansion);
            for (int i = 0; i < expansionArgs.size(); ++i) {
                this.expandGlobs(view, newArgs, expansionArgs.elementAt(i));
            }
        } else {
            this.expandGlobs(view, newArgs, commandName);
        }
        for (int i = 1; i < args.size(); ++i) {
            this.expandGlobs(view, newArgs, args.elementAt(i));
        }
        return newArgs;
    }

    private void expandGlobs(View view, Vector<String> args, String arg) {
        args.addElement(this.expandVariables(view, arg));
    }

    private List<String> getFileCompletions(View view, String currentDirName, String typedFilename, boolean directoriesOnly) {
        String expandedTypedFilename = this.expandVariables(view, typedFilename);
        int lastSeparatorIndex = expandedTypedFilename.lastIndexOf(File.separator);
        String typedDirName = lastSeparatorIndex == -1 ? "" : expandedTypedFilename.substring(0, lastSeparatorIndex + 1);
        File typedFile = new File(expandedTypedFilename).isAbsolute() ? new File(expandedTypedFilename) : new File(currentDirName, expandedTypedFilename);
        boolean directory = expandedTypedFilename.endsWith(File.separator) || expandedTypedFilename.length() == 0;
        File dir = directory ? typedFile : typedFile.getParentFile();
        String fileName = directory ? "" : typedFile.getName();
        String[] filenames = dir.list();
        if (filenames == null || filenames.length == 0) {
            return null;
        }
        boolean isOSCaseSensitive = ProcessRunner.getProcessRunner().isCaseSensitive();
        StringList matchingFilenames = new StringList();
        String matchedString = isOSCaseSensitive ? fileName : fileName.toLowerCase();
        for (int i = 0; i < filenames.length; ++i) {
            String matchedAgainst;
            String string = matchedAgainst = isOSCaseSensitive ? filenames[i] : filenames[i].toLowerCase();
            if (!matchedAgainst.startsWith(matchedString)) continue;
            StringBuffer match = new StringBuffer();
            File matchFile = new File(dir, filenames[i]);
            if (directoriesOnly && !matchFile.isDirectory()) continue;
            match.append(typedDirName + filenames[i]);
            if (matchFile.isDirectory() && match.charAt(match.length() - 1) != File.separatorChar) {
                match.append(File.separator);
            }
            matchingFilenames.add((Object)match.toString());
        }
        return matchingFilenames;
    }

    private List<String> getCommandCompletions(View view, String currentDirName, String command) {
        StringList list = new StringList();
        for (String cmd : this.commands.keySet()) {
            if (!cmd.startsWith(command)) continue;
            list.add((Object)cmd);
        }
        for (String cmd : this.aliases.keySet()) {
            if (!cmd.startsWith(command)) continue;
            list.add((Object)cmd);
        }
        list.addAll(this.getFileCompletions(view, currentDirName, command, false));
        return list;
    }

    private static String findLastArgument(String command, String delimiters) {
        int i;
        for (i = command.length() - 1; i >= 0; --i) {
            char c = command.charAt(i);
            if (delimiters.indexOf(c) == -1) continue;
            if (i == 0 || command.charAt(i - 1) != '\\') break;
            --i;
        }
        return command.substring(i + 1);
    }

    private static String unescape(String s, String delimiters) {
        StringBuffer buf = new StringBuffer(s.length());
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            buf.append(c);
            if (delimiters.indexOf(c) == -1 || s.charAt(i - 1) != '\\') continue;
            --i;
        }
        return buf.reverse().toString();
    }

    private static String escape(String s, String delimiters) {
        StringBuffer buf = new StringBuffer();
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (delimiters.indexOf(c) != -1) {
                buf.append('\\');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private static boolean containsCharacters(String s, String characters) {
        int stringLength = s.length();
        for (int i = 0; i < stringLength; ++i) {
            if (characters.indexOf(s.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    static class ConsoleState {
        private ConsoleProcess process;
        private ConsoleProcess lastProcess;
        private HashMap<Character, String> driveDirectories = null;
        String currentDirectory = System.getProperty("user.dir");
        String lastDirectory = System.getProperty("user.dir");
        Stack<String> directoryStack = new Stack();

        ConsoleState() {
        }

        void setProcess(ConsoleProcess cp) {
            if (this.process != null) {
                this.lastProcess = this.process;
            }
            this.process = cp;
        }

        ConsoleProcess getProcess() {
            return this.process;
        }

        ConsoleProcess getLastProcess() {
            if (this.process != null) {
                return this.process;
            }
            return this.lastProcess;
        }

        void gotoLastDirectory(Console console) {
            this.setCurrentDirectory(console, this.lastDirectory);
        }

        Vector<String> changeDrive(char driveLetter) {
            driveLetter = Character.toUpperCase(driveLetter);
            Vector<String> retval = new Vector<String>();
            retval.add("%cd");
            char curDrive = Character.toUpperCase(this.currentDirectory.charAt(0));
            if (this.driveDirectories == null) {
                this.driveDirectories = new HashMap();
            }
            this.driveDirectories.put(Character.valueOf(curDrive), this.currentDirectory);
            String path = driveLetter + ":" + File.separator;
            if (this.driveDirectories.containsKey(Character.valueOf(driveLetter))) {
                path = this.driveDirectories.get(Character.valueOf(driveLetter));
            }
            retval.add(path);
            return retval;
        }

        void setCurrentDirectory(Console console, String newDir) {
            Object[] pp = new String[]{newDir};
            File file = new File(newDir);
            if (!file.isAbsolute()) {
                file = new File(this.currentDirectory, newDir);
            }
            if (!file.exists()) {
                console.getOutput().print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.cd.error", (Object[])pp));
            } else if (!file.isDirectory()) {
                console.getOutput().print(console.getErrorColor(), jEdit.getProperty((String)"console.shell.cd.file", (Object[])pp));
            } else {
                this.lastDirectory = this.currentDirectory;
                try {
                    this.currentDirectory = file.getCanonicalPath();
                    if (jEdit.getBooleanProperty((String)"console.rememberCWD")) {
                        String propName = "console.cwd." + console.getId();
                        jEdit.setProperty((String)propName, (String)this.currentDirectory);
                    }
                }
                catch (IOException ioe) {
                    Log.log((int)9, (Object)this, (Object)"setCurrentDirectory()", (Throwable)ioe);
                }
            }
        }
    }
}

