/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.Log;

class ScreenLineManager {
    private static final int SCREEN_LINES_SHIFT = 1;
    private static final int SCREEN_LINES_VALID_MASK = 1;
    private final JEditBuffer buffer;
    private short[] screenLines;

    ScreenLineManager(JEditBuffer buffer) {
        this.buffer = buffer;
        if (!buffer.isLoading()) {
            this.reset();
        }
    }

    boolean isScreenLineCountValid(int line) {
        return (this.screenLines[line] & 1) != 0;
    }

    int getScreenLineCount(int line) {
        return this.screenLines[line] >> 1;
    }

    void setScreenLineCount(int line, int count) {
        if (count > Short.MAX_VALUE) {
            count = Short.MAX_VALUE;
        }
        if (Debug.SCREEN_LINES_DEBUG) {
            Log.log(1, this, new Exception("setScreenLineCount(" + line + ',' + count + ')'));
        }
        this.screenLines[line] = (short)(count << 1 | 1);
    }

    void invalidateScreenLineCounts() {
        int lineCount = this.buffer.getLineCount();
        int i = 0;
        while (i < lineCount) {
            int n = i++;
            this.screenLines[n] = (short)(this.screenLines[n] & 0xFFFFFFFE);
        }
    }

    void reset() {
        this.screenLines = new short[this.buffer.getLineCount()];
    }

    public void contentInserted(int startLine, int numLines) {
        int endLine = startLine + numLines;
        int n = startLine;
        this.screenLines[n] = (short)(this.screenLines[n] & 0xFFFFFFFE);
        int lineCount = this.buffer.getLineCount();
        if (numLines > 0) {
            if (this.screenLines.length <= lineCount) {
                short[] screenLinesN = new short[lineCount + 1 << 1];
                System.arraycopy(this.screenLines, 0, screenLinesN, 0, this.screenLines.length);
                this.screenLines = screenLinesN;
            }
            System.arraycopy(this.screenLines, startLine, this.screenLines, endLine, lineCount - endLine);
            for (int i = 0; i < numLines; ++i) {
                this.screenLines[startLine + i] = 0;
            }
        }
    }

    public void contentRemoved(int startLine, int numLines) {
        int endLine = startLine + numLines;
        int n = startLine;
        this.screenLines[n] = (short)(this.screenLines[n] & 0xFFFFFFFE);
        if (numLines > 0 && endLine != this.screenLines.length) {
            System.arraycopy(this.screenLines, endLine + 1, this.screenLines, startLine + 1, this.screenLines.length - endLine - 1);
        }
    }
}

