/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.TransferHandler;
import org.gjt.sp.util.Log;

public class PingPongList<E>
extends JSplitPane {
    private final MyListModel<E> leftModel;
    private final MyListModel<E> rightModel;
    private JList left;
    private JList right;
    private JLabel leftLabel;
    private JLabel rightLabel;
    private JPanel leftPanel;
    private JPanel rightPanel;

    public PingPongList(List<E> leftData, List<E> rightData) {
        this(1, leftData, rightData);
    }

    public PingPongList(int newOrientation, List<E> leftData, List<E> rightData) {
        super(newOrientation);
        this.leftModel = new MyListModel(leftData);
        this.left = new JList<E>(this.leftModel);
        this.rightModel = new MyListModel(rightData);
        this.right = new JList<E>(this.rightModel);
        this.leftPanel = new JPanel(new BorderLayout());
        this.rightPanel = new JPanel(new BorderLayout());
        JScrollPane leftScroll = new JScrollPane(this.left);
        JScrollPane rightScroll = new JScrollPane(this.right);
        this.leftPanel.add(leftScroll);
        this.rightPanel.add(rightScroll);
        this.setLeftComponent(this.leftPanel);
        this.setRightComponent(this.rightPanel);
        this.left.setDragEnabled(true);
        this.right.setDragEnabled(true);
        MyTransferHandler myTransferHandler = new MyTransferHandler();
        this.left.setTransferHandler(myTransferHandler);
        this.right.setTransferHandler(myTransferHandler);
        this.setDividerLocation(0.5);
    }

    public void setLeftTooltip(String leftTooltip) {
        this.left.setToolTipText(leftTooltip);
    }

    public void setRightTooltip(String rightTooltip) {
        this.right.setToolTipText(rightTooltip);
    }

    public void setLeftTitle(String leftTitle) {
        if (leftTitle == null) {
            this.removeLeftTitle();
            return;
        }
        if (this.leftLabel == null) {
            this.leftLabel = new JLabel();
        }
        this.leftLabel.setText(leftTitle);
        this.leftPanel.add((Component)this.leftLabel, "North");
    }

    public void setRightTitle(String rightTitle) {
        if (rightTitle == null) {
            this.removeRightTitle();
            return;
        }
        if (this.rightLabel == null) {
            this.rightLabel = new JLabel();
        }
        this.rightLabel.setText(rightTitle);
        this.rightPanel.add((Component)this.rightLabel, "North");
    }

    public void removeLeftTitle() {
        if (this.leftLabel != null) {
            this.leftPanel.remove(this.leftLabel);
            this.leftLabel = null;
        }
    }

    public void removeRightTitle() {
        if (this.rightLabel != null) {
            this.rightPanel.remove(this.rightLabel);
            this.rightLabel = null;
        }
    }

    public int getLeftSize() {
        return this.leftModel.getSize();
    }

    public int getRightSize() {
        return this.rightModel.getSize();
    }

    public Iterator<E> getLeftDataIterator() {
        return this.leftModel.iterator();
    }

    public Iterator<E> getRightDataIterator() {
        return this.rightModel.iterator();
    }

    public void moveAllToLeft() {
        this.leftModel.addAll(((MyListModel)this.rightModel).data);
        this.rightModel.clear();
    }

    public void moveAllToRight() {
        this.rightModel.addAll(((MyListModel)this.leftModel).data);
        this.leftModel.clear();
    }

    private static class MyTransferable<E>
    implements Transferable {
        public static final DataFlavor javaListFlavor = new DataFlavor(Collection.class, "java.util.Collection");
        private final E[] data;

        private MyTransferable(E[] data) {
            this.data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{javaListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(javaListFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.data;
        }
    }

    private class MyTransferHandler
    extends TransferHandler {
        private JList sourceList;
        private int[] indices;

        private MyTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            try {
                Object[] transferData = (Object[])t.getTransferData(MyTransferable.javaListFlavor);
                JList targetList = (JList)comp;
                MyListModel targetModel = (MyListModel)targetList.getModel();
                MyListModel sourceModel = (MyListModel)this.sourceList.getModel();
                int dropLocation = targetList.getSelectedIndex();
                if (dropLocation == -1) {
                    dropLocation = 0;
                }
                targetModel.add(dropLocation, transferData);
                int dropStart = dropLocation;
                if (targetList == this.sourceList) {
                    int i;
                    for (i = this.indices.length - 1; i >= 0; --i) {
                        int index = this.indices[i];
                        if (this.indices[i] >= dropLocation) {
                            index += transferData.length;
                        } else {
                            --dropStart;
                        }
                        sourceModel.remove(index);
                    }
                    for (i = this.indices.length - 1; i >= 0; --i) {
                        this.indices[i] = dropStart + i;
                    }
                } else {
                    this.sourceList.clearSelection();
                    for (int i = this.indices.length - 1; i >= 0; --i) {
                        sourceModel.remove(this.indices[i]);
                        this.indices[i] = dropLocation + i;
                    }
                }
                targetList.setSelectedIndices(this.indices);
                return true;
            }
            catch (UnsupportedFlavorException e) {
                Log.log(9, this, e);
            }
            catch (IOException e) {
                Log.log(9, this, e);
            }
            return false;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            this.sourceList = (JList)c;
            this.indices = this.sourceList.getSelectedIndices();
            Object[] objects = this.sourceList.getSelectedValues();
            return new MyTransferable(objects);
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return comp == PingPongList.this.left || comp == PingPongList.this.right;
        }
    }

    private static class MyListModel<E>
    extends AbstractListModel
    implements Iterable<E> {
        private List<E> data;

        private MyListModel(List<E> data) {
            this.data = data;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public Iterator<E> iterator() {
            return this.data.iterator();
        }

        public void clear() {
            if (this.data.isEmpty()) {
                return;
            }
            int i = this.data.size();
            this.data.clear();
            this.fireIntervalRemoved(this, 0, i - 1);
        }

        public void addAll(Collection<E> newData) {
            int i = this.data.size();
            this.data.addAll(newData);
            this.fireIntervalAdded(this, i, i + newData.size() - 1);
        }

        public void remove(int index) {
            this.data.remove(index);
            this.fireContentsChanged(this, index, index);
        }

        public void add(int pos, E[] addedDatas) {
            for (int i = addedDatas.length - 1; i >= 0; --i) {
                this.data.add(pos, addedDatas[i]);
            }
            this.fireContentsChanged(this, pos, pos + addedDatas.length - 1);
        }
    }
}

