/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;

public class FileCellRenderer
extends DefaultTableCellRenderer {
    public static Icon fileIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.file.icon"));
    public static Icon openFileIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.open-file.icon"));
    public static Icon dirIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.dir.icon"));
    public static Icon openDirIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.open-dir.icon"));
    public static Icon filesystemIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.filesystem.icon"));
    public static Icon loadingIcon = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.loading.icon"));
    Font plainFont = UIManager.getFont("Tree.font");
    Font boldFont;
    boolean showIcons;
    private static boolean defaultIcons = true;
    private boolean openBuffer;
    private boolean isSelected;
    private VFSFile file;

    public FileCellRenderer() {
        if (this.plainFont == null) {
            this.plainFont = jEdit.getFontProperty("metal.secondary.font");
        }
        this.boldFont = this.plainFont.deriveFont(1);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof VFSDirectoryEntryTableModel.Entry) {
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)value;
            VFSFile file = entry.dirEntry;
            this.setFont(file.getType() == 0 ? this.plainFont : this.boldFont);
            this.isSelected = isSelected;
            this.file = file;
            if (column == 0) {
                String path = file.getSymlinkPath() == null ? file.getPath() : file.getSymlinkPath();
                this.openBuffer = jEdit._getBuffer(path) != null;
                this.setIcon(this.showIcons ? FileCellRenderer.getIconForFile(file, entry.expanded, this.openBuffer) : null);
                this.setText(file.getName());
                int state = file.getType() == 0 ? 0 : (entry.expanded ? 2 : 1);
                this.setBorder(new ExpansionToggleBorder(state, entry.level));
            } else {
                VFSDirectoryEntryTableModel model = (VFSDirectoryEntryTableModel)table.getModel();
                String extAttr = model.getExtendedAttribute(column);
                this.openBuffer = false;
                this.setIcon(null);
                this.setText(file.getExtendedAttribute(extAttr));
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isSelected) {
            Color color = this.file.getColor();
            this.setForeground(color == null ? UIManager.getColor("Tree.foreground") : color);
        }
        super.paintComponent(g);
        if (this.openBuffer) {
            int y;
            int x;
            Font font = this.getFont();
            FontMetrics fm = this.getFontMetrics(font);
            if (this.getIcon() == null) {
                x = 0;
                y = fm.getAscent() + 2;
            } else {
                x = this.getIcon().getIconWidth() + this.getIconTextGap();
                y = Math.max(fm.getAscent() + 2, 16);
            }
            Insets border = this.getBorder().getBorderInsets(this);
            g.setColor(this.getForeground());
            g.drawLine(x += border.left, y, x + fm.stringWidth(this.getText()), y);
        }
    }

    public static Icon getIconForFile(VFSFile file, boolean expanded) {
        return FileCellRenderer.getIconForFile(file, expanded, jEdit._getBuffer(file.getSymlinkPath()) != null);
    }

    public static Icon getIconForFile(VFSFile file, boolean expanded, boolean openBuffer) {
        if (defaultIcons) {
            return file.getDefaultIcon(expanded, openBuffer);
        }
        return file.getIcon(expanded, openBuffer);
    }

    void propertiesChanged() {
        this.showIcons = jEdit.getBooleanProperty("vfs.browser.showIcons");
        defaultIcons = jEdit.getBooleanProperty("vfs.browser.useDefaultIcons");
    }

    int getEntryWidth(VFSDirectoryEntryTableModel.Entry entry, Font font, FontRenderContext fontRenderContext) {
        String name = entry.dirEntry.getName();
        int width = (int)font.getStringBounds(name, fontRenderContext).getWidth();
        width += ExpansionToggleBorder.ICON_WIDTH + entry.level * 10 + 3;
        if (this.showIcons) {
            width += fileIcon.getIconWidth();
            width += this.getIconTextGap();
        }
        return width;
    }

    static class ExpansionToggleBorder
    implements Border {
        static final Icon COLLAPSE_ICON = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.collapse.icon"));
        static final Icon EXPAND_ICON = GUIUtilities.loadIcon(jEdit.getProperty("vfs.browser.expand.icon"));
        static final int ICON_WIDTH = Math.max(COLLAPSE_ICON.getIconWidth(), EXPAND_ICON.getIconWidth());
        static final int LEVEL_WIDTH = 10;
        static final int STATE_NONE = 0;
        static final int STATE_COLLAPSED = 1;
        static final int STATE_EXPANDED = 2;
        private int state;
        private int level;

        ExpansionToggleBorder(int state, int level) {
            this.state = state;
            this.level = level;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            switch (this.state) {
                case 1: {
                    EXPAND_ICON.paintIcon(c, g, x + this.level * 10 + 2, y + (height - EXPAND_ICON.getIconHeight()) / 2);
                    break;
                }
                case 2: {
                    COLLAPSE_ICON.paintIcon(c, g, x + this.level * 10 + 2, y + (height - COLLAPSE_ICON.getIconHeight()) / 2);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, this.level * 10 + ICON_WIDTH + 4, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        public static boolean isExpansionToggle(int level, int x) {
            return x >= level * 10 && x <= level * 10 + ICON_WIDTH;
        }
    }
}

