/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.browser.BrowserCommandsMenu;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.ListDirectoryBrowserTask;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTable;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

class BrowserView
extends JPanel {
    private final VFSBrowser browser;
    private final JSplitPane splitPane;
    private final JList parentDirectories;
    private final VFSDirectoryEntryTable table;
    private final Set<String> tmpExpanded;
    private BrowserCommandsMenu popup;
    private boolean showIcons;

    BrowserView(final VFSBrowser browser) {
        this.browser = browser;
        this.tmpExpanded = new HashSet<String>();
        DockableWindowManager dwm = jEdit.getActiveView().getDockableWindowManager();
        KeyListener keyListener = dwm.closeListener("vfs.browser");
        this.parentDirectories = new ParentDirectoryList();
        this.parentDirectories.addKeyListener(keyListener);
        this.parentDirectories.setName("parent");
        this.parentDirectories.getSelectionModel().setSelectionMode(0);
        this.parentDirectories.setCellRenderer(new ParentDirectoryRenderer());
        this.parentDirectories.setVisibleRowCount(5);
        this.parentDirectories.addMouseListener(new ParentMouseHandler());
        final JScrollPane parentScroller = new JScrollPane(this.parentDirectories);
        parentScroller.setMinimumSize(new Dimension(0, 0));
        this.table = new VFSDirectoryEntryTable(this);
        this.table.addMouseListener(new TableMouseHandler());
        this.table.setName("file");
        JScrollPane tableScroller = new JScrollPane(this.table);
        tableScroller.setMinimumSize(new Dimension(0, 0));
        tableScroller.getViewport().setBackground(this.table.getBackground());
        tableScroller.getViewport().addMouseListener(new TableMouseHandler());
        this.splitPane = new JSplitPane(browser.isHorizontalLayout() ? 1 : 0, jEdit.getBooleanProperty("appearance.continuousLayout"), parentScroller, tableScroller);
        this.splitPane.setOneTouchExpandable(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String prop = browser.isHorizontalLayout() ? "vfs.browser.horizontalSplitter" : "vfs.browser.splitter";
                int loc = jEdit.getIntegerProperty(prop, -1);
                if (loc == -1) {
                    loc = parentScroller.getPreferredSize().height;
                }
                BrowserView.this.splitPane.setDividerLocation(loc);
                BrowserView.this.parentDirectories.ensureIndexIsVisible(BrowserView.this.parentDirectories.getModel().getSize());
            }
        });
        if (browser.isMultipleSelectionEnabled()) {
            this.table.getSelectionModel().setSelectionMode(2);
        } else {
            this.table.getSelectionModel().setSelectionMode(0);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", this.splitPane);
        this.propertiesChanged();
    }

    public void focusOnFileView() {
        this.table.requestFocus();
    }

    @Override
    public void removeNotify() {
        String prop = this.browser.isHorizontalLayout() ? "vfs.browser.horizontalSplitter" : "vfs.browser.splitter";
        jEdit.setIntegerProperty(prop, this.splitPane.getDividerLocation());
        super.removeNotify();
    }

    public VFSFile[] getSelectedFiles() {
        return this.table.getSelectedFiles();
    }

    public void selectNone() {
        this.table.clearSelection();
    }

    public void saveExpansionState() {
        this.tmpExpanded.clear();
        this.table.getExpandedDirectories(this.tmpExpanded);
    }

    public void clearExpansionState() {
        this.tmpExpanded.clear();
    }

    public void loadDirectory(Object node, String path, boolean addToHistory) {
        this.loadDirectory(node, path, addToHistory, null);
    }

    public void loadDirectory(final Object node, String path, final boolean addToHistory, final Runnable delayedAWTTask) {
        path = MiscUtilities.constructPath(this.browser.getDirectory(), path);
        VFS vfs = VFSManager.getVFSForPath(path);
        Object session = vfs.createVFSSession(path, this);
        if (session == null) {
            return;
        }
        if (node == null) {
            this.parentDirectories.setListData(new Object[]{new LoadingPlaceholder()});
        }
        final Object[] loadInfo = new Object[2];
        Runnable awtRunnable = new Runnable(){

            @Override
            public void run() {
                BrowserView.this.browser.directoryLoaded(node, loadInfo, addToHistory);
                if (delayedAWTTask != null) {
                    delayedAWTTask.run();
                }
            }
        };
        ThreadUtilities.runInBackground(new ListDirectoryBrowserTask(this.browser, session, vfs, path, null, loadInfo, awtRunnable));
    }

    public void directoryLoaded(Object node, String path, List<VFSFile> directory) {
        if (node == null) {
            DefaultListModel<VFSFile> parentList = new DefaultListModel<VFSFile>();
            String parent = path;
            while (true) {
                VFS _vfs = VFSManager.getVFSForPath(parent);
                VFSFile file = null;
                if (_vfs instanceof FileVFS) {
                    Object session = _vfs.createVFSSession(path, this.browser);
                    try {
                        file = _vfs._getFile(session, parent, this.browser);
                        if (file != null) {
                            file.setName(_vfs.getFileName(parent));
                        }
                    }
                    catch (IOException e) {
                        Log.log(9, this, e, e);
                    }
                }
                if (file == null) {
                    file = new VFSFile(_vfs.getFileName(parent), parent, parent, 1, 0L, false);
                }
                parentList.insertElementAt(file, 0);
                String newParent = _vfs.getParentOfPath(parent);
                if (newParent == null || MiscUtilities.pathsEqual(parent, newParent)) break;
                parent = newParent;
            }
            this.parentDirectories.setModel(parentList);
            int index = parentList.getSize() - 1;
            this.parentDirectories.setSelectedIndex(index);
            this.parentDirectories.ensureIndexIsVisible(index);
        }
        this.table.setDirectory(VFSManager.getVFSForPath(path), node, directory, this.tmpExpanded);
    }

    public void updateFileView() {
        this.table.repaint();
    }

    public void maybeReloadDirectory(String path) {
        String browserDir = this.browser.getDirectory();
        String symlinkBrowserDir = MiscUtilities.isURL(browserDir) ? browserDir : MiscUtilities.resolveSymlinks(browserDir);
        if (MiscUtilities.pathsEqual(path, symlinkBrowserDir)) {
            this.saveExpansionState();
            this.loadDirectory(null, browserDir, false);
        }
        if (!(browserDir.startsWith("favorites") || browserDir.startsWith("roots") || path.startsWith(symlinkBrowserDir))) {
            return;
        }
        if (browserDir.startsWith("roots") && MiscUtilities.isURL(path) && !"file".equals(MiscUtilities.getProtocolOfURL(path))) {
            return;
        }
        this.table.maybeReloadDirectory(path);
    }

    public void propertiesChanged() {
        this.showIcons = jEdit.getBooleanProperty("vfs.browser.showIcons");
        this.table.propertiesChanged();
        GUIUtilities.initContinuousLayout(this.splitPane);
        this.splitPane.setBorder(null);
    }

    public VFSBrowser getBrowser() {
        return this.browser;
    }

    public VFSDirectoryEntryTable getTable() {
        return this.table;
    }

    public JList getParentDirectoryList() {
        return this.parentDirectories;
    }

    private void showFilePopup(VFSFile[] files, Component comp, Point point) {
        this.popup = new BrowserCommandsMenu(this.browser, files);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int index = BrowserView.this.parentDirectories.getModel().getSize() - 1;
                        BrowserView.this.parentDirectories.setSelectedIndex(index);
                    }
                });
            }
        });
        GUIUtilities.showPopupMenu(this.popup, comp, point.x, point.y);
    }

    class ParentDirectoryList
    extends JList {
        ParentDirectoryList() {
        }

        public String getPath(int row) {
            LinkedList<String> components = new LinkedList<String>();
            for (int i = 1; i <= row; ++i) {
                components.add(this.getModel().getElementAt(i).toString());
            }
            return this.getModel().getElementAt(0) + TextUtilities.join(components, File.separator);
        }

        @Override
        protected void processKeyEvent(KeyEvent evt) {
            if (evt.getID() == 401) {
                ActionContext ac = VFSBrowser.getActionContext();
                int row = BrowserView.this.parentDirectories.getSelectedIndex();
                switch (evt.getKeyCode()) {
                    case 40: {
                        evt.consume();
                        if (row >= ((BrowserView)BrowserView.this).parentDirectories.getSize().height - 1) break;
                        BrowserView.this.parentDirectories.setSelectedIndex(++row);
                        break;
                    }
                    case 37: {
                        if ((evt.getModifiers() & 8) > 0) {
                            evt.consume();
                            BrowserView.this.browser.previousDirectory();
                            break;
                        }
                        super.processEvent(evt);
                        break;
                    }
                    case 39: {
                        if ((evt.getModifiers() & 8) > 0) {
                            evt.consume();
                            BrowserView.this.browser.nextDirectory();
                            break;
                        }
                        super.processEvent(evt);
                        break;
                    }
                    case 9: {
                        evt.consume();
                        if ((evt.getModifiers() & 1) > 0) {
                            BrowserView.this.browser.focusOnDefaultComponent();
                            break;
                        }
                        BrowserView.this.table.requestFocus();
                        break;
                    }
                    case 38: {
                        evt.consume();
                        if (row <= 0) break;
                        BrowserView.this.parentDirectories.setSelectedIndex(--row);
                        break;
                    }
                    case 8: {
                        evt.consume();
                        EditAction up = ac.getAction("vfs.browser.up");
                        ac.invokeAction(evt, up);
                        break;
                    }
                    case 116: {
                        evt.consume();
                        EditAction reload = ac.getAction("vfs.browser.reload");
                        ac.invokeAction(evt, reload);
                        break;
                    }
                    case 10: {
                        evt.consume();
                        String path = this.getPath(row);
                        BrowserView.this.getBrowser().setDirectory(path);
                        BrowserView.this.table.requestFocus();
                    }
                }
            } else if (evt.getID() == 400) {
                if (evt.isControlDown() || evt.isAltDown() || evt.isMetaDown()) {
                    evt.consume();
                    return;
                }
                switch (evt.getKeyChar()) {
                    case '~': {
                        evt.consume();
                        if (BrowserView.this.browser.getMode() != 2) break;
                        BrowserView.this.browser.setDirectory(System.getProperty("user.home"));
                        break;
                    }
                    case '/': {
                        evt.consume();
                        if (BrowserView.this.browser.getMode() != 2) break;
                        BrowserView.this.browser.rootDirectory();
                        break;
                    }
                    case '-': {
                        evt.consume();
                        if (BrowserView.this.browser.getMode() != 2) break;
                        BrowserView.this.browser.setDirectory(BrowserView.this.browser.getView().getBuffer().getDirectory());
                    }
                }
            }
            if (!evt.isConsumed()) {
                super.processKeyEvent(evt);
            }
        }
    }

    private static class LoadingPlaceholder {
        private LoadingPlaceholder() {
        }
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            Point p = evt.getPoint();
            int row = BrowserView.this.table.rowAtPoint(p);
            int column = BrowserView.this.table.columnAtPoint(p);
            if (row == -1) {
                return;
            }
            if (column == 0) {
                VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)BrowserView.this.table.getModel().getValueAt(row, 0);
                if (FileCellRenderer.ExpansionToggleBorder.isExpansionToggle(entry.level, p.x)) {
                    return;
                }
            }
            if ((evt.getModifiers() & 0x10) != 0 && evt.getClickCount() % 2 == 0) {
                BrowserView.this.browser.filesActivated(evt.isShiftDown() ? 1 : 0, true);
            } else if (GUIUtilities.isMiddleButton(evt.getModifiers())) {
                if (evt.isShiftDown()) {
                    BrowserView.this.table.getSelectionModel().addSelectionInterval(row, row);
                } else {
                    BrowserView.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
                BrowserView.this.browser.filesActivated(evt.isShiftDown() ? 1 : 0, true);
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            Point p = evt.getPoint();
            if (evt.getSource() != BrowserView.this.table) {
                p.x -= BrowserView.this.table.getX();
                p.y -= BrowserView.this.table.getY();
            }
            int row = BrowserView.this.table.rowAtPoint(p);
            int column = BrowserView.this.table.columnAtPoint(p);
            if (column == 0 && row != -1) {
                VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)BrowserView.this.table.getModel().getValueAt(row, 0);
                if (FileCellRenderer.ExpansionToggleBorder.isExpansionToggle(entry.level, p.x)) {
                    BrowserView.this.table.toggleExpanded(row);
                    return;
                }
            }
            if (GUIUtilities.isMiddleButton(evt.getModifiers())) {
                if (row != -1) {
                    if (evt.isShiftDown()) {
                        BrowserView.this.table.getSelectionModel().addSelectionInterval(row, row);
                    } else {
                        BrowserView.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                }
            } else if (GUIUtilities.isPopupTrigger(evt)) {
                if (BrowserView.this.popup != null && BrowserView.this.popup.isVisible()) {
                    BrowserView.this.popup.setVisible(false);
                    BrowserView.this.popup = null;
                    return;
                }
                if (row == -1) {
                    BrowserView.this.showFilePopup(null, BrowserView.this.table, evt.getPoint());
                } else {
                    if (!BrowserView.this.table.getSelectionModel().isSelectedIndex(row)) {
                        BrowserView.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                    BrowserView.this.showFilePopup(BrowserView.this.getSelectedFiles(), BrowserView.this.table, evt.getPoint());
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!GUIUtilities.isPopupTrigger(evt) && BrowserView.this.table.getSelectedRow() != -1) {
                BrowserView.this.browser.filesSelected();
            }
        }
    }

    private class ParentMouseHandler
    extends MouseAdapter {
        private ParentMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            Object obj;
            int row = BrowserView.this.parentDirectories.locationToIndex(evt.getPoint());
            if (row != -1 && (obj = BrowserView.this.parentDirectories.getModel().getElementAt(row)) instanceof VFSFile) {
                VFSFile dirEntry = (VFSFile)obj;
                if (GUIUtilities.isPopupTrigger(evt)) {
                    if (BrowserView.this.popup != null && BrowserView.this.popup.isVisible()) {
                        BrowserView.this.popup.setVisible(false);
                        BrowserView.this.popup = null;
                    } else {
                        BrowserView.this.parentDirectories.setSelectedIndex(row);
                        BrowserView.this.showFilePopup(new VFSFile[]{dirEntry}, BrowserView.this.parentDirectories, evt.getPoint());
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            Object obj;
            if (evt.getClickCount() % 2 != 0 && !GUIUtilities.isMiddleButton(evt.getModifiers())) {
                return;
            }
            int row = BrowserView.this.parentDirectories.locationToIndex(evt.getPoint());
            if (row != -1 && (obj = BrowserView.this.parentDirectories.getModel().getElementAt(row)) instanceof VFSFile) {
                VFSFile dirEntry = (VFSFile)obj;
                if (!GUIUtilities.isPopupTrigger(evt)) {
                    BrowserView.this.browser.setDirectory(dirEntry.getPath());
                    if (BrowserView.this.browser.getMode() == 2) {
                        BrowserView.this.focusOnFileView();
                    }
                }
            }
        }
    }

    class ParentDirectoryRenderer
    extends DefaultListCellRenderer {
        private Font plainFont = UIManager.getFont("Tree.font");
        private final Font boldFont;

        ParentDirectoryRenderer() {
            if (this.plainFont == null) {
                this.plainFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setBorder(new EmptyBorder(1, index * 5 + 1, 1, 1));
            if (value instanceof LoadingPlaceholder) {
                this.setFont(this.plainFont);
                this.setIcon(BrowserView.this.showIcons ? FileCellRenderer.loadingIcon : null);
                this.setText(jEdit.getProperty("vfs.browser.tree.loading"));
            } else if (value instanceof VFSFile) {
                VFSFile dirEntry = (VFSFile)value;
                this.setFont(this.boldFont);
                this.setIcon(BrowserView.this.showIcons ? FileCellRenderer.getIconForFile(dirEntry, true) : null);
                this.setText(dirEntry.getName());
            } else if (value == null) {
                this.setText("VFS does not follow VFS API");
            }
            return this;
        }
    }
}

