/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.TaskListener;
import org.gjt.sp.util.TaskManager;
import org.gjt.sp.util.ThreadUtilities;

abstract class AbstractBrowserTask
extends Task {
    protected VFSBrowser browser;
    protected Object session;
    protected VFS vfs;
    protected String path1;
    protected String path2;
    protected Object[] loadInfo;

    AbstractBrowserTask(VFSBrowser browser, Object session, VFS vfs, String path1, String path2, Object[] loadInfo) {
        this(browser, session, vfs, path1, path2, loadInfo, null);
    }

    AbstractBrowserTask(VFSBrowser browser, Object session, VFS vfs, String path1, String path2, Object[] loadInfo, Runnable awtTask) {
        this.browser = browser;
        this.session = session;
        this.vfs = vfs;
        this.path1 = path1;
        this.path2 = path2;
        this.loadInfo = loadInfo;
        if (awtTask != null) {
            MyTaskListener listener = new MyTaskListener(awtTask);
            TaskManager.instance.addTaskListener(listener);
        }
    }

    private class MyTaskListener
    implements TaskListener {
        private final Runnable runnable;

        private MyTaskListener(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void waiting(Task task) {
        }

        @Override
        public void running(Task task) {
        }

        @Override
        public void done(Task task) {
            if (task == AbstractBrowserTask.this) {
                TaskManager.instance.removeTaskListener(this);
                ThreadUtilities.runInDispatchThread(this.runnable);
            }
        }

        @Override
        public void statusUpdated(Task task) {
        }

        @Override
        public void maximumUpdated(Task task) {
        }

        @Override
        public void valueUpdated(Task task) {
        }
    }
}

