/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferChangeListener;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.BufferUndoListener;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.bufferio.BufferAutosaveRequest;
import org.gjt.sp.jedit.bufferio.MarkersSaveRequest;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.gui.StyleEditor;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.jedit.visitors.SaveCaretInfoVisitor;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.ThreadUtilities;

public class Buffer
extends JEditBuffer {
    public static final String BACKED_UP = "Buffer__backedUp";
    public static final String CARET = "Buffer__caret";
    public static final String CARET_POSITIONED = "Buffer__caretPositioned";
    public static final String SELECTION = "Buffer__selection";
    public static final String SCROLL_VERT = "Buffer__scrollVert";
    public static final String SCROLL_HORIZ = "Buffer__scrollHoriz";
    public static final String ENCODING_AUTODETECT = "encodingAutodetect";
    public static final String TRAILING_EOL = "trailingEOL";
    public static final String GZIPPED = "gzipped";
    public static final int FILE_NOT_CHANGED = 0;
    public static final int FILE_CHANGED = 1;
    public static final int FILE_DELETED = 2;
    Buffer prev;
    Buffer next;
    private static final int CLOSED = 0;
    private static final int NEW_FILE = 3;
    private static final int UNTITLED = 4;
    private static final int AUTOSAVE_DIRTY = 5;
    private static final int AUTORELOAD = 6;
    private static final int AUTORELOAD_DIALOG = 7;
    private static final int TEMPORARY = 10;
    private static final int MARKERS_CHANGED = 12;
    private int flags;
    private boolean autoreloadOverridden;
    private String path;
    private String symlinkPath;
    private String name;
    private String directory;
    private File file;
    private File autosaveFile;
    private long modTime;
    private byte[] md5hash;
    private int initialLength;
    private final Vector<Marker> markers = new Vector();
    private Socket waitSocket;
    private List<BufferUndoListener> undoListeners;

    public void reload(View view) {
        Object[] args;
        int result;
        if (this.getFlag(4)) {
            return;
        }
        if (this.isDirty() && (result = GUIUtilities.confirm(view, "changedreload", args = new String[]{this.path}, 0, 2)) != 0) {
            return;
        }
        view.visit(new SaveCaretInfoVisitor());
        this.load(view, true);
    }

    public boolean load(final View view, final boolean reload) {
        boolean loadAutosave;
        if (this.isPerformingIO()) {
            GUIUtilities.error(view, "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        this.setLoading(true);
        if (!this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, view, BufferUpdate.LOAD_STARTED));
        }
        if (reload || !this.getFlag(3)) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!reload && this.autosaveFile != null && this.autosaveFile.exists()) {
                loadAutosave = this.recoverAutosave(view);
            } else {
                if (this.autosaveFile != null) {
                    this.autosaveFile.delete();
                }
                loadAutosave = false;
            }
            if (!loadAutosave) {
                VFS vfs = VFSManager.getVFSForPath(this.path);
                if (!this.checkFileForLoad(view, vfs, this.path)) {
                    this.setLoading(false);
                    return false;
                }
                if (!(!reload && this.getFlag(3) || vfs.load(view, this, this.path))) {
                    this.setLoading(false);
                    return false;
                }
            }
        } else {
            loadAutosave = false;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String newPath = Buffer.this.getStringProperty("BufferIORequest__newPath");
                Segment seg = (Segment)Buffer.this.getProperty("BufferIORequest__loadData");
                IntegerArray endOffsets = (IntegerArray)Buffer.this.getProperty("BufferIORequest__endOffsets");
                Buffer.this.loadText(seg, endOffsets);
                Buffer.this.unsetProperty("BufferIORequest__loadData");
                Buffer.this.unsetProperty("BufferIORequest__endOffsets");
                Buffer.this.unsetProperty("BufferIORequest__newPath");
                Buffer.this.undoMgr.clear();
                Buffer.this.undoMgr.setLimit(jEdit.getIntegerProperty("buffer.undoCount", 100));
                if (!Buffer.this.getFlag(10)) {
                    Buffer.this.finishLoading();
                }
                Buffer.this.setLoading(false);
                if (reload) {
                    Buffer.this.setDirty(false);
                }
                if (!loadAutosave && newPath != null) {
                    Buffer.this.setPath(newPath);
                }
                if (loadAutosave) {
                    Buffer.super.setDirty(true);
                }
                if (!Buffer.this.getFlag(10)) {
                    Buffer.this.fireBufferLoaded();
                    EditBus.send(new BufferUpdate(Buffer.this, view, BufferUpdate.LOADED));
                }
            }
        };
        if (this.getFlag(10)) {
            runnable.run();
        } else {
            VFSManager.runInAWTThread(runnable);
        }
        return true;
    }

    public boolean insertFile(View view, String path) {
        if (this.isPerformingIO()) {
            GUIUtilities.error(view, "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        path = MiscUtilities.constructPath(this.path, path);
        Buffer buffer = jEdit.getBuffer(path);
        if (buffer != null) {
            view.getTextArea().setSelectedText(buffer.getText(0, buffer.getLength()));
            return true;
        }
        VFS vfs = VFSManager.getVFSForPath(path);
        return vfs.insert(view, this, path);
    }

    public void autosave() {
        if (this.autosaveFile == null || !this.getFlag(5) || !this.isDirty() || this.isPerformingIO() || !this.autosaveFile.getParentFile().exists()) {
            return;
        }
        this.setFlag(5, false);
        VFSManager.runInWorkThread(new BufferAutosaveRequest(null, this, null, VFSManager.getFileVFS(), this.autosaveFile.getPath()));
    }

    public boolean saveAs(View view, boolean rename) {
        String[] files = GUIUtilities.showVFSFileDialog(view, this.path, 1, false);
        if (files == null) {
            return false;
        }
        boolean saved = this.save(view, files[0], rename);
        if (saved) {
            this.setReadOnly(false);
        }
        return saved;
    }

    public boolean save(View view, String path) {
        return this.save(view, path, true, false);
    }

    public boolean save(View view, String path, boolean rename) {
        return this.save(view, path, rename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean save(final View view, String path, final boolean rename, boolean disableFileStatusCheck) {
        block32: {
            block33: {
                block35: {
                    block34: {
                        if (this.isPerformingIO()) {
                            GUIUtilities.error(view, "buffer-multiple-io", null);
                            return false;
                        }
                        this.setBooleanProperty("BufferIORequest__error", false);
                        if (path == null && this.getFlag(3)) {
                            return this.saveAs(view, rename);
                        }
                        if (path == null && this.file != null && (newModTime = this.file.lastModified()) != this.modTime && jEdit.getBooleanProperty("view.checkModStatus") && (result = GUIUtilities.confirm(view, "filechanged-save", args = new Object[]{this.path}, 0, 2)) != 0) {
                            return false;
                        }
                        EditBus.send(new BufferUpdate(this, view, BufferUpdate.SAVING));
                        this.setPerformingIO(true);
                        oldPath = this.path;
                        oldSymlinkPath = this.symlinkPath;
                        newPath = path == null ? this.path : path;
                        vfs = VFSManager.getVFSForPath(newPath);
                        if (!Buffer.checkFileForSave(view, vfs, newPath)) {
                            this.setPerformingIO(false);
                            return false;
                        }
                        session = vfs.createVFSSession(newPath, view);
                        if (session == null) {
                            this.setPerformingIO(false);
                            return false;
                        }
                        this.unsetProperty("overwriteReadonly");
                        this.unsetProperty("forbidTwoStageSave");
                        file = vfs._getFile(session, newPath, view);
                        if (file == null) break block32;
                        v0 = vfsRenameCap = (vfs.getCapabilities() & 16) != 0;
                        if (file.isWriteable()) break block33;
                        Log.log(7, this, "Buffer saving : File " + file + " is readOnly");
                        if (!vfsRenameCap) ** GOTO lbl69
                        Log.log(1, this, "Buffer saving : VFS can rename files");
                        savePath = vfs._canonPath(session, newPath, view);
                        if (!MiscUtilities.isURL(savePath)) {
                            savePath = MiscUtilities.resolveSymlinks(savePath);
                        }
                        if ((savePath = vfs.getTwoStageSaveName(savePath)) != null) break block34;
                        Log.log(1, this, "Buffer saving : two stage save impossible because path is null");
                        VFSManager.error(view, newPath, "ioerror.save-readonly-twostagefail", null);
                        this.setPerformingIO(false);
                        var13_21 = false;
                        try {
                            vfs._endVFSSession(session, view);
                        }
                        catch (IOException io) {
                            VFSManager.error(view, newPath, "ioerror", new String[]{io.toString()});
                            this.setPerformingIO(false);
                            return false;
                        }
                        return var13_21;
                    }
                    result = GUIUtilities.confirm(view, "vfs.overwrite-readonly", new Object[]{newPath}, 0, 2);
                    if (result == 0) {
                        Log.log(7, this, "Buffer saving : two stage save will be used to save buffer");
                        this.setBooleanProperty("overwriteReadonly", true);
                        break block35;
                    }
                    Log.log(1, this, "Buffer not saved");
                    this.setPerformingIO(false);
                    var14_26 = false;
                    try {
                        vfs._endVFSSession(session, view);
                    }
                    catch (IOException io) {
                        VFSManager.error(view, newPath, "ioerror", new String[]{io.toString()});
                        this.setPerformingIO(false);
                        return false;
                    }
                    return var14_26;
                }
                break block32;
lbl69:
                // 1 sources

                Log.log(7, this, "Buffer saving : file is readonly and vfs cannot do two stage save");
                VFSManager.error(view, newPath, "ioerror.write-error-readonly", null);
                this.setPerformingIO(false);
                savePath = false;
                try {
                    vfs._endVFSSession(session, view);
                }
                catch (IOException io) {
                    VFSManager.error(view, newPath, "ioerror", new String[]{io.toString()});
                    this.setPerformingIO(false);
                    return false;
                }
                return savePath;
            }
            savePath = vfs._canonPath(session, newPath, view);
            if (!MiscUtilities.isURL(savePath)) {
                savePath = MiscUtilities.resolveSymlinks(savePath);
            }
            savePath = vfs.getTwoStageSaveName(savePath);
            if (!jEdit.getBooleanProperty("twoStageSave") || vfsRenameCap && savePath != null) break block32;
            result = GUIUtilities.confirm(view, "vfs.twostageimpossible", new Object[]{newPath}, 0, 2);
            if (result == 0) {
                Log.log(7, this, "Buffer saving : two stage save cannot be used");
                this.setBooleanProperty("forbidTwoStageSave", true);
                break block32;
            }
            Log.log(1, this, "Buffer not saved");
            this.setPerformingIO(false);
            var14_27 = false;
            try {
                vfs._endVFSSession(session, view);
            }
            catch (IOException io) {
                VFSManager.error(view, newPath, "ioerror", new String[]{io.toString()});
                this.setPerformingIO(false);
                return false;
            }
            return var14_27;
        }
        try {
            vfs._endVFSSession(session, view);
        }
        catch (IOException io) {
            VFSManager.error(view, newPath, "ioerror", new String[]{io.toString()});
            this.setPerformingIO(false);
            return false;
        }
        catch (IOException io) {
            try {
                VFSManager.error(view, newPath, "ioerror", new String[]{io.toString()});
                this.setPerformingIO(false);
                var11_16 = false;
            }
            catch (Throwable var16_30) {
                try {
                    vfs._endVFSSession(session, view);
                }
                catch (IOException io) {
                    VFSManager.error(view, newPath, "ioerror", new String[]{io.toString()});
                    this.setPerformingIO(false);
                    return false;
                }
                throw var16_30;
            }
            try {
                vfs._endVFSSession(session, view);
            }
            catch (IOException io) {
                VFSManager.error(view, newPath, "ioerror", new String[]{io.toString()});
                this.setPerformingIO(false);
                return false;
            }
            return var11_16;
        }
        if (!vfs.save(view, this, newPath)) {
            this.setPerformingIO(false);
            return false;
        }
        VFSManager.runInAWTThread(new Runnable(){

            @Override
            public void run() {
                Buffer.this.setPerformingIO(false);
                Buffer.this.setProperty("overwriteReadonly", null);
                Buffer.this.finishSaving(view, oldPath, oldSymlinkPath, newPath, rename, Buffer.this.getBooleanProperty("BufferIORequest__error"));
                Buffer.this.updateMarkersFile(view);
            }
        });
        check = jEdit.getIntegerProperty("checkFileStatus");
        if (!(disableFileStatusCheck || check != 1 && check != 2)) {
            jEdit.checkBufferStatus(view, false);
        }
        return true;
    }

    public int checkFileStatus(View view) {
        if (!this.isPerformingIO() && this.file != null && !this.getFlag(3)) {
            boolean newReadOnly;
            boolean bl = newReadOnly = this.file.exists() && !this.file.canWrite();
            if (newReadOnly != this.isFileReadOnly()) {
                this.setFileReadOnly(newReadOnly);
                EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
            }
            long oldModTime = this.modTime;
            long newModTime = this.file.lastModified();
            if (newModTime != oldModTime) {
                this.modTime = newModTime;
                if (!this.file.exists()) {
                    this.setFlag(3, true);
                    this.setDirty(true);
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    public long getLastModified() {
        return this.modTime;
    }

    public void setLastModified(long modTime) {
        this.modTime = modTime;
    }

    public boolean getAutoReload() {
        return this.getFlag(6);
    }

    public void setAutoReload(boolean value) {
        this.setFlag(6, value);
        this.autoreloadOverridden = this.isAutoreloadPropertyOverriden();
    }

    public boolean getAutoReloadDialog() {
        return this.getFlag(7);
    }

    public void setAutoReloadDialog(boolean value) {
        this.setFlag(7, value);
        this.autoreloadOverridden = this.isAutoreloadPropertyOverriden();
    }

    public VFS getVFS() {
        return VFSManager.getVFSForPath(this.path);
    }

    public File getAutosaveFile() {
        return this.autosaveFile;
    }

    public void removeAutosaveFile() {
        if (this.autosaveFile != null) {
            this.autosaveFile.delete();
            this.setFlag(5, true);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(Boolean shortVersion) {
        return shortVersion != false ? MiscUtilities.abbreviate(this.path) : this.getPath();
    }

    public String getSymlinkPath() {
        return this.symlinkPath;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isClosed() {
        return this.getFlag(0);
    }

    public boolean isLoaded() {
        return !this.isLoading();
    }

    public boolean isNewFile() {
        return this.getFlag(3);
    }

    public void setNewFile(boolean newFile) {
        this.setFlag(3, newFile);
        if (!newFile) {
            this.setFlag(4, false);
        }
    }

    public boolean isUntitled() {
        return this.getFlag(4);
    }

    @Override
    public void setDirty(boolean d) {
        boolean old_d = this.isDirty();
        if (this.isUntitled() && jEdit.getBooleanProperty("suppressNotSavedConfirmUntitled")) {
            d = false;
        }
        if (d && this.getLength() == this.initialLength && jEdit.getBooleanProperty("useMD5forDirtyCalculation")) {
            d = !Arrays.equals(this.calculateHash(), this.md5hash);
        }
        super.setDirty(d);
        boolean editable = this.isEditable();
        if (d) {
            if (editable) {
                this.setFlag(5, true);
            }
        } else {
            this.setFlag(5, false);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
        }
        if (d != old_d && editable) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
        }
    }

    public boolean isTemporary() {
        return this.getFlag(10);
    }

    public Icon getIcon() {
        if (this.isDirty()) {
            return GUIUtilities.loadIcon("dirty.gif");
        }
        if (this.isReadOnly()) {
            return GUIUtilities.loadIcon("readonly.gif");
        }
        if (this.getFlag(3)) {
            return GUIUtilities.loadIcon("new.gif");
        }
        return GUIUtilities.loadIcon("normal.gif");
    }

    @Deprecated
    public void addBufferChangeListener(BufferChangeListener listener, int priority) {
        this.addBufferListener(new BufferChangeListener.Adapter(listener), priority);
    }

    @Deprecated
    public void addBufferChangeListener(BufferChangeListener listener) {
        this.addBufferListener(new BufferChangeListener.Adapter(listener), 0);
    }

    @Deprecated
    public void removeBufferChangeListener(BufferChangeListener listener) {
        BufferListener[] listeners = this.getBufferListeners();
        for (int i = 0; i < listeners.length; ++i) {
            BufferListener l = listeners[i];
            if (!(l instanceof BufferChangeListener.Adapter) || ((BufferChangeListener.Adapter)l).getDelegate() != listener) continue;
            this.removeBufferListener(l);
            return;
        }
    }

    @Override
    public void propertiesChanged() {
        super.propertiesChanged();
        if (!this.autoreloadOverridden) {
            this.setAutoReloadDialog(jEdit.getBooleanProperty("autoReloadDialog"));
            this.setAutoReload(jEdit.getBooleanProperty("autoReload"));
        }
        if (!this.isTemporary()) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.PROPERTIES_CHANGED));
        }
    }

    @Override
    public Object getDefaultProperty(String name) {
        Object retVal;
        if (this.mode != null) {
            Object retVal2 = this.mode.getProperty(name);
            if (retVal2 == null) {
                return null;
            }
            this.setDefaultProperty(name, retVal2);
            return retVal2;
        }
        String value = jEdit.getProperty("buffer." + name);
        if (value == null) {
            return null;
        }
        try {
            retVal = new Integer(value);
        }
        catch (NumberFormatException nf) {
            retVal = value;
        }
        return retVal;
    }

    public void toggleWordWrap(View view) {
        String wrap = this.getStringProperty("wrap");
        if (wrap.equals("none")) {
            wrap = "soft";
        } else if (wrap.equals("soft")) {
            wrap = "hard";
        } else if (wrap.equals("hard")) {
            wrap = "none";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.wrap-changed", new String[]{wrap}));
        this.setProperty("wrap", wrap);
        this.propertiesChanged();
    }

    public void toggleLineSeparator(View view) {
        String status = null;
        String lineSep = this.getStringProperty("lineSeparator");
        if ("\n".equals(lineSep)) {
            status = "windows";
            lineSep = "\r\n";
        } else if ("\r\n".equals(lineSep)) {
            status = "mac";
            lineSep = "\r";
        } else if ("\r".equals(lineSep)) {
            status = "unix";
            lineSep = "\n";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.linesep-changed", new String[]{jEdit.getProperty("lineSep." + status)}));
        this.setProperty("lineSeparator", lineSep);
        this.setDirty(true);
        this.propertiesChanged();
    }

    @Override
    public String getContextSensitiveProperty(int offset, String name) {
        ParserRuleSet rules;
        Object value = super.getContextSensitiveProperty(offset, name);
        if (value == null && (value = jEdit.getMode((rules = this.getRuleSetAtOffset(offset)).getModeName()).getProperty(name)) == null) {
            value = this.mode.getProperty(name);
        }
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public void setMode() {
        String firstLine;
        Mode mode;
        String userMode = this.getStringProperty("mode");
        if (userMode != null) {
            this.unsetProperty("mode");
            Mode m = ModeProvider.instance.getMode(userMode);
            if (m != null) {
                this.setMode(m);
                return;
            }
        }
        if ((mode = ModeProvider.instance.getModeForFile(this.name, firstLine = this.getLineText(0))) != null) {
            this.setMode(mode);
            return;
        }
        Mode defaultMode = jEdit.getMode(jEdit.getProperty("buffer.defaultMode"));
        if (defaultMode == null) {
            defaultMode = jEdit.getMode("text");
        }
        if (defaultMode != null) {
            this.setMode(defaultMode);
        }
    }

    @Deprecated
    public void putProperty(Object name, Object value) {
        if (!(name instanceof String)) {
            return;
        }
        this.setProperty((String)name, value);
    }

    @Deprecated
    public void putBooleanProperty(String name, boolean value) {
        this.setBooleanProperty(name, value);
    }

    @Deprecated
    public TokenList markTokens(int lineIndex) {
        TokenList list = new TokenList();
        this.markTokens(lineIndex, list);
        return list;
    }

    @Deprecated
    public void insertString(int offset, String str, AttributeSet attr) {
        this.insert(offset, str);
    }

    @Deprecated
    public File getFile() {
        return this.file;
    }

    public Vector<Marker> getMarkers() {
        return this.markers;
    }

    public String getMarkerStatusPrompt(String action) {
        return jEdit.getProperty("view.status." + action, new String[]{this.getMarkerNameString()});
    }

    public String getMarkerNameString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            if (marker.getShortcut() == '\u0000') continue;
            if (buf.length() != 0) {
                buf.append(' ');
            }
            buf.append(marker.getShortcut());
        }
        if (buf.length() == 0) {
            return jEdit.getProperty("view.status.no-markers");
        }
        return buf.toString();
    }

    public void addOrRemoveMarker(char shortcut, int pos) {
        int line = this.getLineOfOffset(pos);
        if (this.getMarkerAtLine(line) != null) {
            this.removeMarker(line);
        } else {
            this.addMarker(shortcut, pos);
        }
    }

    public void addMarker(char shortcut, int pos) {
        Marker markerN = new Marker(this, shortcut, pos);
        boolean added = false;
        if (this.isLoaded()) {
            Marker marker;
            int i;
            this.setFlag(12, true);
            markerN.createPosition();
            for (i = 0; i < this.markers.size(); ++i) {
                marker = this.markers.get(i);
                if (shortcut != '\u0000' && marker.getShortcut() == shortcut) {
                    marker.setShortcut('\u0000');
                }
                if (marker.getPosition() != pos) continue;
                this.markers.removeElementAt(i);
                --i;
            }
            for (i = 0; i < this.markers.size(); ++i) {
                marker = this.markers.get(i);
                if (marker.getPosition() <= pos) continue;
                this.markers.insertElementAt(markerN, i);
                added = true;
                break;
            }
        }
        if (!added) {
            this.markers.addElement(markerN);
        }
        if (this.isLoaded() && !this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarkerInRange(int start, int end) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            int pos = marker.getPosition();
            if (pos < start || pos >= end) continue;
            return marker;
        }
        return null;
    }

    public Marker getMarkerAtLine(int line) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            if (this.getLineOfOffset(marker.getPosition()) != line) continue;
            return marker;
        }
        return null;
    }

    public void removeMarker(int line) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            if (this.getLineOfOffset(marker.getPosition()) != line) continue;
            this.setFlag(12, true);
            marker.removePosition();
            this.markers.removeElementAt(i);
            --i;
        }
        EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
    }

    public void removeAllMarkers() {
        this.setFlag(12, true);
        for (int i = 0; i < this.markers.size(); ++i) {
            this.markers.get(i).removePosition();
        }
        this.markers.removeAllElements();
        if (this.isLoaded()) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarker(char shortcut) {
        for (Marker marker : this.markers) {
            if (marker.getShortcut() != shortcut) continue;
            return marker;
        }
        return null;
    }

    @Deprecated
    public String getMarkersPath(VFS vfs) {
        return Buffer.getMarkersPath(vfs, this.path);
    }

    public static String getMarkersPath(VFS vfs, String path) {
        return vfs.getParentOfPath(path) + '.' + vfs.getFileName(path) + ".marks";
    }

    public boolean updateMarkersFile(View view) {
        if (!this.markersChanged()) {
            return true;
        }
        VFS vfs = VFSManager.getVFSForPath(this.getPath());
        if ((vfs.getCapabilities() & 2) == 0 || !vfs.isMarkersFileSupported()) {
            VFSManager.error(view, this.path, "vfs.not-supported.save", new String[]{"markers file"});
            return false;
        }
        Object session = vfs.createVFSSession(this.path, view);
        if (session == null) {
            return false;
        }
        ThreadUtilities.runInBackground(new MarkersSaveRequest(view, this, session, vfs, this.path));
        return true;
    }

    public boolean markersChanged() {
        return this.getFlag(12);
    }

    public void setMarkersChanged(boolean changed) {
        this.setFlag(12, changed);
    }

    public void setWaitSocket(Socket waitSocket) {
        this.waitSocket = waitSocket;
    }

    public Buffer getNext() {
        return this.next;
    }

    public Buffer getPrev() {
        return this.prev;
    }

    public int getIndex() {
        int count = 0;
        Buffer buffer = this.prev;
        while (buffer != null) {
            ++count;
            buffer = buffer.prev;
        }
        return count;
    }

    public String toString() {
        return this.name + " (" + MiscUtilities.abbreviate(this.directory) + ')';
    }

    public void addBufferUndoListener(BufferUndoListener listener) {
        this.undoListeners.add(listener);
    }

    public void removeBufferUndoListener(BufferUndoListener listener) {
        this.undoListeners.remove(listener);
    }

    Buffer(String path, boolean newFile, boolean temp, Map props) {
        super(props);
        this.setFlag(10, temp);
        this.setPath(path);
        this.setFlag(4, newFile);
        this.setFlag(3, newFile);
        this.setFlag(6, jEdit.getBooleanProperty("autoReload"));
        this.setFlag(7, jEdit.getBooleanProperty("autoReloadDialog"));
        this.undoListeners = new Vector<BufferUndoListener>();
    }

    void commitTemporary() {
        this.setFlag(10, false);
        this.finishLoading();
    }

    void close() {
        this.setFlag(0, true);
        if (this.autosaveFile != null) {
            this.autosaveFile.delete();
        }
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void fireBeginUndo() {
        for (BufferUndoListener listener : this.undoListeners) {
            try {
                listener.beginUndo(this);
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer undo event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    @Override
    protected void fireEndUndo() {
        for (BufferUndoListener listener : this.undoListeners) {
            try {
                listener.endUndo(this);
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer undo event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    @Override
    protected void fireBeginRedo() {
        for (BufferUndoListener listener : this.undoListeners) {
            try {
                listener.beginRedo(this);
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer begin redo event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    @Override
    protected void fireEndRedo() {
        for (BufferUndoListener listener : this.undoListeners) {
            try {
                listener.endRedo(this);
            }
            catch (Throwable t) {
                Log.log(9, this, "Exception while sending buffer end redo event to " + listener + " :");
                Log.log(9, this, t);
            }
        }
    }

    private void setFlag(int flag, boolean value) {
        this.flags = value ? (this.flags |= 1 << flag) : (this.flags &= ~(1 << flag));
    }

    private boolean getFlag(int flag) {
        int mask = 1 << flag;
        return (this.flags & mask) == mask;
    }

    private boolean isAutoreloadPropertyOverriden() {
        return this.getFlag(6) != jEdit.getBooleanProperty("autoReload") || this.getFlag(7) != jEdit.getBooleanProperty("autoReloadDialog");
    }

    private void setPath(final String path) {
        jEdit.visit(new JEditVisitorAdapter(){

            @Override
            public void visit(EditPane editPane) {
                editPane.bufferRenamed(Buffer.this.path, path);
            }
        });
        this.path = path;
        VFS vfs = VFSManager.getVFSForPath(path);
        if ((vfs.getCapabilities() & 2) == 0) {
            this.setFileReadOnly(true);
        }
        this.name = vfs.getFileName(path);
        this.directory = vfs.getParentOfPath(path);
        if (vfs instanceof FileVFS) {
            this.file = new File(path);
            this.symlinkPath = MiscUtilities.resolveSymlinks(path);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
            this.autosaveFile = new File(this.file.getParent(), '#' + this.name + '#');
        } else {
            this.file = null;
            this.autosaveFile = null;
            this.symlinkPath = path;
        }
    }

    private boolean recoverAutosave(final View view) {
        if (!this.autosaveFile.canRead()) {
            return false;
        }
        GUIUtilities.hideSplashScreen();
        final Object[] args = new Object[]{this.autosaveFile.getPath()};
        int result = GUIUtilities.confirm(view, "autosave-found", args, 0, 2);
        if (result == 0) {
            VFSManager.getFileVFS().load(view, this, this.autosaveFile.getPath());
            VFSManager.runInAWTThread(new Runnable(){

                @Override
                public void run() {
                    GUIUtilities.message(view, "autosave-loaded", args);
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkFileForLoad(View view, VFS vfs, String path) {
        if ((vfs.getCapabilities() & 0x40) != 0) {
            Object session;
            block22: {
                VFSFile file;
                block21: {
                    block20: {
                        session = vfs.createVFSSession(path, view);
                        if (session == null) {
                            return false;
                        }
                        file = vfs._getFile(session, path, view);
                        if (file != null) break block20;
                        this.setNewFile(true);
                        boolean bl = true;
                        try {
                            vfs._endVFSSession(session, view);
                        }
                        catch (IOException io) {
                            VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                            return false;
                        }
                        return bl;
                    }
                    if (file.isReadable()) break block21;
                    VFSManager.error(view, path, "ioerror.no-read", null);
                    this.setNewFile(false);
                    boolean bl = false;
                    try {
                        vfs._endVFSSession(session, view);
                    }
                    catch (IOException io) {
                        VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                        return false;
                    }
                    return bl;
                }
                this.setFileReadOnly(!file.isWriteable());
                if (file.getType() == 0) break block22;
                VFSManager.error(view, path, "ioerror.open-directory", null);
                this.setNewFile(false);
                boolean bl = false;
                try {
                    vfs._endVFSSession(session, view);
                }
                catch (IOException io) {
                    VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                    return false;
                }
                return bl;
            }
            try {
                vfs._endVFSSession(session, view);
            }
            catch (IOException io) {
                VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                return false;
            }
            catch (IOException io) {
                boolean bl;
                try {
                    VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        vfs._endVFSSession(session, view);
                    }
                    catch (IOException io2) {
                        VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                        return false;
                    }
                    throw throwable;
                }
                try {
                    vfs._endVFSSession(session, view);
                }
                catch (IOException io3) {
                    VFSManager.error(view, path, "ioerror", new String[]{io3.toString()});
                    return false;
                }
                return bl;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean checkFileForSave(View view, VFS vfs, String path) {
        if ((vfs.getCapabilities() & 0x40) != 0) {
            Object session;
            block18: {
                VFSFile file;
                block17: {
                    session = vfs.createVFSSession(path, view);
                    if (session == null) {
                        return false;
                    }
                    file = vfs._getFile(session, path, view);
                    if (file != null) break block17;
                    boolean bl = true;
                    try {
                        vfs._endVFSSession(session, view);
                    }
                    catch (IOException io) {
                        VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                        return false;
                    }
                    return bl;
                }
                if (file.getType() == 0) break block18;
                VFSManager.error(view, path, "ioerror.save-directory", null);
                boolean bl = false;
                try {
                    vfs._endVFSSession(session, view);
                }
                catch (IOException io) {
                    VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                    return false;
                }
                return bl;
            }
            try {
                vfs._endVFSSession(session, view);
            }
            catch (IOException io) {
                VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                return false;
            }
            catch (IOException io) {
                boolean bl;
                try {
                    VFSManager.error(view, path, "ioerror", new String[]{io.toString()});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        vfs._endVFSSession(session, view);
                    }
                    catch (IOException io2) {
                        VFSManager.error(view, path, "ioerror", new String[]{io2.toString()});
                        return false;
                    }
                    throw throwable;
                }
                try {
                    vfs._endVFSSession(session, view);
                }
                catch (IOException io3) {
                    VFSManager.error(view, path, "ioerror", new String[]{io3.toString()});
                    return false;
                }
                return bl;
            }
        }
        return true;
    }

    private byte[] calculateHash() {
        byte[] dummy = new byte[1];
        if (!jEdit.getBooleanProperty("useMD5forDirtyCalculation")) {
            return dummy;
        }
        return StandardUtilities.md5(this.getText());
    }

    private void updateHash() {
        this.initialLength = this.getLength();
        this.md5hash = this.calculateHash();
    }

    private void finishLoading() {
        this.updateHash();
        this.parseBufferLocalProperties();
        FoldHandler oldFoldHandler = this.getFoldHandler();
        this.setMode();
        if (this.getFoldHandler() == oldFoldHandler) {
            this.invalidateFoldLevels();
            this.fireFoldHandlerChanged();
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            marker.removePosition();
            int pos = marker.getPosition();
            if (pos > this.getLength()) {
                marker.setPosition(this.getLength());
            } else if (pos < 0) {
                marker.setPosition(0);
            }
            marker.createPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSaving(View view, String oldPath, String oldSymlinkPath, String path, boolean rename, boolean error) {
        if (!error && !path.equals(oldPath)) {
            Buffer buffer = jEdit.getBuffer(path);
            if (rename) {
                if (buffer != null && !buffer.getPath().equals(oldPath)) {
                    buffer.setDirty(false);
                    jEdit.closeBuffer(view, buffer);
                }
                this.setPath(path);
                jEdit.visit(new JEditVisitorAdapter(){

                    @Override
                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        if (bufferSet.indexOf(Buffer.this) != -1) {
                            bufferSet.sort();
                        }
                    }
                });
            } else if (buffer != null && !buffer.getPath().equals(oldPath)) {
                buffer.load(view, true);
            }
        }
        if (rename) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!error) {
                try {
                    this.writeLock();
                    if (this.autosaveFile != null) {
                        this.autosaveFile.delete();
                    }
                    this.setFlag(5, false);
                    this.setFileReadOnly(false);
                    this.setFlag(3, false);
                    this.setFlag(4, false);
                    super.setDirty(false);
                    if (jEdit.getBooleanProperty("resetUndoOnSave")) {
                        this.undoMgr.clear();
                    }
                }
                finally {
                    this.writeUnlock();
                }
                this.parseBufferLocalProperties();
                if (!this.getPath().equals(oldPath)) {
                    if (!this.isTemporary()) {
                        jEdit.updatePosition(oldSymlinkPath, this);
                    }
                    this.setMode();
                } else {
                    String newMode = this.getStringProperty("mode");
                    if (newMode != null && !newMode.equals(this.getMode().getName())) {
                        this.setMode();
                    } else {
                        this.propertiesChanged();
                    }
                }
                this.updateHash();
                if (!this.isTemporary()) {
                    EditBus.send(new BufferUpdate(this, view, BufferUpdate.DIRTY_CHANGED));
                    EditBus.send(new BufferUpdate(this, view, BufferUpdate.SAVED));
                }
            }
        }
    }

    @Deprecated
    public void editSyntaxStyle(JEditTextArea textArea) {
        StyleEditor.invokeForCaret(textArea);
    }

    @Deprecated
    public static class TokenList
    extends DefaultTokenHandler {
        public Token getFirstToken() {
            return this.getTokens();
        }
    }
}

