(*
    Universal property and evaluation homomorphism of univariate polynomials
    $Id: PolyHomo.thy,v 1.7 2005/09/17 18:49:15 wenzelm Exp $
    Author: Clemens Ballarin, started 15 April 1997
*)

theory PolyHomo imports UnivPoly2 begin

consts
  EVAL2	:: "['a::ring => 'b, 'b, 'a up] => 'b::ring"
  EVAL	:: "['a::ring, 'a up] => 'a"

defs
  EVAL2_def:	"EVAL2 phi a p ==
                 setsum (%i. phi (coeff p i) * a ^ i) {..deg p}"
  EVAL_def:	"EVAL == EVAL2 (%x. x)"

end
