(*  Title:    HOL/Prolog/HOHH.thy
    ID:       $Id: HOHH.thy,v 1.2 2002/06/11 14:43:18 oheimb Exp $
    Author:   David von Oheimb (based on a lecture on Lambda Prolog by Nadathur)
    License:  GPL (GNU GENERAL PUBLIC LICENSE)

higher-order hereditary Harrop formulas 
*)

HOHH = HOL +

consts

(* D-formulas (programs):  D ::= !x. D | D .. D | D :- G | A		*)
  "Dand"	:: [bool, bool] => bool		(infixr ".." 28)
  ":-"		:: [bool, bool] => bool		(infixl 29)

(* G-formulas (goals):     G ::= A | G & G | G | G | ? x. G 
			       | True | !x. G | D => G			*)
(*","           :: [bool, bool] => bool		(infixr 35)*)
  "=>"		:: [bool, bool] => bool		(infixr 27)

translations

  "D :- G"	=>	"G --> D"
  "D1 .. D2"	=>	"D1 & D2"
(*"G1 , G2"	=>	"G1 & G2"*)
  "D => G"	=>	"D --> G"

end

