/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4dc;
import org.joml.Vector4fc;
import org.joml.Vector4ic;

public class Vector4f
implements Externalizable,
Vector4fc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
        this.w = 1.0f;
    }

    public Vector4f(Vector4fc v) {
        if (v instanceof Vector4f) {
            MemUtil.INSTANCE.copy((Vector4f)v, this);
        } else {
            this.x = v.x();
            this.y = v.y();
            this.z = v.z();
            this.w = v.w();
        }
    }

    public Vector4f(Vector4ic v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = v.w();
    }

    public Vector4f(Vector3fc v, float w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
    }

    public Vector4f(Vector3ic v, float w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
    }

    public Vector4f(Vector2fc v, float z, float w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
    }

    public Vector4f(Vector2ic v, float z, float w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
    }

    public Vector4f(float d) {
        MemUtil.INSTANCE.broadcast(d, this);
    }

    public Vector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4f(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4f(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector4f(FloatBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector4f(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public Vector4f set(Vector4fc v) {
        if (v instanceof Vector4f) {
            MemUtil.INSTANCE.copy((Vector4f)v, this);
        } else {
            this.x = v.x();
            this.y = v.y();
            this.z = v.z();
            this.w = v.w();
        }
        return this;
    }

    public Vector4f set(Vector4ic v) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = v.w();
        return this;
    }

    public Vector4f set(Vector4dc v) {
        this.x = (float)v.x();
        this.y = (float)v.y();
        this.z = (float)v.z();
        this.w = (float)v.w();
        return this;
    }

    public Vector4f set(Vector3fc v, float w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
        return this;
    }

    public Vector4f set(Vector3ic v, float w) {
        this.x = v.x();
        this.y = v.y();
        this.z = v.z();
        this.w = w;
        return this;
    }

    public Vector4f set(Vector2fc v, float z, float w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4f set(Vector2ic v, float z, float w) {
        this.x = v.x();
        this.y = v.y();
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4f set(float d) {
        MemUtil.INSTANCE.broadcast(d, this);
        return this;
    }

    public Vector4f set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Vector4f set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4f set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4f set(FloatBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector4f set(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector4f setComponent(int component, float value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.w = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector4f sub(Vector4fc v) {
        this.x -= v.x();
        this.y -= v.y();
        this.z -= v.z();
        this.w -= v.w();
        return this;
    }

    public Vector4f sub(float x, float y, float z, float w) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        this.w -= w;
        return this;
    }

    public Vector4f sub(Vector4fc v, Vector4f dest) {
        dest.x = this.x - v.x();
        dest.y = this.y - v.y();
        dest.z = this.z - v.z();
        dest.w = this.w - v.w();
        return dest;
    }

    public Vector4f sub(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        dest.w = this.w - w;
        return dest;
    }

    public Vector4f add(Vector4fc v) {
        this.x += v.x();
        this.y += v.y();
        this.z += v.z();
        this.w += v.w();
        return this;
    }

    public Vector4f add(Vector4fc v, Vector4f dest) {
        dest.x = this.x + v.x();
        dest.y = this.y + v.y();
        dest.z = this.z + v.z();
        dest.w = this.w + v.w();
        return dest;
    }

    public Vector4f add(float x, float y, float z, float w) {
        this.x += x;
        this.y += y;
        this.z += z;
        this.w += w;
        return this;
    }

    public Vector4f add(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        dest.w = this.w + w;
        return dest;
    }

    public Vector4f fma(Vector4fc a, Vector4fc b) {
        this.x += a.x() * b.x();
        this.y += a.y() * b.y();
        this.z += a.z() * b.z();
        this.w += a.w() * b.w();
        return this;
    }

    public Vector4f fma(float a, Vector4fc b) {
        this.x += a * b.x();
        this.y += a * b.y();
        this.z += a * b.z();
        this.w += a * b.w();
        return this;
    }

    public Vector4f fma(Vector4fc a, Vector4fc b, Vector4f dest) {
        dest.x = this.x + a.x() * b.x();
        dest.y = this.y + a.y() * b.y();
        dest.z = this.z + a.z() * b.z();
        dest.w = this.w + a.w() * b.w();
        return dest;
    }

    public Vector4f fma(float a, Vector4fc b, Vector4f dest) {
        dest.x = this.x + a * b.x();
        dest.y = this.y + a * b.y();
        dest.z = this.z + a * b.z();
        dest.w = this.w + a * b.w();
        return dest;
    }

    public Vector4f mul(Vector4fc v) {
        this.x *= v.x();
        this.y *= v.y();
        this.z *= v.z();
        this.w *= v.w();
        return this;
    }

    public Vector4f mul(Vector4fc v, Vector4f dest) {
        dest.x = this.x * v.x();
        dest.y = this.y * v.y();
        dest.z = this.z * v.z();
        dest.w = this.w * v.w();
        return dest;
    }

    public Vector4f div(Vector4fc v) {
        this.x /= v.x();
        this.y /= v.y();
        this.z /= v.z();
        this.w /= v.w();
        return this;
    }

    public Vector4f div(Vector4fc v, Vector4f dest) {
        dest.x = this.x / v.x();
        dest.y = this.y / v.y();
        dest.z = this.z / v.z();
        dest.w = this.w / v.w();
        return dest;
    }

    public Vector4f mul(Matrix4fc mat) {
        return this.mul(mat, this);
    }

    public Vector4f mul(Matrix4fc mat, Vector4f dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w, mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33() * this.w);
        return dest;
    }

    public Vector4f mul(Matrix4x3fc mat) {
        return this.mul(mat, this);
    }

    public Vector4f mul(Matrix4x3fc mat, Vector4f dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w, this.w);
        return dest;
    }

    public Vector4f mulProject(Matrix4fc mat, Vector4f dest) {
        float invW = 1.0f / (mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33() * this.w);
        dest.set((mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30() * this.w) * invW, (mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31() * this.w) * invW, (mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32() * this.w) * invW, 1.0f);
        return dest;
    }

    public Vector4f mulProject(Matrix4fc mat) {
        return this.mulProject(mat, this);
    }

    public Vector4f mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }

    public Vector4f mul(float scalar, Vector4f dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        dest.w = this.w * scalar;
        return dest;
    }

    public Vector4f mul(float x, float y, float z, float w) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        this.w *= w;
        return this;
    }

    public Vector4f mul(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        dest.w = this.w * w;
        return dest;
    }

    public Vector4f div(float scalar) {
        float inv = 1.0f / scalar;
        this.x *= inv;
        this.y *= inv;
        this.z *= inv;
        this.w *= inv;
        return this;
    }

    public Vector4f div(float scalar, Vector4f dest) {
        float inv = 1.0f / scalar;
        dest.x = this.x * inv;
        dest.y = this.y * inv;
        dest.z = this.z * inv;
        dest.w = this.w * inv;
        return dest;
    }

    public Vector4f div(float x, float y, float z, float w) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        this.w /= w;
        return this;
    }

    public Vector4f div(float x, float y, float z, float w, Vector4f dest) {
        dest.x = this.x / x;
        dest.y = this.y / y;
        dest.z = this.z / z;
        dest.w = this.w / w;
        return dest;
    }

    public Vector4f rotate(Quaternionfc quat) {
        return this.rotate(quat, this);
    }

    public Vector4f rotate(Quaternionfc quat, Vector4f dest) {
        return quat.transform(this, dest);
    }

    public Vector4f rotateAbout(float angle, float x, float y, float z) {
        return this.rotateAxis(angle, x, y, z, this);
    }

    public Vector4f rotateAxis(float angle, float aX, float aY, float aZ, Vector4f dest) {
        float hangle = angle * 0.5f;
        float sinAngle = (float)Math.sin(hangle);
        float qx = aX * sinAngle;
        float qy = aY * sinAngle;
        float qz = aZ * sinAngle;
        float qw = (float)Math.cosFromSin(sinAngle, hangle);
        float w2 = qw * qw;
        float x2 = qx * qx;
        float y2 = qy * qy;
        float z2 = qz * qz;
        float zw = qz * qw;
        float xy = qx * qy;
        float xz = qx * qz;
        float yw = qy * qw;
        float yz = qy * qz;
        float xw = qx * qw;
        float nx = (w2 + x2 - z2 - y2) * this.x + (-zw + xy - zw + xy) * this.y + (yw + xz + xz + yw) * this.z;
        float ny = (xy + zw + zw + xy) * this.x + (y2 - z2 + w2 - x2) * this.y + (yz + yz - xw - xw) * this.z;
        float nz = (xz - yw + xz - yw) * this.x + (yz + yz + xw + xw) * this.y + (z2 - y2 - x2 + w2) * this.z;
        dest.x = nx;
        dest.y = ny;
        dest.z = nz;
        return dest;
    }

    public Vector4f rotateX(float angle) {
        return this.rotateX(angle, this);
    }

    public Vector4f rotateX(float angle, Vector4f dest) {
        float sin = (float)Math.sin((double)angle * 0.5);
        float cos = (float)Math.cosFromSin(sin, (double)angle * 0.5);
        dest.x = this.x;
        dest.y = this.y * cos - this.z * sin;
        dest.z = this.y * sin + this.z * cos;
        dest.w = this.w;
        return dest;
    }

    public Vector4f rotateY(float angle) {
        return this.rotateY(angle, this);
    }

    public Vector4f rotateY(float angle, Vector4f dest) {
        float sin = (float)Math.sin((double)angle * 0.5);
        float cos = (float)Math.cosFromSin(sin, (double)angle * 0.5);
        dest.x = this.x * cos + this.z * sin;
        dest.y = this.y;
        dest.z = -this.x * sin + this.z * cos;
        dest.w = this.w;
        return dest;
    }

    public Vector4f rotateZ(float angle) {
        return this.rotateZ(angle, this);
    }

    public Vector4f rotateZ(float angle, Vector4f dest) {
        float sin = (float)Math.sin((double)angle * 0.5);
        float cos = (float)Math.cosFromSin(sin, (double)angle * 0.5);
        dest.x = this.x * cos - this.y * sin;
        dest.y = this.x * sin + this.y * cos;
        dest.z = this.z;
        dest.w = this.w;
        return dest;
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public Vector4f normalize() {
        float invLength = 1.0f / this.length();
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        this.w *= invLength;
        return this;
    }

    public Vector4f normalize(Vector4f dest) {
        float invLength = 1.0f / this.length();
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        dest.w = this.w * invLength;
        return dest;
    }

    public Vector4f normalize(float length) {
        float invLength = 1.0f / this.length() * length;
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        this.w *= invLength;
        return this;
    }

    public Vector4f normalize(float length, Vector4f dest) {
        float invLength = 1.0f / this.length() * length;
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        dest.w = this.w * invLength;
        return dest;
    }

    public Vector4f normalize3() {
        float invLength = (float)(1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z));
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        this.w *= invLength;
        return this;
    }

    public float distance(Vector4fc v) {
        float dx = v.x() - this.x;
        float dy = v.y() - this.y;
        float dz = v.z() - this.z;
        float dw = v.w() - this.w;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    public float distance(float x, float y, float z, float w) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        float dw = this.w - w;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    public float dot(Vector4fc v) {
        return this.x * v.x() + this.y * v.y() + this.z * v.z() + this.w * v.w();
    }

    public float dot(float x, float y, float z, float w) {
        return this.x * x + this.y * y + this.z * z + this.w * w;
    }

    public float angleCos(Vector4fc v) {
        double length1Sqared = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        double length2Sqared = v.x() * v.x() + v.y() * v.y() + v.z() * v.z() + v.w() * v.w();
        double dot = this.x * v.x() + this.y * v.y() + this.z * v.z() + this.w * v.w();
        return (float)(dot / Math.sqrt(length1Sqared * length2Sqared));
    }

    public float angle(Vector4fc v) {
        float cos = this.angleCos(v);
        cos = cos < 1.0f ? cos : 1.0f;
        cos = cos > -1.0f ? cos : -1.0f;
        return (float)Math.acos(cos);
    }

    public Vector4f zero() {
        MemUtil.INSTANCE.zero(this);
        return this;
    }

    public Vector4f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4f negate(Vector4f dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        dest.w = -this.w;
        return dest;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + " " + formatter.format(this.w) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
        out.writeFloat(this.w);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
        this.w = in.readFloat();
    }

    public Vector4f min(Vector4fc v) {
        this.x = this.x < v.x() ? this.x : v.x();
        this.y = this.y < v.y() ? this.y : v.y();
        this.z = this.z < v.z() ? this.z : v.z();
        this.w = this.w < v.w() ? this.w : v.w();
        return this;
    }

    public Vector4f max(Vector4fc v) {
        this.x = this.x > v.x() ? this.x : v.x();
        this.y = this.y > v.y() ? this.y : v.y();
        this.z = this.z > v.z() ? this.z : v.z();
        this.w = this.w > v.w() ? this.w : v.w();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.w);
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector4f other = (Vector4f)obj;
        if (Float.floatToIntBits(this.w) != Float.floatToIntBits(other.w)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public Vector4f smoothStep(Vector4fc v, float t, Vector4f dest) {
        float t2 = t * t;
        float t3 = t2 * t;
        dest.x = (this.x + this.x - v.x() - v.x()) * t3 + (3.0f * v.x() - 3.0f * this.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v.y() - v.y()) * t3 + (3.0f * v.y() - 3.0f * this.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v.z() - v.z()) * t3 + (3.0f * v.z() - 3.0f * this.z) * t2 + this.z * t + this.z;
        dest.w = (this.w + this.w - v.w() - v.w()) * t3 + (3.0f * v.w() - 3.0f * this.w) * t2 + this.w * t + this.w;
        return dest;
    }

    public Vector4f hermite(Vector4fc t0, Vector4fc v1, Vector4fc t1, float t, Vector4f dest) {
        float t2 = t * t;
        float t3 = t2 * t;
        dest.x = (this.x + this.x - v1.x() - v1.x() + t1.x() + t0.x()) * t3 + (3.0f * v1.x() - 3.0f * this.x - t0.x() - t0.x() - t1.x()) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v1.y() - v1.y() + t1.y() + t0.y()) * t3 + (3.0f * v1.y() - 3.0f * this.y - t0.y() - t0.y() - t1.y()) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v1.z() - v1.z() + t1.z() + t0.z()) * t3 + (3.0f * v1.z() - 3.0f * this.z - t0.z() - t0.z() - t1.z()) * t2 + this.z * t + this.z;
        dest.w = (this.w + this.w - v1.w() - v1.w() + t1.w() + t0.w()) * t3 + (3.0f * v1.w() - 3.0f * this.w - t0.w() - t0.w() - t1.w()) * t2 + this.w * t + this.w;
        return dest;
    }

    public Vector4f lerp(Vector4fc other, float t) {
        return this.lerp(other, t, this);
    }

    public Vector4f lerp(Vector4fc other, float t, Vector4f dest) {
        dest.x = this.x + (other.x() - this.x) * t;
        dest.y = this.y + (other.y() - this.y) * t;
        dest.z = this.z + (other.z() - this.z) * t;
        dest.w = this.w + (other.w() - this.w) * t;
        return dest;
    }

    public float get(int component) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector4fc toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Vector4fc {
        private final Vector4fc delegate;

        Proxy(Vector4fc delegate) {
            this.delegate = delegate;
        }

        public float x() {
            return this.delegate.x();
        }

        public float y() {
            return this.delegate.y();
        }

        public float z() {
            return this.delegate.z();
        }

        public float w() {
            return this.delegate.w();
        }

        public FloatBuffer get(FloatBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public FloatBuffer get(int index, FloatBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public ByteBuffer get(ByteBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public ByteBuffer get(int index, ByteBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public Vector4f sub(Vector4fc v, Vector4f dest) {
            return this.delegate.sub(v, dest);
        }

        public Vector4f sub(float x, float y, float z, float w, Vector4f dest) {
            return this.delegate.sub(x, y, z, w, dest);
        }

        public Vector4f add(Vector4fc v, Vector4f dest) {
            return this.delegate.add(v, dest);
        }

        public Vector4f add(float x, float y, float z, float w, Vector4f dest) {
            return this.delegate.add(x, y, z, w, dest);
        }

        public Vector4f fma(Vector4fc a, Vector4fc b, Vector4f dest) {
            return this.delegate.fma(a, b, dest);
        }

        public Vector4f fma(float a, Vector4fc b, Vector4f dest) {
            return this.delegate.fma(a, b, dest);
        }

        public Vector4f mul(Vector4fc v, Vector4f dest) {
            return this.delegate.mul(v, dest);
        }

        public Vector4f div(Vector4fc v, Vector4f dest) {
            return this.delegate.div(v, dest);
        }

        public Vector4f mul(Matrix4fc mat, Vector4f dest) {
            return this.delegate.mul(mat, dest);
        }

        public Vector4f mul(Matrix4x3fc mat, Vector4f dest) {
            return this.delegate.mul(mat, dest);
        }

        public Vector4f mulProject(Matrix4fc mat, Vector4f dest) {
            return this.delegate.mulProject(mat, dest);
        }

        public Vector4f mul(float scalar, Vector4f dest) {
            return this.delegate.mul(scalar, dest);
        }

        public Vector4f mul(float x, float y, float z, float w, Vector4f dest) {
            return this.delegate.mul(x, y, z, w, dest);
        }

        public Vector4f div(float scalar, Vector4f dest) {
            return this.delegate.div(scalar, dest);
        }

        public Vector4f div(float x, float y, float z, float w, Vector4f dest) {
            return this.delegate.div(x, y, z, w, dest);
        }

        public Vector4f rotate(Quaternionfc quat, Vector4f dest) {
            return this.delegate.rotate(quat, dest);
        }

        public Vector4f rotateAxis(float angle, float x, float y, float z, Vector4f dest) {
            return this.delegate.rotateAxis(angle, x, y, z, dest);
        }

        public Vector4f rotateX(float angle, Vector4f dest) {
            return this.delegate.rotateX(angle, dest);
        }

        public Vector4f rotateY(float angle, Vector4f dest) {
            return this.delegate.rotateY(angle, dest);
        }

        public Vector4f rotateZ(float angle, Vector4f dest) {
            return this.delegate.rotateZ(angle, dest);
        }

        public float lengthSquared() {
            return this.delegate.lengthSquared();
        }

        public float length() {
            return this.delegate.length();
        }

        public Vector4f normalize(Vector4f dest) {
            return this.delegate.normalize(dest);
        }

        public Vector4f normalize(float length, Vector4f dest) {
            return this.delegate.normalize(length, dest);
        }

        public float distance(Vector4fc v) {
            return this.delegate.distance(v);
        }

        public float distance(float x, float y, float z, float w) {
            return this.delegate.distance(x, y, z, w);
        }

        public float dot(Vector4fc v) {
            return this.delegate.dot(v);
        }

        public float dot(float x, float y, float z, float w) {
            return this.delegate.dot(x, y, z, w);
        }

        public float angleCos(Vector4fc v) {
            return this.delegate.angleCos(v);
        }

        public float angle(Vector4fc v) {
            return this.delegate.angle(v);
        }

        public Vector4f negate(Vector4f dest) {
            return this.delegate.negate(dest);
        }

        public Vector4f lerp(Vector4fc other, float t, Vector4f dest) {
            return this.delegate.lerp(other, t, dest);
        }

        public Vector4f smoothStep(Vector4fc v, float t, Vector4f dest) {
            return this.delegate.smoothStep(v, t, dest);
        }

        public Vector4f hermite(Vector4fc t0, Vector4fc v1, Vector4fc t1, float t, Vector4f dest) {
            return this.delegate.hermite(t0, v1, t1, t, dest);
        }

        public float get(int component) throws IllegalArgumentException {
            return this.delegate.get(component);
        }
    }
}

