// Supervision1.cpp 
//

#include <opencv2/opencv.hpp>
#ifdef _DEBUG
#pragma comment(lib, "opencv_world340d.lib")
#else
#pragma comment(lib, "opencv_world340.lib")
#endif

#define _USE_MATH_DEFINES
#include <math.h>
#include <iostream>


// helper method to produce a concatenated image for visualisation
// @param images: vector of images to concatenate. These should all have the same size!
// @param maximumColumnCount: maximum number of columns before starting a new row. Leave as default (-1) to always have a single row
cv::Mat concatenateImages(std::vector<cv::Mat> images, int maximumColumnCount = -1)
{
	// cache size
	int width = images[0].size().width;
	int height = images[0].size().height;

	// figure out rows
	int colCount = static_cast<int>(images.size());
	if (maximumColumnCount > 0)
	{
		colCount = std::min(colCount, maximumColumnCount);
	}
	int rowCount = (int)std::ceil(images.size() * 1. / colCount);

	// create target
	cv::Mat result = cv::Mat(height * rowCount, width * colCount, images[0].type());

	// copy images onto the target
	for (int i = 0; i < images.size(); i++)
	{
		int col = i % colCount;
		int row = i / colCount;
		images[i].copyTo(result(cv::Rect(col * width, row * height, width, height)));
	}

	return result;
}


int main()
{
	//----------------------------------------------------------------------------------------------------------
	// Initial loading. Feel free to read, but please do not change
	//
	cv::Mat loadedImage = cv::imread("images/LukeTLJ.png", cv::IMREAD_GRAYSCALE);
	if (loadedImage.empty())
	{
		throw std::runtime_error("Failed to load Source image");
		return 1;
	}

	// convert to floats
	cv::Mat srcImage;
	loadedImage.convertTo(srcImage, CV_32F, 1 / 255.f);

	// display Source image
	cv::namedWindow("Source Image", cv::WINDOW_AUTOSIZE);
	cv::imshow("Source Image", srcImage);


	//----------------------------------------------------------------------------------------------------------
	// Exercise 1.
	// Finite difference operators for detecting edges
	//
	// Based on slides 65-67, implement a gradient magitude edge detector
	//
	// For the differentiation kernel we use [-1, 1]
	cv::Mat image1 = cv::Mat::zeros(srcImage.size(), srcImage.type());

	// setting up the kernel
	float kernelValues[] = { -1, +1};
	cv::Mat kernel = cv::Mat(cv::Size(1, 2), CV_32F, kernelValues);

	// finding the derivatives;
	cv::Mat dfdx = cv::Mat::zeros(srcImage.size(), srcImage.type());
	cv::Mat dfdy = cv::Mat::zeros(srcImage.size(), srcImage.type());


	// TODO: use cv::filter2D(src, dest, -1, kernel) to convolve srcImage with kernel and kernel.t() (transpose)
	// TODO: this should give you dfdx and dfdy respectively



	// finding the magnitude

	// TODO: compute the magnitude of (dfdx,dfdy) and store it in image1.
	// TODO: there are a number of opencv function you could use here 
	// * one option is to use the Mat class's built-in addition and multiplication
	//  e.g. for Mat a,b,c;   c = a.mul(a).mul(a) + b; is the same as a^3+b (element-wise)
	//  cv::sqrt
	//
	// * alternatively look at cv::magnitude(., ., .);


	cv::namedWindow("Expercise 1", cv::WINDOW_AUTOSIZE); 
	std::vector<cv::Mat> allImages = { dfdx, dfdy, image1 };
	cv::imshow("Expercise 1", concatenateImages(allImages));


	//----------------------------------------------------------------------------------------------------------
	// Exercise 2.
	// Edge detection at different scales
	//
	// We will use a combination of Laplacian (isotropic edge detection) and Gaussians at different scales
	// to find edges of different scales
	std::vector<cv::Mat> images2(6);

	// TODO: update the values to correspond to the Laplacian on slide 70
	float laplacianValues[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};


	cv::Mat laplacian = cv::Mat(cv::Size(3, 3), CV_32F, laplacianValues);
	cv::copyMakeBorder(laplacian, laplacian, 10, 10, 10, 10, cv::BORDER_CONSTANT);

	// for each level
	for (int i = 0; i < images2.size(); i++)
	{
		images2[i] = cv::Mat(srcImage.size(), CV_32F);
		float sigma = 0.01f + i * 0.3f;


		// TODO: apply the laplacian and the Gaussian to the image
		//       for Gaussina blur, you might want to use cv::GaussianBlur(src, dst, cv::Size(0, 0), sigma);
		//       you can apply the laplacian kernel using cv::filter2D as previously
		//		 remember that you can apply the laplacian and the Gaussian in any order.
		//       start easy (e.g. first apply laplacian, then blur), then try to use the preferred implementation from slide 75


	}


	cv::namedWindow("Expercise 2", cv::WINDOW_AUTOSIZE);
	cv::imshow("Expercise 2", concatenateImages(images2, 3));

	//----------------------------------------------------------------------------------------------------------
	// Exercise 3.
	// Edge detection using Canny
	//
	cv::Mat image3 = cv::Mat(srcImage.size(), CV_32F);

	// convert to U8C1 for canny
	cv::Mat srcImageU8 = srcImage * 255;
	srcImageU8.convertTo(srcImageU8, CV_8UC1);


	// TODO: use cv::Canny on the U8C1 source image. Experiment with the parameters (.,.,100, 200) might be a good starting point 


	cv::namedWindow("Expercise 3", cv::WINDOW_AUTOSIZE);
	cv::imshow("Expercise 3", image3);


	//----------------------------------------------------------------------------------------------------------
	// Exercise 4.
	// Gabor wavelets
	//
	float lambda = 10.f; // TODO: when you are done, come back to these values and see if you can tweak them
	float sigma = lambda * 0.6f;
	cv::Mat gaborReal = cv::getGaborKernel(srcImage.size(), sigma, /*theta*/ M_PI / 2 - 0.13, lambda, /*ratio */ 0.4, M_PI / 2, CV_32F);
	cv::Mat gaborImag = cv::getGaborKernel(srcImage.size(), sigma, /*theta*/ M_PI / 2 - 0.13, lambda, /*ratio */ 0.4, 0, CV_32F);

	cv::Mat g1 = cv::Mat(srcImage.size(), CV_32F);
	cv::Mat g2 = cv::Mat(srcImage.size(), CV_32F);
	cv::Mat magnitude = cv::Mat(srcImage.size(), CV_32F);


	// TODO: apply the real and the imaginary gabor filters to get g1 and g2 respectively


	// some normalisation
	g1 = 5.f * g1 / lambda / lambda;
	g2 = 5.f * g2 / lambda / lambda;


	// TODO: compute the magnitude of (g1,g2) using cv::magnitude or otherwise
	

	cv::namedWindow("Expercise 4", cv::WINDOW_AUTOSIZE);
	allImages = { 0.5f + 0.5f * gaborReal(cv::Rect(0, 0, srcImage.size().width, srcImage.size().height)),
												0.5f + 0.5f * gaborImag(cv::Rect(0, 0, srcImage.size().width, srcImage.size().height)),
												0.5f + 0.5f * g1, 0.5f + 0.5f * g2, magnitude };
	cv::imshow("Expercise 4", concatenateImages(allImages));

	///////// FINISHED
	cv::waitKey(0); // Wait for a keystroke in the window
	return 0;
}
