//
//  Hardware ML processor core and testbench.
//  (C) 2012 DJ Greaves, M Myrene, University of Cambridge Computer Laboratory.
//


`define EOF 32'hFFFF_FFFF
`define NULL 0
`define MAX_LINE_LENGTH 1000




module SIMSYS();
   reg clk, reset;
   wire failed;
   
   initial begin 
      $dumpfile("decoder.vcd");
      $dumpvars(0, dut);
      reset = 1; 
      clk = 0; 
      # 42 reset = 0; 
   end

   always begin
       #5 clk = !clk;
       if (failed) begin
	  $display("Finished/failed.");
	  $finish;
       end
   end

   wire uart_rxav, _uart_txav;
   wire uart_read, uart_write;	// Data transfer qualifiers 
   wire [7:0] uart_parin8, uart_parout8;

   reg c_mem_ack;  wire [1:0] c_mem_cmd;  wire [31:0] c_mem_adr; wire[7:0] c_mem_wdata, c_mem_rdata;
   
   wire [7:0] dil8_sw_data = 8'd11;
   wire [7:0] leds8;
   wire [31:0] logging = 4;
   
   CORE0_TOP dut(.clk(clk), .reset(reset), .failed(failed), .leds8(leds8), .dil8_sw_data(dil8_sw_data),
    .c_mem_adr(c_mem_adr), .c_mem_wdata(c_mem_wdata), .c_mem_rdata(c_mem_rdata), .c_mem_cmd(c_mem_cmd), .c_mem_ack(c_mem_ack),
    .uart_rxav(uart_rxav), .uart_txav(uart_txav), .uart_write(uart_write), .uart_read(uart_read),  .uart_parin8(uart_parin8), .uart_parout8(uart_parout8), .logging(logging)  

    );

       // Code memory
  always @(posedge clk) begin
     c_mem_ack <= c_mem_cmd != 0 && !reset;
     end
   SRAM8 codemem(.clk(clk), .adr(c_mem_adr[15:0]), .wdata(c_mem_wdata), .rdata(c_mem_rdata), .cmd(c_mem_cmd));

   
   initial # 1000000 $finish();
endmodule


