

module SRAM32( // Synchronous static RAM model.
  input clk,
 input logging,
 input [31:0] wdata,
  output reg [31:0] rdata,
  input [15:0] adr,
  input [1:0] cmd);

  reg [31:0] data [0:65535];

  always @(posedge clk) begin
     if (cmd == `M_read) rdata <= data[adr];
     else begin
	if (cmd == `M_write) data[adr] <= wdata;
	rdata <= 32'bx;
	end
     if (logging) begin
	if (cmd == `M_write) $display("%m Write [%h] := %h", adr, wdata);
	if (cmd == `M_read) $display("%m Read [%h] -> %h", adr, data[adr]);
     end
     end
  

endmodule

module SRAM8( // Synchronous static RAM model.
  input clk,
  input [7:0] wdata,
  output reg [7:0] rdata,
  input [15:0] adr,
  input [1:0] cmd);

  reg [7:0] data [0:65535];

  always @(posedge clk) begin
     if (cmd == `M_read) rdata <= data[adr];
     else begin
	if (cmd == `M_write) data[adr] <= wdata;
	rdata <= 8'bx;
	end
  end
   
  integer infile;
  //  reg [256*8-1:0] instring;
  integer c;


  initial begin // This is Magnus' fibonacci program - 4a should result in fib(10) = 55 = 0x37. 
  data[0] =   8'h4a;
  data[1] =   8'h44;
  data[2] =   8'h12;
  data[3] =   8'h00;
  data[4] =   8'h0c;
  data[5] =   8'h40;
  data[6] =   8'h02;
  data[7] =   8'h41;
  data[8] =   8'h0c;
  data[9] =   8'h09;
  data[10] =   8'h4e;
  data[11] =   8'h11;
  data[12] =   8'h0c;
  data[13] =   8'h10;
  data[14] =   8'h41;
  data[15] =   8'h0b;
  data[16] =   8'h40;
  data[17] =   8'h02;
  data[18] =   8'h41;
  data[19] =   8'h0b;
  data[20] =   8'h44;
  data[21] =   8'h12;
  data[22] =   8'h0c;
  data[23] =   8'h44;
  data[24] =   8'h12;
  data[25] =   8'h0a;
  data[26] =   8'h0c;
  data[27] =   8'h10;
  data[28] =   8'h00;
  end


//  initial if (0) begin
//      infile = $fopen("test.bin", "r");
//      if (infile == `NULL) $display("Cannot open input file");
//      else
//      while (!$feof(infile)) begin
//	$fgets(file, instring, 256);
//	c = $fgetc(infile);
//	while (c != EOF) begin
//  	    $scanf(instring); 
//        end
//       end

//
//
//
endmodule

