//
//  Hardware ML processor core and testbench.
//  (C) 2013 DJ Greaves, M Myrene, University of Cambridge Computer Laboratory.
//


`define EOF 32'hFFFF_FFFF
`define NULL 0
`define MAX_LINE_LENGTH 1000

`include "../rtlcore0/memcmds.v"

module SIMSYS();
   reg clk, reset;
   wire failed;
   
   initial begin 
      $dumpfile("decoder.vcd");
      $dumpvars;
      reset = 1; 
      clk = 1; 
      # 42 reset = 0; 
   end

   always begin
       #5 clk = !clk;
       if (failed) begin
	  $display("Finished/failed.");
	  $finish;
       end
   end

   wire uart_rxav, _uart_txav;
   wire uart_read, uart_write;	// Data transfer qualifiers 
   wire [7:0] uart_parin8, uart_parout8;

   reg c_mem_ack;  wire [1:0] c_mem_cmd;  wire [15:0] c_mem_adr; wire[7:0] c_mem_wdata, c_mem_rdata;
   reg s_mem_ack;  wire [1:0] s_mem_cmd;  wire [15:0] s_mem_adr; wire[31:0] s_mem_wdata, s_mem_rdata;
   reg h_mem_ack;  wire [1:0] h_mem_cmd;  wire [15:0] h_mem_adr; wire[31:0] h_mem_wdata, h_mem_rdata;   
   
   wire [7:0] dil8_sw_data = 8'd11;
   wire [7:0] leds8;
   wire [31:0] logging = 4;


   wire [25:0] c_mem_portA_request_put_value;
   wire        c_mem_portA_request_put_RDY = !c_mem_ack;
   wire        c_mem_portA_request_put_EN;
   wire [7:0]  c_mem_portA_response_get_RV = c_mem_rdata;
   wire        c_mem_portA_response_get_RDY = c_mem_ack;
   wire        c_mem_portA_response_get_EN;

   assign c_mem_wdata = c_mem_portA_request_put_value[7:0];
   assign c_mem_adr   = c_mem_portA_request_put_value[23:8];
   assign c_mem_cmd   = c_mem_portA_request_put_EN ? (c_mem_portA_request_put_value[25] ?`M_write:`M_read) : `M_idle;


   wire [49:0] s_mem_portA_request_put_value;
   wire        s_mem_portA_request_put_RDY = !s_mem_ack;
   wire        s_mem_portA_request_put_EN;
   wire [31:0] s_mem_portA_response_get_RV = s_mem_rdata;
   wire        s_mem_portA_response_get_RDY = s_mem_ack;
   wire        s_mem_portA_response_get_EN;

   assign s_mem_wdata = s_mem_portA_request_put_value[31:0];
   assign s_mem_adr   = s_mem_portA_request_put_value[47:32];
   assign s_mem_cmd   = s_mem_portA_request_put_EN ? (s_mem_portA_request_put_value[49] ?`M_write:`M_read) : `M_idle;
   assign s_mem_wrresp= s_mem_portA_request_put_value[48];

   wire [49:0] h_mem_portA_request_put_value;
   wire        h_mem_portA_request_put_RDY = !h_mem_ack;
   wire        h_mem_portA_request_put_EN;
   wire [31:0] h_mem_portA_response_get_RV = h_mem_rdata;
   wire        h_mem_portA_response_get_RDY = h_mem_ack;
   wire        h_mem_portA_response_get_EN;

   assign h_mem_wdata = h_mem_portA_request_put_value[31:0];
   assign h_mem_adr   = h_mem_portA_request_put_value[47:32];
   assign h_mem_cmd   = h_mem_portA_request_put_EN ? (h_mem_portA_request_put_value[49] ?`M_write:`M_read) : `M_idle;

    wire [7:0] io_mem_output_data;
    wire [7:0] io_mem_output_addr;
    wire io_mem_output_RDY;
    wire io_mem_output_EN;
    wire [7:0] io_mem_input_response_get_RV;
    wire io_mem_input_response_get_RDY;
    wire io_mem_input_response_get_EN;
    wire [7:0] io_mem_input_req_addr;
    wire io_mem_input_req_RDY;
    wire io_mem_input_req_EN;
   
   hwmlcore dut(
		// .failed(failed), .leds8(leds8), .dil8_sw_data(dil8_sw_data),

    .c_mem_portA_response_get_RDY(c_mem_portA_response_get_RDY),     .c_mem_portA_response_get_EN(c_mem_portA_response_get_EN),   .c_mem_portA_response_get_RV(c_mem_portA_response_get_RV), 
    .c_mem_portA_request_put_EN(c_mem_portA_request_put_EN), .c_mem_portA_request_put_RDY(c_mem_portA_request_put_RDY), .c_mem_portA_request_put_value(c_mem_portA_request_put_value), 		


    .s_mem_portA_response_get_RDY(s_mem_portA_response_get_RDY),     .s_mem_portA_response_get_EN(s_mem_portA_response_get_EN),   .s_mem_portA_response_get_RV(s_mem_portA_response_get_RV), 

    .s_mem_portA_request_put_EN(s_mem_portA_request_put_EN), .s_mem_portA_request_put_RDY(s_mem_portA_request_put_RDY), .s_mem_portA_request_put_value(s_mem_portA_request_put_value), 		


    .h_mem_portA_response_get_RDY(h_mem_portA_response_get_RDY),     .h_mem_portA_response_get_EN(h_mem_portA_response_get_EN),   .h_mem_portA_response_get_RV(h_mem_portA_response_get_RV), 
    .h_mem_portA_request_put_EN(h_mem_portA_request_put_EN), .h_mem_portA_request_put_RDY(h_mem_portA_request_put_RDY), .h_mem_portA_request_put_value(h_mem_portA_request_put_value), 		

  .io_mem_output_data(io_mem_output_data),
  .io_mem_output_addr(io_mem_output_addr),
  .io_mem_output_RDY(io_mem_output_RDY),
  .io_mem_output_EN(io_mem_output_EN),
  .io_mem_input_response_get_RV(io_mem_input_response_get_RV),
  .io_mem_input_response_get_RDY(io_mem_input_response_get_RDY),
  .io_mem_input_response_get_EN(io_mem_input_response_get_EN),
  .io_mem_input_req_addr(io_mem_input_req_addr),
  .io_mem_input_req_RDY(io_mem_input_req_RDY),
  .io_mem_input_req_EN(io_mem_input_req_EN),

  .CLK(clk), .RST_N(!reset) 
    );

  // I/O Subsystem
   assign io_mem_input_req_RDY = 1;
   assign io_mem_input_response_RDY = 1; // Zero really!
   assign io_mem_output_RDY = 1;   
   
  // Code memory
  always @(posedge clk) begin
     c_mem_ack <= reset ? 0: c_mem_cmd != 0;
     end
   SRAM8 c_mem(.clk(clk), .adr(c_mem_adr[15:0]), .wdata(c_mem_wdata), .rdata(c_mem_rdata), .cmd(c_mem_cmd));


  // Stack memory
  always @(posedge clk) begin
     if (reset) s_mem_ack <= 0;
     else if (s_mem_cmd == `M_read) s_mem_ack <= 1;
     else if (s_mem_cmd == `M_write && s_mem_wrresp) s_mem_ack <= 1;     
     else if (s_mem_portA_response_get_EN) s_mem_ack <= 0;
     end
   SRAM32 s_mem(.clk(clk), .adr(s_mem_adr[15:0]), .wdata(s_mem_wdata), .rdata(s_mem_rdata), .cmd(s_mem_cmd));

  // Heap memory
  always @(posedge clk) begin
     h_mem_ack <= reset ? 0: h_mem_cmd != 0;     
     end
   SRAM32 h_mem(.clk(clk), .adr(h_mem_adr[15:0]), .wdata(h_mem_wdata), .rdata(h_mem_rdata), .cmd(h_mem_cmd));

   
   initial # 100000 $finish();
endmodule


