/* cbg closure c parser.c */

/* cbgc closure c compiler 4th January 1992 
 *
 * ANSI -Wall version.
 *
 * (C) 1995 Tenison Technology
 * DJ Greaves
 * Tenison Technology
 * 10 Tenison Road
 * Cambridge CB1 2DW
 */

#define TRC(X) 
#include <stdio.h>
#include <stdlib.h>
#include "ccchdr.h"

#define uchar unsigned char

#define SVOID (-1)

/* Prototypes */
PT *parse_command();
void newtag(STRUCT *st, char *name, INSTANCE *it, int offset, int partial);
STRUCT *newstruct(char *name);
STRUCT *enumdef();
STRUCT *findstruct(char *name);
PT *parse_formals();
TYPE *typelookup (char *name);
void doatypedef();
void starname(CT *, int, int);
STRUCT *structdef(uchar unionp);
void declaration(int automatic);
PT *parse_block();
void compile_block(PT *p);
void compile_switch();
ENODE *parse_expr();
ENODE *parse_expr9();          
ENODE *parse_expr8();          
ENODE *parse_expr7();          
ENODE *parse_expr6();          
ENODE *parse_expr5();          
ENODE *parse_expr4();     
ENODE *parse_expr3();          
ENODE *parse_expr35(); 
ENODE *parse_expr2();          
ENODE *parse_expr1();   
ENODE *parse_expry();   
ENODE *parse_expr0(); 

STRUCT * structures;
char *current_routine = "none";
char *anon_name = "__anon_struct";

CHRIST * genv;
TYPE *typelist;   


void nexttoks()
{
      printf("next tokens ");
      nextsymb(); printf("%s ", lextok(symb));
      nextsymb(); printf("%s ", lextok(symb));
      nextsymb(); printf("%s ", lextok(symb));
      printf(" ...\n");
}


CONS *reverse(CONS *l, CONS *c)
{
  if (l == NULL) return c;
  return reverse(l->cdr, cons(l->car, c));
}



CONS *cons(CAR_T a, CONS *b)
{
  CONS *r = NEWZ(CONS);
  r->car = a;
  r->cdr = b;
  return r;
}


CONS *cons_with_n(CAR_T a, CONS *b, int n)
{
  CONS *r = NEWZ(CONS);
  r->car = a;
  r->cdr = b;
  r->n = n;
  return r;
}

/* PARSER */

/*
 * Level one of source file parse.
 */


INSTANCE *copyit(INSTANCE *orig)
{
  INSTANCE *r = NEWZ(INSTANCE);
  if (orig)  memcpy(r, orig, sizeof(INSTANCE));
  return r;
}

void startlev1()
{
  flowing = 0;
  declaration(0);
}


/*
 *
 */
int parse_modifiers()
{
  int r = 0;
  while (1)
    {
      int f = 0;
      switch(symb)
	{
	case s_const: f = m_const; break;
	case s_extern: f = m_extern; break;
	case s_unsigned: f = m_unsigned; break;
	case s_signed: f = m_signed; break;
	case s_volatile: f = m_volatile; break;
	case s_static: f = m_static; break;
	case s_register: f = m_register; break;
	default: return r;
	}
      r |= f;
      nextsymb();
    }
}


/*
 *
 */
void declaration(int automatic)
{
  int flagvec = 0;
  while (1) 
    {
      flagvec |= parse_modifiers();
      switch(symb)
	{
 
	default: error("Declaration expected instead of %s", lextok(symb));
	  while (symb != s_semicolon && symb != s_eof) nextsymb();
	case s_semicolon:
	  nextsymb();
	case s_eof:
	  return;
	  
	case s_double:
	  error("warning: using doubles");
	  
	case s_union:
	case s_enum:
	case s_struct:
	case s_unsigned:
	case s_signed:
	case s_int: case s_bit:
	case s_char: case s_short: case s_void: case s_long:
	  {
	    int star0 = 0;
	    CT *ct = ct_insize(&flagvec, &star0);
	    starname(ct, flagvec, star0);
	  }

	  return;
	  
	case s_typedef:
	  nextsymb();
	  flagvec |= parse_modifiers();
	  doatypedef(flagvec);
	  return;
	  
	case s_newid:  /* stars in the typedef are not handled here ? */
	  {
	    CT *ct;
	    int star0 = 0;
	    if (typelookup(wordnode)) ct = ct_insize(&flagvec, &star0);
	    else 
	      {
		ct = NEWZ(CT);
		ct = ct_int; /* default to integer */
	  
		}
	    starname(ct, flagvec, star0);
	    return;
	  }

#if 0	  
	case s_const:
	  lct = ct_int;
	  while(1)
	    {
	      int staries = 0;
	      CT *so;
	      nextsymb();
	      so = ct_insize(&flagvec, &staries);
	      
	      if (so) lct = so;
	      while(symb == s_star)
		{
		  staries++;
		  nextsymb();
		}
	      if (symb != s_newid) error("new id expected for constant");
	      else
		{ 
		  char * lwn = wordnode;
		  nextsymb();
		  if (symb == s_lsquare)
		    {
		      nextsymb(); /* J HACK */
		      checkfor(s_rsquare);
		    }
		  
		  checkfor(s_equals);
		  christen(lwn, num_rval, lct, staries, evalmanifeste(parse_expr()), 0);
		}
	      if (symb != s_comma) break;
	    }
	  return;
#endif

	} /* switch and while */
    }
}


/*
 *
 */
CHRIST *christen(char *name, int path, INSTANCE *it, int value, int maskallowed) 
{ 
  CHRIST *p;

#if 0
  printf("; Christen of %s path=%i value=%i ptr=%p stars=%i\n", name, path, value, it, it->stars1);
#endif
  p = clookup(name, genv);
  if (p && maskallowed == 0)
    {
      if (p->it->ct && p->it->ct->st != it->ct->st) error("type changed for %s", name);
      if(p->it->stars1  + p->it->dimensions != it->stars1 + it->dimensions)
	{
	  printf("%i %i %i %i %i\n", p->it->stars1, p->it->stars2, p->it->dimensions, it->stars1, it->stars2);
	  error("number of stars changed for %s", name);
	}
    }
  else
    {
      p = NEWZ(CHRIST);
      p->cname = name;
      p->cpath = path;
      p->it = it;
      p->idx = value;
      p->cnext = genv;
      genv = p;
    }
  return p;
}

CHRIST *clookup(char *name, CHRIST *env)
{ 
  while(env)
    { if (env->cname == name) return env;
    env = env-> cnext;
    }
  return NULL;
}


void checkfor(unsigned char c)
{
  if (c == symb)
    {
      nextsymb();
    }
  else
    {
      error("Syntax error '%c' expected in place of '%c'.", lextok(c), lextok(symb));
      nexttoks();
    }
}

/* Code to lookup a user defined type */
TYPE * typelookup (char *name)
{
  struct type * r = typelist;
  while (r)
  {
    if (r->name == name) return r;
    r = r->tnext;
  }
  return NULL;
}


/* >>ct_insize */
CT *ct_insize(int *fvp, int *star0p)  
{
  CT *r = NEWZ(CT);
  int s = 0;
  int instars = 0;  /* Zero the intrinsic stars result */
  while(1)
  {
    uchar x = symb;
  
    if (x == s_int)      { nextsymb(); s = target_int_size; }
    if (x == s_long)      { nextsymb(); s = target_int_size; }
    if (x == s_short)    { nextsymb(); s = 2; }
    if (x == s_char)     { nextsymb(); s = 1; }
    if (x == s_void)     { nextsymb(); return ct_void; }

    if (s)
      {
        r->ctsize = s;
	return r;
      }
  

    else if (x == s_newid)   /* Check for a used typedef type */
    {
      struct type *p = typelookup(wordnode);
      if (p)
      {
	*fvp |= p->flags;
	*star0p += p->stars;
        instars = p->stars;
        nextsymb();
        return p->ct;
      }
    }
    
    else if (x == s_struct || x == s_union)
    {
      STRUCT *st;
      nextsymb();
      st = structdef(x);
      r->ctsize = st->totalsize;
      r->st = st;
      return r;
    }
    
    else if (x == s_enum)
    {
      STRUCT *st;
      nextsymb();
      st = enumdef();
      r->ctsize = target_int_size;
      r->st = st;
      return r;
    }
    break;
  }

  
 
  return NULL; /* Not a valid type (prev -2) */  
}


void typedefine(CT *ct, int stars, int flags, char *name)
{
  struct type *r = typelookup(name);
  if (r) error("type %s redefined", name);
  else
  {
    r = NEWZ(struct type);
    r-> name = name;
    r->ct = ct;
    r->flags = flags;
    r->stars = stars;
    r->tnext = typelist;
    typelist = r;
   
  }
}

/*
 * Scan to see if an expression contains a
 * subroutine call
 */
int find_callees1(ENODE *e)
{
  extern void log_callee();
  if (e == NULL) return 0;

 else switch(e->key)
    {
    default :
      fatal("Bad thing in findcall %i\n", e->key);
      
    case e_cmd:
      if (find_callees1(e->exp)) return 1;
      return find_callees1(e->exp1);

      return 1;

    
    case e_query:
      if (find_callees1(e->exp)) return 1;
      if (find_callees1(e->exp1)) return 1;
      return find_callees1(e->exp2);

    case e_string:
    case e_number:
    case e_id:
      return 0;

      /* mondadics */
    case e_post_plusplus:
    case e_post_minusminus:
    case e_cast:
    case e_stars:                /* monadic star operator */
    case e_pling:             /* monadic logical negation */
    case e_abs:             /* absolute value function */
    case e_tilda:             /* monadic ones complement */
    case e_pre_plusplus:              /* prefix ++ and -- operators */
    case e_pre_minusminus:
    case e_addressof:  
      return find_callees1(e->exp);
      

      
      /* diadics */

    case e_logand:
    case e_logor:
    case e_lshift:
    case e_rshift:
    case e_bitor:
    case e_eor:
    case e_bitand:
    case e_multiply:
    case e_divide:
    case e_remainder:
    case e_add:
    case e_subtract:
    case e_comparisonip:
    case e_assign:      /* assignment operators  */
      if (find_callees1(e->exp)) return 1;
      return find_callees1(e->exp1);
    

      
      /*Function call in expression  */
    case e_call:
      log_callee(e);
      return 1;
      
    case e_dot:                    /* Dot structure access */
    case e_arrow:                  /* C Pling operator -> */
      return find_callees1(e->exp);
    }    
  return 0;
}


/*;===
//; DEFINE A ROUTINE/FUNCTION
//; On entry, symb must be lparen and wordnode the name.
//; Enter name in symbol table (should have same type as used by default
//; in eval for forward references).
*/
void definition(INSTANCE *it)
{
  PT * formals;
  char * routinename = wordnode;
  CHRIST * oldgenv;
  current_routine = wordnode;
  
 

  christen(wordnode, sim_rval, it, 0, 0);
  if ((it->flagvec & m_extern))
  { 
    text_mkglobext2(it->flagvec, routinename);
    while(symb != s_rparen) nextsymb(); /* skip prams */
    nextsymb();
    return;
  }
  flowing = 1;
  oldgenv = genv;  /* limit scope of local variables */

  checkfor(s_lparen);
  formals = parse_formals();
  

  if (symb == s_lsect)  /* actually defined here, then log it */
  {
    ROUTINE *r = NEWZ(ROUTINE);
    nextsymb();
  
    r->name = routinename;
    r->body = parse_block();
    r->formals = formals;
    r->next = routines;
    r->it = it;
    routines = r;
  }
  else genv = oldgenv;
}




void fptypes1(CT *ct, int flagvec, int star0)
{
  while(1)
  { 
    char * name;
    CHRIST * p;
    INSTANCE *ins = parse_instance(1, flagvec, ct, star0);
    name = ins->wnode;

    p = clookup(name, genv);
    if ((p==NULL) || (p->cpath != sim_local_reg && p->cpath != sim_local_reg))
    { 
      error("local variable name expected");
      return;
    }
    p->it = ins;
    if (symb == s_semicolon) break;
    checkfor(s_comma);
  }
  nextsymb();
}


void fptypes()   // parse types of formal parameters in pre-ansi style
{
  while(1)
  {
    int fv;
    int star0 = 0;
    CT *ct = ct_insize(&fv, &star0);
    if (ct == NULL) return;
    fptypes1(ct, 0, star0);
  }
}


STRUCT *enumdef()
{
  STRUCT *r = NEWZ(STRUCT);
  INSTANCE *ins = NEWZ(INSTANCE);
  CT *ct = NEWZ(CT);
  int eval = 0;
  ins->ct = ct;
  ct->st = r;
  checkfor(s_lsect);
  while (symb != s_rsect)
  {
    if (symb == s_newid)
      {
	int rval;
	char *w = wordnode;
	nextsymb();
	if (symb == s_equals)
	  {
	    nextsymb();
	    rval = evalmanifeste(parse_expr());
	  }
	else rval = eval++;
	christen(w, sim_enum, ins, rval, 0);   
      }
    else if (symb == s_comma) nextsymb();
    else 
    {
      error("Syntax error in enumeration definition (symb=%s)", lextok(symb));
      nextsymb();
    }
  }
  checkfor(s_rsect);
 
  return r;
}

STRUCT *structdef(uchar unionp) /* symb is name on entry */
{
  char *name = wordnode;
  int tagoffset = 0;
  int totalsize = 0;
  STRUCT * current;

  /* allow anon structures */
  if (symb != s_newid) name = anon_name; else nextsymb();

  if (symb != s_lsect)
   {
     current = findstruct(name);
     if (current == NULL && snesting == 0)
      { error("undefined struct/union name %s", name);
        return 0;
      }
     return current;
   }

  current = newstruct(name);
  nextsymb();  // definition
  snesting = snesting + 1;
  while(1)
  {
    int flagvec = parse_modifiers();
    int star0 = 0;
    CT *ct = ct_insize(&flagvec, &star0);
    if (ct == NULL)
      {
	error("null type in struct/union def\n");
	return current;
      }

    while(1)
    { 
      int itemsize = ct->ctsize;
      INSTANCE *ins = parse_instance(1, flagvec, ct, star0); 
      char *tname = ins->wnode;
      int partial = 0;

      if (ins->stars1 +ins->dimensions) itemsize = target_ptr_size;
      if (itemsize <= SVOID) error("Bad types not allowed in structures");
      if (symb == s_lsquare)
      {
	printf("NOT USED ANYMORE\n"); exit(1);
        nextsymb();
	itemsize = itemsize * evalmanifeste(parse_expr());
	checkfor(s_rsquare);
	partial = 1;
      }
      if (ins->dimensions) 
	{
	  partial = 1;
	}
/*
printf("%i entry '%s' size %i at offset %i\n", unionp, tname, size, tagoffset);
*/
      newtag(current, tname, ins, tagoffset, partial);

      if (unionp != s_union)
        {
          tagoffset = (tagoffset + itemsize + 3) & 0xFFFFFFFC;
          totalsize = tagoffset;
        }
      else
        {
          if (itemsize > totalsize) totalsize = itemsize;
        }
      
      if (symb == s_semicolon) break;
      checkfor(s_comma);
    }
    checkfor(s_semicolon);
    if (symb == s_rsect) break;
  }
  current -> totalsize = totalsize;
  nextsymb();

  snesting = snesting - 1;
  return current;
}


STRUCT * findstruct(char *name)
{ 
  STRUCT *r = structures;
  while(r)
    {
      if (r->sname == name) return r;
      r = r->nextstruct;
    }
  return NULL;
}

STRUCT *newstruct(char *name) 
{
  STRUCT *r;
  if (name != anon_name)
    {
      r = findstruct(name);
      if (r)
	{
	  error("structure %s defined again", name);
	  return r;
	}
    }
  r = NEWZ(STRUCT);
  r->sname = name;
  r->staglist = NULL;
  r->totalsize = 100; /* Avalue for debugging recursive ones only */
  r->nextstruct = structures;
  structures = r;
  return r;
}

struct stag * findtag(STRUCT *st, char *name)
{ 
  struct stag *r;
  if (((int) st) <= 4) return NULL;
  r = st->staglist;
  while(r)
    { 
      if (r->tagname == name) return r;
      r = r->nextstag;
    }
  return NULL;
}

void newtag(STRUCT *st, char *name, INSTANCE *it, int offset, int partial)
{
  struct stag *r = findtag(st, name);
  if (r)
  { error("structure tag %s defined again", name);
      return;
  }
  r = NEWZ(struct stag);
  r->tagname = name;
   r->it = it;
  r->tagindex = offset;
  r->tpartial = partial;
  r->nextstag = st->staglist;
  st->staglist = r;
  /*  printf("tag %s with %i stars\n", name, stars);
   */
}

void printstruct(STRUCT *s)
{
  printf("struct %s: totalsize=%i", s->sname, s->totalsize);
}

void printct(CT *ct)
{
  printf("printct: ");
  if (ct->st) printstruct(ct->st);
  printf(" ctsize %i, \n", ct->ctsize);
}

/* Type def */
void doatypedef()
{
  int flags = 0;
  int stars = 0;
  CT *ct = ct_insize(&flags, &stars);


  if (ct == NULL)
    {
      fatal("No ct [X1]\n");
    } 
  /*  printf("ptr is %i", ptr);
   */
  while(symb==s_star)
  {
    stars++;
    nextsymb();
  }
  if (symb != s_newid)
  {
    error("typename expected");
  }
  else
  {
    typedefine(ct, stars, flags, wordnode);
    nextsymb();
  }
}

void starname1(CT *ct, int flagvec, int star0)
{
  INSTANCE * ins;
  int edited = 0;
  int lnoff = 1;


  if (symb == s_semicolon) return;
  ins = parse_instance(/*skipanyargs=*/0, flagvec, ct, star0);
  if (ins->wnode == NULL) return;


 
  if (ins->dimensions) /* handle array declarations */
    {
            
      christen(ins->wnode, sim_rval, ins, 0, 0);

      if (symb == s_equals) /* initialised array ? */
	{
	  checkfor(s_equals); /* It is initialised */
	  if (edited) error("internal error initialised sized array");
	  text_mkglobext2(flagvec, ins->wnode); 
	  edited = 1;
	  if (symb == s_string)
	    {                            /* either with a string or a { } */
	      staticstring(wordnode);
	      nextsymb();
	      return;
	    }
	  else
	    {
	      int netcount = 1;
	      if (symb != s_lsect) error("{ missing");
	      
	      nextsymb();
	      while (netcount)
		{ 
		  EXPRESSION *cc1, *cc0;
		  int eprs = 0;
		  int size;
		  char *directive;
		  /* look for first expression of line */
		  if (symb == s_lsect) 
		    {
		      netcount += 1;
		      nextsymb();
		      continue;
		    }
		  if (symb == s_comma) nextsymb();
		  if (symb == s_rsect) { netcount -= 1; nextsymb(); continue; }
		  if (symb == s_comma) nextsymb();
		  if (netcount) 
		    { 
		      cc0 = compile_evalconst(parse_expr());
		      if (symb == s_comma) nextsymb();
		      eprs ++;
		    }
		  
		  /* Now look for second */
		  if (symb == s_comma) nextsymb();
		  if (symb == s_rsect) { netcount -= 1; nextsymb(); continue; }
		  if (symb == s_comma) nextsymb();
		  if (netcount) 
		    { 
		      cc1 = compile_evalconst(parse_expr());
		      if (symb == s_comma) nextsymb();
		      eprs ++;
		    }
		  

		  size = (ins->stars1 > 0) ? target_ptr_size:ct->ctsize;
		  if (size > target_ptr_size) size = target_ptr_size; /* hack */
		  directive = (size == target_ptr_size) ? ".word": ".ascii";
		  if (eprs == 2)
		    assembly("DAT\t %s !B,!B\n", directive, cc0, cc1);
		  else if (eprs == 1)
		    assembly("DAT\t %s !B\n", directive,  cc0);
		  eprs = 0;
		}
	      return;
	    }
	}

      else
	{ /* uninitialised array */
	  int i;
	  for (i=0;i<ins->dimensions;i++)
	    {
	      if (ins->dim_idx[i] < 0) break;
	      else lnoff *= ins->dim_idx[i];
	    }

	  
	  if (edited == 0) 
	    { 
	      bss_mkglobext2(flagvec, ins->wnode); 
	      edited = 1; 
	    }
	  ramreserve1(flagvec, (ins->stars1 > 0) ? target_ptr_size : ct->ctsize, lnoff);
	  return;
	}


    }
  else

  switch(symb)
  {

    case s_comma:
    case s_semicolon:  /* uninitialised scalar */
      christen(ins->wnode, sim_lval, ins, 0, 0);
      bss_mkglobext2(flagvec, ins->wnode);
      if (ins->stars1 > 0) ramreserve1(flagvec, target_ptr_size, lnoff);
      else
        {
	  ramreserve1(flagvec, ct->ctsize, lnoff);
        }
      return;

    case s_lparen:
      definition(ins);  /* must cope with prototypes too */
      return;

    case s_equals:                   /* initialised static scalar */
      nextsymb();
      christen(ins->wnode, sim_lval, ins, 0, 0);
      bss_mkglobext2(flagvec, ins->wnode);
      if (ins->stars1) staticvalench(ct_ptr, compile_expr(parse_expr(), 0));
      else staticval1(flagvec, ct, evalmanifeste(parse_expr()));
      return;
   }
 } 

    
/* define a row of comma separated variables of same type. */
void starname(CT *ct, int flagvec, int star0)
{ 
  starname1(ct, flagvec, star0);
  while (symb == s_comma)
  {
    nextsymb();
    starname1(ct, flagvec, star0);
  }
}


ENODE *parse_general_call()
{
  if (symb == s_rparen)
    {
      nextsymb();
      return NULL;
    }
  else
  {
    ENODE *e = NEWZ(ENODE);
    e->key = e_actualarg;
    e->exp = parse_expr();  /* Eval the arg */
    if (symb == s_comma) nextsymb();
    e->exp1 = parse_general_call();
    return e;
  }
}


ENODE *parse_condition1()
{
  ENODE *e = parse_expr0();
  if (symb == s_logand || symb == s_logor)
    {
      ENODE *me = NEWZ(ENODE);
      me->key = (symb == s_logand) ? e_logand: e_logor; 
      me->exp = e;
      nextsymb();
      me->exp1 = parse_condition1();
      return me;
    }
  else return e;
}

ENODE *parse_condition()
{
  ENODE *e;
  checkfor(s_lparen);
  e = parse_condition1();
  checkfor(s_rparen);
  return e;
}


ENODE *parse_exprterm()
{
  ENODE *e = NEWZ(ENODE);
  uchar os = symb;
  char *owordnode = wordnode;
  nextsymb();
  switch(os)
    { 
    case s_number:
      e->key = e_number;
      e->i = (int) owordnode;
      return e;
    

    case s_newid:
      e->key = e_id;
      e->wordnode = owordnode;
      return e;

    case s_abs:
      e->key = e_abs;
      checkfor(s_lparen);
      e->exp = parse_expr0();
      checkfor(s_rparen);
      return e;

    case s_string:
      e->key = e_string;
      e->wordnode = owordnode;
      return e;
      /* cat adjacent strings 
	struct ccons *start, *end;
	start = cons(owordnode, NULL);
	end = start;
	while(symb == s_string) 
	  { 
	    struct ccons *p = cons(wordnode, NULL);
	    end->cdr = p;
	    end = p;
	    nextsymb();
	  }
	  */

    case s_lparen:
      {
	ENODE *ex;
	ex = parse_expr0();  /* ENODE in parens */
	checkfor(s_rparen);
	return ex;
      }

    default:
      error("Syntax error (symb=%s)", lextok(os));
      nexttoks();
      return NULL;
    }
}


/* parse_expr8 is unusual since it has 
 * r-to-l associativity of ops   
 */
ENODE *parse_expr8()
{
  uchar os = symb;
  switch(symb)
    {
    case s_lparen:                /* Must distinguish cast from () here */
      nextsymb();
      {
	int flagvec = parse_modifiers();
	int stars = 0;
	CT *ct = ct_insize(&flagvec, &stars);

	ENODE *e = NEWZ(ENODE);
	if (ct)   /* null is returned if not a cast */
	  {
	    while (symb == s_star)
	      { 
		stars ++;
		nextsymb();
	      }
	    checkfor(s_rparen);

	    e->key = e_cast;
	    e->exp = parse_expr8();

	    e->it = NEWZ(INSTANCE);
	    e->it->wnode = "cast";
	    e->it->stars1 = stars;
	    e->it->ct = ct;
	    e->it->flagvec = flagvec;
	    return e;
	  }
	else
	  {                
	    /* must be (exp) which is handled at parse_exprterm */
	    unnextsymb();  /* remove lookahead */
	    return parse_expr9();
	  }
      }

    case s_plus:
      nextsymb();
      return parse_expr8();
      
    case s_star:         /* monadic star operator */
      nextsymb();
      {
	ENODE * e = NEWZ(ENODE);
	e->key = e_stars;
	e->exp = parse_expr8();
	e->stars = 1;
	return e;
      }

    case s_tilda:             /* monadic ones complement */
    case s_pling:             /* monadic logical negation */
      nextsymb();
      {
	ENODE *e = NEWZ(ENODE);
	e->exp = parse_expr8();
	e->key = (os == s_tilda) ? e_tilda: e_pling;
	return e;
      }
      
      
    case s_minus:              /* monadic arith negate */
      nextsymb();
      {
	ENODE *e = NEWZ(ENODE);
	ENODE *zero = NEWZ(ENODE);
	zero->key = e_number;
	zero->i = 0;
	e->key = e_subtract;
	e->exp = zero;
	e->exp1 = parse_expr8();
	return e;
      }
      
    case s_plusplus:              /* prefix ++ and -- operators */
    case s_minusminus:
      {
	ENODE * e = NEWZ(ENODE);
	nextsymb();
	e ->exp = parse_expr8();
	e->key = (os == s_plusplus) ? e_pre_plusplus: e_pre_minusminus;
	return e;
      }

    case s_ampersand:
      nextsymb();
      {
	ENODE * e = NEWZ(ENODE);
	e->key = e_addressof;
	e ->exp = parse_expr8();
	return e;
      }

    case s_sizeof:
      nextsymb();
      {
	ENODE * e = NEWZ(ENODE);
	CT *ct;
	int lsize;
	int stars = 0;
	int flagvec = 0;
	checkfor(s_lparen);
	flagvec |= parse_modifiers();
	ct = ct_insize(&flagvec, &stars);
	if (symb == s_star) 
	  {
	    stars ++;
	    nextsymb();
	  }
	if (ct == NULL) error("undefined type in sizeof", "");

	if (ct == NULL || stars > 0) lsize = target_ptr_size;
	else lsize = ct->ctsize;
	e->key = e_number;
	e->i = lsize;
	checkfor(s_rparen);
	return e;
      }

    default:
      return parse_expr9();
    }
}


/*
 * generic parse_expr routine 
 */
ENODE *parse_expr()            
{
  ENODE *e;
  e = parse_expr0();
  return e;
}


/*
 * parse_expr ENODEs as statement. 
 */
ENODE *parse_exprcmd() 
{
  ENODE *e = parse_expr0(0);
  if (symb == s_comma)
    {
      ENODE *ne = NEWZ(ENODE);
      nextsymb();
      ne->exp = e;
      ne->key = e_cmd;
      ne->exp1 = parse_exprcmd();
      return ne;
    }
  return e;
}

/* 
 * private entry routine for other parse_exprs 
 * handles <?:> and <,> and <:=> 
 */
ENODE *parse_expr0()          
{
  ENODE * e = parse_expr1();
  if (symb == s_query)
    { 
      ENODE *ne = NEWZ(ENODE);
      ne->key = e_query;
      ne->exp = e;
      nextsymb();
      ne->exp1 = parse_expr1();
      checkfor(s_colon);
      ne->exp2 = parse_expr0();
      return ne;
    }
  else if (symb == s_equals  ||            /* assignment op = */
	   symb == s_andeq || symb == s_oreq || symb == s_pluseq ||
	   symb == s_minuseq || symb == s_lshifteq || symb == s_rshifteq ||
	   symb == s_stareq || symb == s_slasheq || symb == s_eoreq)
    {
      ENODE *me = NEWZ(ENODE);
      me->exp = e;
      me->key = e_assign;
      me->uch = symb;
      nextsymb();
      me->exp1 = parse_expr0();
      return me;
    }
  else return e;
}



ENODE *parse_expr1()
{
  ENODE *e = parse_expry();
  while (symb == s_bitor)
    { 
      ENODE *me = NEWZ(ENODE);
      me->key = e_bitor;
      me->exp = e;
      nextsymb();
      me->exp1 = parse_expr1();
      e = me;
    }
  return e;
}

ENODE * parse_expry()
{
  ENODE *e = parse_expr2();
  while (symb == s_eor)
    { 
      ENODE *me = NEWZ(ENODE);
      me->key = e_eor;
      me->exp = e;
      nextsymb();
      me->exp1 = parse_expr2();
      e = me;
    }
  return e;
}

ENODE * parse_expr2()
{
  ENODE *e = parse_expr3();
  while (symb == s_ampersand)
    { 
      ENODE *me = NEWZ(ENODE);
      me->key = e_bitand;
      me->exp = e;
      nextsymb();
      me->exp1 = parse_expr3();
      e = me;
    }
  return e;
}

ENODE * parse_expr3()
{
  ENODE * e = parse_expr35();
  if ((symb == s_plingeq) || (symb == s_eqeq))
    {
      ENODE *me = NEWZ(ENODE);
      me->uch = symb;
      me->key = e_comparisonip;
      me->exp = e;
      nextsymb();
      me->exp1 = parse_expr35();
      return me;
    }
  return e;
}

ENODE * parse_expr35()
{
  ENODE * e = parse_expr4();
  if ((symb == s_lesser) || (symb == s_greater) ||
       (symb == s_lessereq) || (symb == s_greatereq))
     { 
       ENODE *me = NEWZ(ENODE);
       me->uch = symb;
       me->key = e_comparisonip;
       me->exp = e;
       nextsymb();
       me->exp1 = parse_expr4();
       return me;
    }
  return e;
}


ENODE *parse_expr4()
{
  ENODE *e = parse_expr5();  /* do not allow association */
  if ((symb == s_rshift) || (symb == s_lshift))
  {
    ENODE *me = NEWZ(ENODE);
    me->key = (symb == s_rshift) ? e_rshift: e_lshift;
    me->exp = e;
    nextsymb();
    me->exp1 = parse_expr5();
    return me;
  }
  return e;
}


/*  
 * Parse addition AND subtraction 
 */
ENODE *parse_expr5()
{
  ENODE *e = parse_expr6();
  while ((symb == s_plus) || (symb == s_minus))
    {
      ENODE *me = NEWZ(ENODE);
      me->key = (symb == s_plus) ? e_add: e_subtract;
      me->exp = e;
      nextsymb();
      me->exp1 = parse_expr6();
      e = me;
    }
   return e;
 }


/*
 * times divide and remainder
 */
ENODE * parse_expr6()
{
  ENODE *e = parse_expr8();
  if ((symb == s_star) || (symb == s_slash) || (symb == s_percent))
    {
      ENODE *me = NEWZ(ENODE);
      me->key = (symb == s_star) ? e_multiply: (symb==s_slash) ? e_divide: e_remainder;
      me->exp = e;
      nextsymb();
      me->exp1 = parse_expr6();
      return me;
    }
  else return e;
}


/*
 * 9  - Array subscription   [  ], pling and dot and function call.
 * postfix    operators
 */
ENODE *parse_expr9()
{
  ENODE *e = parse_exprterm();
  ENODE *me;
  while (1) switch(symb)
    { 
    default: return e;
    
    case s_lsquare:                /* array l[r]- convert to *(l+r)  */
      me = NEWZ(ENODE);
      me->key = e_add;
      me->exp = e;
      nextsymb();
      me->exp1 = parse_expr0();
      checkfor(s_rsquare);
      e = NEWZ(ENODE);
      e->key = e_stars;
      e->exp = me;
      
      continue;
      
      /* Function call  */
    case s_lparen:
      me = NEWZ(ENODE);
      me->key = e_call;
      nextsymb();
      me->exp = e;
      me->exp1 = parse_general_call();
      e = me;
      continue;
      
      /* postfix ++ or -- */
    case s_plusplus:
    case s_minusminus:
      me = NEWZ(ENODE);
      me->key = (symb == s_plusplus) ? e_post_plusplus: e_post_minusminus;  
      nextsymb();
      me ->exp = e;
      e = me;
      continue;
      
    case s_arrow:                  /* C Pling operator -> */
    case s_dot:                    /* Dot structure access */
      me = NEWZ(ENODE);
      me->key = (symb == s_arrow) ? e_arrow: e_dot;  
      me->exp = e;
      nextsymb();
      if (symb != s_newid) error("missing tag name in struct/union ref");
      me->wordnode = wordnode;
      e = me;
      nextsymb();
      continue;
    }
}




PT *parse_switch_items()
{
  
  if (symb == s_rsect) return NULL;
  
  else if (symb == s_default)
    { 
      PT *p = NEWZ(PT);
      nextsymb();
      checkfor(s_colon);
      p->wordnode = "default";
      p->c2 = parse_switch_items();
      return p;
    }
  
  else if (symb == s_case)
    { 
      PT *p = NEWZ(PT);
      nextsymb();
      p->e1 = parse_expr();

      checkfor(s_colon);
      p->c2 = parse_switch_items();
      return p;
    }
  
  else 
    {
      PT *p = NEWZ(PT);
      p->c1 = parse_command();
      p->c2 = parse_switch_items();
      return p;
    }
}


PT *parse_command()
{
  uchar os = symb;
  PT *p = NEWZ(PT);
  if (srcptr)
    {
      CONS *m = (CONS *) srcptr;
      p->key = p_srctext;
      p->wordnode = (char *) srcptr;
      while (m)
	{
	  TRC(printf(".<%s>\n", m->car));
	  m = m->cdr;
	}
      srcptr = NULL;
      p->c1 = parse_command();
      return p;
    }

  nextsymb();

  switch(os)
    { 
    default:
      unnextsymb();
      p->key = p_eval;
      p->e1 = parse_exprcmd();
      return p;
      
    case s_newid:
      if (symb == s_colon)  /* a code label */
        { 
	  p->key = p_label;
	  p->wordnode = wordnode;
	  nextsymb();
          return p;
        }
      unnextsymb();
      p->key = p_eval;
      p->e1 = parse_exprcmd();
      return p;

      case s_lsect:
	return parse_block();
	

      case s_semicolon: case s_comma: return NULL;

      case s_return:
	p->key = p_return;
	if (symb != s_semicolon)
	  {
	    p->e1 = parse_expr();
	    return p;
	  }
	else p->e1 = NULL;
        return p;

     case s_do:
        { 
	  p->key = p_do;
	  p->c1 = parse_command();
	  if (symb == ';') nextsymb();
          checkfor(s_while);
          p->e1 = parse_condition();
	  return p;
        }

    case s_break:
      p->key = p_break;
      return p;
      
    case s_continue:
      p->key = p_continue;
      return p;


     case s_while:
        { 
	  p->key = p_while;
	  p->e1 = parse_condition();
	  p->c1 = parse_command();
          return p;
        }

     case s_if:
        { 
	  p->key = p_if;
	  p->e1 = parse_condition();
	  p->c1 = parse_command();
          while(symb == s_semicolon) nextsymb();
	  
          if (symb == s_else)
           { 
	     nextsymb();
	     p->c2 = parse_command();
	   }
	  else p->c2 = NULL;
	  return p;
	}

     case s_goto:
       p->key = p_goto;
       p->e1 = parse_expr();
       return p;

     case s_for:
       { 
	 p->key = p_for;
	 checkfor(s_lparen);
         if (symb != s_semicolon) p->c1 = parse_command(); else p->c1 = NULL;
         checkfor(s_semicolon);
         if (symb != s_semicolon) p->e1 = parse_expr();	 else p->e1 = NULL;
         checkfor(s_semicolon);
         if (symb != s_rparen) p->c2 = parse_command(); else p->c2 = NULL;
         checkfor(s_rparen);
         p->c3 = parse_command();
	 return p;
       }

     case s_switch:
      { 
        p-> key = p_switch;
	p-> e1 = parse_expr();
	checkfor(s_lsect);
	p->c1 = parse_switch_items();
	checkfor(s_rsect);
	return p;
      }


   }
}



/*
 * >>parse_instance() 
 * Seems to handle declarations of locals too.
 */
INSTANCE *parse_instance(int skipanyargs, int flagvec, CT *ct, int star0)
{
  INSTANCE *r = NEWZ(INSTANCE);
  r->stars1 = star0;
  r->flagvec = flagvec;

  TRC(printf("Enter parse instance with symb=%s  %s\n", lextok(symb), wordnode));
  while (symb==s_star) { r->stars1 ++; nextsymb(); }
  if (symb == s_lparen)
    {
      nextsymb();
      while (symb==s_star) 
	{ r->stars2 ++; nextsymb(); }
      if (symb != s_newid) error("[1] variable name expected");
      r->wnode = wordnode;
      nextsymb();
      checkfor(s_rparen);
      skipanyargs = 1;
    }
  else
    {
      if (symb != s_newid) error("[2] variable name expected");
      r->wnode = wordnode;
      nextsymb();
    }
  if (symb == s_lparen && skipanyargs)
    {
      r->flagvec |= m_isafun;
      while(symb != s_rparen) nextsymb();
      nextsymb();
    }

  /* declarations of arrays: handle array suffixes */
  while (symb == s_lsquare)
    {
      if (nextsymb() != s_rsquare)
	{
	  /* sized array */
	  r->dim_idx[r->dimensions] = evalmanifeste(parse_expr());  
	}
      else r->dim_idx[r->dimensions] = -1;
      
      if (r->dimensions == MAXDIMS) error("Too many dimensions in array");
      else r->dimensions ++;
      if (symb == s_comma)
	{
	  /* convert [x,y] into [x][y] effectively */
	  nextsymb();
	  symb = s_lsquare;
	}
      else if (symb == s_rsquare) nextsymb();
    }

  r->ct = ct;
  return r;
}


PT *parse_instances(int skipanyargs, int flagvec, CT *ct, int star0)
{
  if (symb == s_semicolon)
    {
      nextsymb();
      return NULL;
    }
  else
    {
      INSTANCE *i = parse_instance(skipanyargs, flagvec, ct, star0);
      PT *p = NEWZ(PT);
      p->key = 0;
      p->instance = i;
      if (symb == s_equals)
	{
	  nextsymb();
	  p->e1 = parse_expr();
	}
      else p->e1 = NULL;
      if (symb == s_comma) nextsymb();
      p->c1 = parse_instances(skipanyargs, flagvec, ct, star0);
      return p;
    }
}


PT *parse_formals()               
{
  if (symb == s_rparen)
    {
      nextsymb();
      return NULL;
    }
  else if (symb == s_3dots)            /* the ... symbol must be last */
    {
      PT *p = NEWZ(PT);
      p->key = p_3dots;
      nextsymb();
      p->c1 = parse_formals();
      return p;
    }
  else
    {
      int flagvec = parse_modifiers();
      int checksymb = symb;
      int stars = 0;
      CT *ct = ct_insize(&flagvec, &stars);

      if (0 && checksymb == s_void) /* Strange code - disable for now */
	{
	  /* This handles a void formal - ie not a formal at all - wot ?*/
	  return parse_formals();
	}
      else
	{
	  PT *p = NEWZ(PT);
	  p->key = p_formal;
	  if (symb == s_newid && ct == NULL) ct = ct_int;
	  p->instance = parse_instance(1, flagvec, ct, stars);
	  if (symb == s_comma)  nextsymb();
	  p->c1 = parse_formals();
	  return p;
	}
    }
}

/*
 * Variable declarations and formals and p_block PT nodes
 * have a chain of further items on c2.  A decl has a chain
 * of instances on c1 whereas a formal has just one in its instance
 * entry.
 */
PT *parse_block()
{
  PT *p = NEWZ(PT);
  if (symb == s_rsect)
    {
      nextsymb();
      return NULL;
    }
  else
    {
      int flags = parse_modifiers();
      int stars = 0;
      CT *ct = ct_insize(&flags, &stars);
      if (flags || ct)
	{
	  if (ct == NULL) ct = ct_int;
	  p->key = p_decl;
	  p->c1 = parse_instances(1, flags, ct, stars);
	}
      else
	{
	  p->key = p_block;
	  p->c1 = parse_command();
	}

      if (symb == s_rsect || symb == s_eof)
	{
	  p->c2 = NULL;
	  nextsymb();
	}
      else 
	{
	  p->c2 = parse_block();
	}
    }
  return p;
}




void parser_clear()
{
  structures = NULL;
  typelist = NULL;
}
/* eof parser.c */


