module flam where

open import Basics
open import Atoms
open import Perms
open import PermProp
open import Nom
open import FreshNom
open import NameAbst

data λ-term : Set where
 Var : Atom → λ-term
 App : λ-term → λ-term → λ-term
 Abs : Atom → λ-term → λ-term


Actλ : Perm → λ-term → λ-term
Actλ π (Var a) = Var (PermAct π a)
Actλ π (App t₁ t₂) = App (Actλ π t₁) (Actλ π t₂)
Actλ π (Abs a t') = Abs (PermAct π a) (Actλ π t')


Suppλ : λ-term → List Atom
Suppλ (Var a) = [ a ]
Suppλ (App t₁ t₂) = Suppλ (t₁) ++ Suppλ (t₂)
Suppλ (Abs a t') =  a :: Suppλ t'


data Eqλ : Rel λ-term where
 EqλVar : {a b : Atom} → a ≡ b → Eqλ (Var a) (Var b)
 EqλApp : {t₁ t₂ t₁' t₂' : λ-term} → Eqλ t₁ t₁' → Eqλ t₂ t₂' → Eqλ (App t₁ t₂)(App t₁' t₂')
 EqλAbs : {a a' : Atom}{t t' : λ-term} → (b : Atom) → a ≠ b → a' ≠ b → b ∉ (Suppλ t) → b ∉ (Suppλ t') → (Eqλ (Actλ [(b , a)] t) (Actλ [(b , a')] t')) → Eqλ (Abs a t) (Abs a' t')


p₁≈p₂λ : {π₁ π₂ : Perm} → pEquiv π₁ π₂ → (t : λ-term) → (Actλ π₁ t) ≡ (Actλ π₂ t)
p₁≈p₂λ π₁≈π₂ (Var a) rewrite π₁≈π₂ {a} = refl
p₁≈p₂λ π₁≈π₂ (App t₁ t₂) = cong₂ (λ u v → App u v) (p₁≈p₂λ π₁≈π₂ t₁) (p₁≈p₂λ π₁≈π₂ t₂) 
p₁≈p₂λ π₁≈π₂ (Abs a t) = cong₂ (λ u v → Abs u v) (π₁≈π₂ {a}) (p₁≈p₂λ π₁≈π₂ t)


ιλ : (t : λ-term) → Actλ ι t ≡ t
ιλ (Var a) = refl
ιλ (App t₁ t₂) = cong₂ (λ u v → App u v) (ιλ t₁) (ιλ t₂)
ιλ (Abs a t) = cong₂ (λ u v → Abs u v) (a ▪) (ιλ t)


p₁p₂λ : (π₁ π₂ : Perm) → (t : λ-term) → (Actλ π₁ (Actλ π₂ t)) ≡ (Actλ (π₂ ++ π₁) t)
p₁p₂λ π₁ π₂ (Var a) = cong (λ u → Var u) (sym (p₁++p₂≡p₂p₁ {a} π₂ π₁))
p₁p₂λ π₁ π₂ (App t₁ t₂) = cong₂ (λ u v → App u v) (p₁p₂λ π₁ π₂ t₁) (p₁p₂λ π₁ π₂ t₂)
p₁p₂λ π₁ π₂ (Abs a t) = cong₂ (λ u v → Abs u v) (sym (p₁++p₂≡p₂p₁ {a} π₂ π₁)) (p₁p₂λ π₁ π₂ t)


SuppAxλ : (t : λ-term)(b c : Atom) → b ∉ (Suppλ t) → c ∉ (Suppλ t) → Actλ [(b , c)] t ≡ t
SuppAxλ (Var a) b c (a∉as a∉[] a≠b) (a∉as a∉[] a≠c) = cong (λ u → Var u) (swapabc≡c b c a a≠b a≠c)
SuppAxλ (App t₁ t₂) b c b∉t c∉t = let t₁ₛ = (Suppλ t₁) in let t₂ₛ = (Suppλ t₂) in let b∉t₁ = ∉⊆₁ {t₁ₛ}{t₂ₛ} b b∉t in let b∉t₂ = ∉⊆₂ {t₁ₛ}{t₂ₛ} b b∉t in let c∉t₁ = ∉⊆₁ {t₁ₛ}{t₂ₛ} c c∉t in 
                                                       let c∉t₂ = ∉⊆₂ {t₁ₛ}{t₂ₛ} c c∉t in cong₂ (λ u v → App u v) (SuppAxλ t₁ b c b∉t₁ c∉t₁) (SuppAxλ t₂ b c b∉t₂ c∉t₂)
SuppAxλ (Abs a t) b c (a∉as b∉t a≠b) (a∉as c∉t a≠c) = cong₂ (λ u v → Abs u v) (swapabc≡c b c a a≠b a≠c) (SuppAxλ t b c b∉t c∉t)


EqλS : Symmetric λ-term Eqλ 
EqλS (EqλVar a≡b) = EqλVar (sym a≡b)
EqλS (EqλApp t₁≈t₁' t₂≈t₂') = EqλApp (EqλS t₁≈t₁') (EqλS t₂≈t₂')
EqλS (EqλAbs b a≠b a'≠b b∉t b∉t' bat≈ba't') = EqλAbs b a'≠b a≠b b∉t' b∉t (EqλS bat≈ba't')

≡α : {t t' t'' t''' : λ-term} → t ≡ t' → t'' ≡ t''' → Eqλ t' t''' → Eqλ t t''
≡α refl refl t'≈t'' = t'≈t''

∉eqλ : {b : Atom}{t : λ-term}(π : Perm) → b ∉ (Suppλ t) → (PermAct π b) ∉ (Suppλ (Actλ π t))
∉eqλ {b}{Var a} π (a∉as a∉[] a≠b) = a∉as a∉[] (a≠b⇒πa≠πb a b π a≠b)
∉eqλ {b}{App t₁ t₂} π b∉t = let t₁ₛ = (Suppλ t₁) in let t₂ₛ = (Suppλ t₂) in let b∉t₁ = ∉⊆₁ {t₁ₛ}{t₂ₛ} b b∉t in let b∉t₂ = ∉⊆₂ {t₁ₛ}{t₂ₛ} b b∉t in let πb∉πt₁ = ∉eqλ {b}{t₁} π b∉t₁ in 
                                               let πb∉πt₂ = ∉eqλ {b}{t₂} π b∉t₂ in let πt₁ₛ = (Suppλ (Actλ π t₁)) in let πt₂ₛ = (Suppλ (Actλ π t₂)) in ∉ℓ₁ℓ₂ πt₁ₛ πt₂ₛ (PermAct π b) πb∉πt₁ πb∉πt₂
∉eqλ {b}{Abs a t} π (a∉as b∉t a≠b) = a∉as (∉eqλ {b}{t} π b∉t) (a≠b⇒πa≠πb a b π a≠b)


Resαπ : {t₁ t₂ : λ-term}(π : Perm) → Eqλ t₁ t₂ → Eqλ (Actλ π t₁) (Actλ π t₂)
Resαπ {Var a}{Var .a} π (EqλVar refl) = EqλVar refl
Resαπ {App t₁ t₂}{App t₁' t₂'} π (EqλApp t₁≈t₁' t₂≈t₂') = EqλApp (Resαπ π t₁≈t₁') (Resαπ π t₂≈t₂')
Resαπ {Abs a t}{Abs a' t'} π (EqλAbs b a≠b a'≠b b∉t b∉t' bat≈ba't') = let πa = PermAct π a in let πa' = PermAct π a' in let πt = Actλ π t in let πt' = Actλ π t' in 
                                               let πb = PermAct π b in let πbat = Actλ π (Actλ [(b , a)] t) in let πba't' = Actλ π (Actλ [(b , a')] t') in  
                                               let prf₁ = πbat                                                              ≡<  p₁p₂λ π [(b , a)] t >
                                                             ((Actλ ([(b , a)] ++ π) t)                                ≡< sym (p₁≈p₂λ (λ {w} → π+πab≈abπ π b a {w}) t) >
                                                             ((Actλ (π ++ [(πb , πa)]) t)                             ≡< sym (p₁p₂λ [(πb , πa)] π t) >
                                                             ((Actλ [(πb , πa)] πt) ▪))) in
                                              let prf₂ = πba't'                                                              ≡<  p₁p₂λ π [(b , a')] t' >
                                                             ((Actλ ([(b , a')] ++ π) t')                                ≡< sym (p₁≈p₂λ (λ {w} → π+πab≈abπ π b a' {w}) t') >
                                                             ((Actλ (π ++ [(πb , πa')]) t')                             ≡< sym (p₁p₂λ [(πb , πa')] π t') >
                                                             ((Actλ [(πb , πa')] πt') ▪))) in
                                               EqλAbs πb (a≠b⇒πa≠πb a b π a≠b) (a≠b⇒πa≠πb a' b π a'≠b) (∉eqλ {b}{t} π b∉t) (∉eqλ {b}{t'} π b∉t') (≡α (sym prf₁) (sym prf₂) (Resαπ π bat≈ba't'))


Some/anyλ : {a a' : Atom}{t t' : λ-term} → Eqλ (Abs a t) (Abs a' t') → (b : Atom) → a ≠ b → a' ≠ b → b ∉ (Suppλ t) → b ∉ (Suppλ t') → Eqλ (Actλ [(b , a)] t) (Actλ [(b , a')] t')
Some/anyλ {a}{a'}{t}{t'} (EqλAbs c a≠c a'≠c c∉t c∉t' cat≈ca't') b a≠b a'≠b b∉t b∉t' = let cat = Actλ [(c , a)] t in let ca't' = Actλ [(c , a')] t' in let bat = Actλ [(b , a)] t in let ba't' = Actλ [(b , a')] t' in
                                                                        let prf₁ =  bat                                                                     ≡< p₁≈p₂λ (λ {w} → ac≈ab+bc+ab b c a  a≠b a≠c {w}) t >
                                                                                        ((Actλ ([(b , c)] ++ ([(c , a)] ++ [(b , c)])) t)     ≡< sym (p₁p₂λ ([(c , a)] ++ [(b , c)]) [(b , c)] t) >
                                                                                        ((Actλ ([(c , a)] ++ [(b , c)]) (Actλ [(b , c)] t))   ≡< cong (λ w → Actλ ([(c , a)] ++ [(b , c)]) w) (SuppAxλ t b c b∉t c∉t) >
                                                                                        ((Actλ ([(c , a)] ++ [(b , c)]) t)                           ≡< sym (p₁p₂λ [(b , c)] [(c , a)] t) >
                                                                                        ((Actλ [(b , c)] (Actλ [(c , a)] t)) ▪)))) in
                                                                        let prf₂ =  ba't'                                                                    ≡< p₁≈p₂λ (λ {w} → ac≈ab+bc+ab b c a' a'≠b a'≠c {w}) t' >
                                                                                        ((Actλ ([(b , c)] ++ ([(c , a')] ++ [(b , c)])) t')     ≡< sym (p₁p₂λ ([(c , a')] ++ [(b , c)]) [(b , c)] t') >
                                                                                        ((Actλ ([(c , a')] ++ [(b , c)]) (Actλ [(b , c)] t'))   ≡< cong (λ w → Actλ ([(c , a')] ++ [(b , c)]) w) (SuppAxλ t' b c b∉t' c∉t') >
                                                                                        ((Actλ ([(c , a')] ++ [(b , c)]) t')                           ≡< sym (p₁p₂λ [(b , c)] [(c , a')] t') >
                                                                                        ((Actλ [(b , c)] (Actλ [(c , a')] t')) ▪)))) in 
                                                                        let prf₃ = Resαπ [(b , c)] cat≈ca't' in ≡α prf₁ prf₂ prf₃ 


EqλR : Reflexive λ-term Eqλ
EqλR {Var a} = EqλVar (a ▪)
EqλR {App t₁ t₂} = EqλApp (EqλR {t₁}) (EqλR {t₂})
EqλR {Abs a t} = let tₛ = (Suppλ t) in let b = outside (a :: tₛ) in let a≠b = des≠ (outside∉ (a :: tₛ)) in let b∉t = des∉ (outside∉ (a :: tₛ)) in EqλAbs b a≠b a≠b b∉t b∉t (Resαπ [(b , a)] (EqλR {t}))

t≡t⇒tαt : {t t' : λ-term} → t ≡ t' → Eqλ t t'
t≡t⇒tαt {t}{.t} refl = EqλR {t}


EqλT : Transitive λ-term Eqλ
EqλT (EqλVar a=b) (EqλVar b=c) = EqλVar (Trans (aEquiv≡ Atom) a=b  b=c) 
EqλT (EqλApp t₁=t₁' t₂=t₂') (EqλApp t₁'=t₁'' t₂'=t₂'') = EqλApp (EqλT t₁=t₁' t₁'=t₁'') (EqλT t₂=t₂' t₂'=t₂'')
EqλT {Abs a₁ t₁}{Abs a₂ t₂}{Abs a₃ t₃}(EqλAbs a₁₂ a₁≠a₁₂ a₂≠a₁₂ a₁₂∉t₁ a₁₂∉t₂ a₁t₁≈a₂t₂)(EqλAbs a₂₃ a₂≠a₂₃ a₃≠a₂₃ a₂₃∉t₂ a₂₃∉t₃ a₂t₂≈a₃t₃) =
                                                             let t₁ₛ = Suppλ t₁ in let t₂ₛ = Suppλ t₂ in let t₃ₛ = Suppλ t₃ in let l₁ = (t₁ₛ ++ t₃ₛ) in let l₂ = t₂ₛ ++ l₁ in let l₃ = a₁ :: (a₂ :: (a₃ :: l₂)) in let b = outside l₃ in
                                                             let b∉m = outside∉ l₃ in let a₁≠b = des≠ b∉m in let b∉n = des∉ b∉m in let a₂≠b = des≠ b∉n in let b∉o = des∉ b∉n in let a₃≠b = des≠ b∉o in let b∉l₂ = des∉ b∉o
                                                             in let b∉t₂ = ∉⊆₁ {t₂ₛ}{l₁} b b∉l₂ in let b∉l₁ = ∉⊆₂ {t₂ₛ}{l₁} b b∉l₂ in let b∉t₁ = ∉⊆₁ {t₁ₛ}{t₃ₛ} b b∉l₁ in let b∉t₃ = ∉⊆₂ {t₁ₛ}{t₃ₛ} b b∉l₁ in
                                                             let t₁≈t₂ = Some/anyλ (EqλAbs a₁₂ a₁≠a₁₂ a₂≠a₁₂ a₁₂∉t₁ a₁₂∉t₂ a₁t₁≈a₂t₂) b a₁≠b a₂≠b b∉t₁ b∉t₂ in
                                                             let t₂≈t₃ = Some/anyλ (EqλAbs a₂₃ a₂≠a₂₃ a₃≠a₂₃ a₂₃∉t₂ a₂₃∉t₃ a₂t₂≈a₃t₃) b a₂≠b a₃≠b b∉t₂ b∉t₃ in
                                                             let prf₁  =  t₁  ≡< sym (ιλ t₁) > ((Actλ ι t₁) ≡< sym (p₁≈p₂λ (bc+bc=ι b a₁) t₁) > ((Actλ ([(b , a₁)] ++ [(b , a₁)]) t₁) ≡< sym (p₁p₂λ [(b , a₁)] [(b , a₁)] t₁) >
                                                                               ((Actλ [(b , a₁)] (Actλ [(b , a₁)] t₁)) ▪))) in 
                                                             let prf₁₂ = Resαπ [(b , a₁)] t₁≈t₂ in let prf₂₃ = Resαπ [(b , a₁)] t₂≈t₃ in
                                                             let prf' = ≡α prf₁ ((Actλ [(b , a₁)] (Actλ [(b , a₂)] t₂)) ▪) prf₁₂ in let t₁≈t₃ = EqλT prf' prf₂₃ in
                                                             let bat₁≈t₃ = Resαπ [(b , a₁)] t₁≈t₃ in let bat₃ = Actλ [(b , a₃)] t₃ in
                                                             let prf₃ = (Actλ [(b , a₁)] (Actλ [(b , a₁)] bat₃))  ≡< p₁p₂λ [(b , a₁)] [(b , a₁)] bat₃ >
                                                                            ((Actλ ([(b , a₁)] ++ [(b , a₁)]) bat₃)    ≡< p₁≈p₂λ (bc+bc=ι b a₁) bat₃ >
                                                                            ((Actλ ι bat₃)                                       ≡< ιλ bat₃ >
                                                                            (bat₃ ▪)))  in 
                                                             let final = ≡α ((Actλ [(b , a₁)] t₁) ▪) (sym prf₃) bat₁≈t₃ in EqλAbs b a₁≠b a₃≠b b∉t₁ b∉t₃ final


EqλEq : isEquivalence λ-term Eqλ
EqλEq = record { Reflex = EqλR
                          ;  Symm = EqλS
                          ;  Trans = EqλT
                          }

λNom : Nominal
λNom = record { Aₛ = λ-term
                          ;  ≈ₐ = Eqλ
                          ; eq≈ₐ = EqλEq
                          ; Act = Actλ
                          ; res = λ {π₁}{π₂}{t₁}{t₂} π₁≈π₂ t₁≈t₂ → let π₁t₁≡π₂t₁ = p₁≈p₂λ π₁≈π₂ t₁ in let π₂t₁≈π₂t₂ = Resαπ π₂ t₁≈t₂ in ≡α π₁t₁≡π₂t₁ ((Actλ π₂ t₂) ▪) π₂t₁≈π₂t₂
                          ; p₁p₂↠ = λ π₁ π₂ {t} → t≡t⇒tαt (p₁p₂λ π₁ π₂ t)
                          ; ι↠ = λ {t} → t≡t⇒tαt (ιλ t)
                          ; some_supp = Suppλ
                          ; suppAx = λ t b c b∉t c∉t → t≡t⇒tαt (SuppAxλ t b c b∉t c∉t)
                          }

