type binary_op = PlusOp | TimesOp | MinusOp | DivOp 

type unary_op = UnaryMinusOp 

type ast = Ident of string 
         | Number of int 
         | Unary of unary_op * ast 
         | Binary of binary_op * ast * ast 

let bin_op_to_function bin_op (a, b) = 
   match bin_op with 
    | PlusOp -> a+b
    | TimesOp -> a*b 
    | MinusOp -> a-b
    | DivOp -> a/b

let rec eval e = 
  match e with 
  | Ident _ -> e 
  | Number _ -> e
  | Unary(UnaryMinusOp, se) -> 
      (match eval se with Number m -> Number(-m) | re -> Unary(UnaryMinusOp, re))
  | Binary (bin_op, se1, se2) -> 
      (match (eval se1, eval se2) with 
      | (Number m, Number n) -> Number ((bin_op_to_function bin_op) (m,n))
      | (a, b) -> Binary(bin_op, a, b) )

