package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public class U1Combinator extends Combinator
{

public U1Combinator()
{
    name = "U1";
}

/*
 *  U1 f Tuple(p,q)   =>  f p q
 */
 
boolean makeHeadNormal() throws TooManySteps
{
    if (trail == null) return false;
    Application trail1 = (Application)trail.function;
    if (trail1 == null) return false;
    // Now we know we have 2 arguments
    trail1.function = trail;
    trail.function = current; // repair (U1 f)
    Graph a = Graph.makeHeadNormal(trail1.argument);
    if (a instanceof Tuple)
    {   Tuple p = (Tuple)a;
        current = trail.argument;
        trail = new Application(trail1, p.car);
        trail1.argument = p.cdr;
	return true;
    }
    else
    {   trail1.argument = a;
        return false;
    }
}

}




