package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

// The following extra combinators follow suggestions by David Turner
// and make it possible to achive quite efficient compilation into
// combinator form.

//  B f g x = f (g x)    so B f g is f composed with g
//  C f x y = f y x      so C f is the 2-arg (curried) f with its args
//                       commuted
//  B1 z f g x = z f (g x)
//  C1 z f x y = z (f y) z
//  S1 z f g x = z (f x) (g x)  "long-reach" versions

//  P x y = a pair <x:y>
//  U f g <x:y> = g x y
//  U f g z     = f z (when z is not a pair <x:y>
//
// The workings here broadly follow the ideas explained earlier with the
// S sombinator, and so I will not give much annotation.

public class BCombinator extends Combinator
{

BCombinator()
{
    name = "B";
}

boolean makeHeadNormal()
{
    if (trail == null) return false;
    Application trail1 = (Application)trail.function;
    if (trail1 == null) return false;
    Application trail2 = (Application)trail1.function;
    if (trail2 == null) return false;
    // Now we know we have 3 arguments
    trail1.function = trail;
    trail.function = current; // repair ((B f) g)
    current = trail.argument; // new current is f
    trail = trail2;
    trail2.argument = 
        new Application(trail1.argument, trail2.argument); // (g x)
    // All done!!
    return true;
}

}



