package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public class Application extends Graph
{

// This is the sub-class of Graph that represents a function
// application.

Graph function;
Graph argument;

public Application(Graph function, Graph argument)
{
    this.function = function;
    this.argument = argument;
}

public void print() throws TooManySteps
{
    if (lengthLeft < 0) throw new TooManySteps();
    function.print();
    text(" ");
    if (argument instanceof Application)
    {   text("(");
        argument.print();
        text(")");
    }
    else argument.print();
}

public void reduceAndPrint() throws TooManySteps
{
// lengthLeft is used so I can make very long or infinite structures
// print as a controllable-llength part followed by "...". It is
// not a very precise control, but is nevertheless useful.
    if (lengthLeft < 0) throw new TooManySteps();
    if (function == null) text("<null>");
    else function.print();
    text(" ");
    if (argument == null)
    {   text("<null>");
        return;
    }
    argument = Graph.makeHeadNormal(argument);
    if (argument instanceof Application)
    {   text("(");
        argument.reduceAndPrint();
        text(")");
    }
    else argument.print();
}

boolean makeHeadNormal()
{
    current = function; // Main pointer-reversing descent into tree.
    function = trail;
    trail = this;
    // I really want reductionSteps to count genuine combinator
    // applications. It seems easiest to count all graph manipulations
    // but then discount ones that just desecnd into application nodes.
    reductionSteps--;
    return true;
}


Graph fn()
{
    return function;
}
    
Graph arg()
{
    return argument;
}
	
boolean eqCfn(String name)
{
    return function.eqC(name);
}
	    
boolean eqCfnfn(String name)
{
    return function.eqCfn(name);
}

Graph B = new BCombinator();
Graph B1 = new B1Combinator();
Graph C = new CCombinator();
Graph C1 = new C1Combinator();
Graph S = new SCombinator();
Graph S1 = new S1Combinator();
		
Graph abs(String name)
{
    Graph fn = function.abs(name);
    Graph arg = argument.abs(name);
    if (fn.eqCfn("K"))
    {   if (arg.eqCfn("K")) return new Application(Graph.K, 
            new Application(fn.arg(), arg.arg()));
        else if (arg.eqC("I")) return fn.arg();
        else return makeB(fn.arg(), arg);
    }
    else if (arg.eqCfn("K")) return makeC(fn, arg.arg());
    else if (fn.eqCfnfn("B"))
        return ap3(S1, fn.fn().arg(), fn.arg(), arg);
    return ap2(S, fn, arg);
}

static Graph makeY(Graph f)
{
    if (f.eqCfn("K")) return f.arg();
    else return new Application(new YCombinator(), f);
}

Graph makeB(Graph f, Graph g)
{
    if (f.eqC("I")) return g;
    else if (g.eqC("I")) return f;
    else if (f.eqCfnfn("B"))
        return ap3(B1, f.fn().arg(), f.arg(), g);
    else return ap2(B, f, g);
}

Graph makeC(Graph f, Graph x)
{
    if (f.eqCfnfn("B"))
        return ap3(C1, f.fn().arg(), f.arg(), x);
    else if (f.eqC("+") ||
             f.eqC("*") ||
             f.eqC("=") ||
             f.eqC("!=")) return new Application(f, x);
    else if (f.eqC(">")) return new Application(new LtCombinator(), x);
    else if (f.eqC("<")) return new Application(new GtCombinator(), x);
    else if (f.eqC(">=")) return new Application(new LeCombinator(), x);
    else if (f.eqC("<=")) return new Application(new GeCombinator(), x);
    else return ap2(C, f, x);
}

public static Graph ap2(Graph op, Graph arg1, Graph arg2)
{
    return new Application(
        new Application(op, arg1),
        arg2);
}

public static Graph ap3(Graph op, Graph arg1, Graph arg2, Graph arg3)
{
    return new Application(
        new Application(
            new Application(op, arg1),
            arg2),
        arg3);
}

public Graph substitute()
{
    return new Application(function.substitute(), argument.substitute());
}

public Type typeCheck(Environment e) throws NoType
{
    Type a = new Type(Type.typeVar);
    Type r = new Type(Type.typeVar);
    function.typeCheck(e).unifyWith(new Type(Type.funType, a, r));
    argument.typeCheck(e).unifyWith(a);
    return r.deref();
}

}



