import java.io.InputStream;
import java.io.IOException;

class PromptStream extends InputStream
{

InputStream base;
boolean atEOF;
int lastc;

public PromptStream (InputStream base)
{
    this.base = base;
    this.atEOF = false;
    lastc = '\n';
}

public int available() throws IOException
{
// The "0" here is to prevent any user of this stream from reading ahead
// and thus messing up where prompts appear. I *think* it is OK and will
// just cause sownstream readers to believe they are doing a blocking
// read.
    return 0;
}

public void close() throws IOException
{
    base.close();
}

public void mark(int n)
{
}

public boolean markSupported()
{
    return false;
}

public int read() throws IOException
{
    if (lastc == '\n')
    {   System.out.print("> ");
        System.out.flush();
    }
    if (atEOF) return -1;
    int c = base.read();
    if (c == 4) c = -1;  // Treat ctrl-D as EOF (Unix)
    if (c == 26) c = -1; // Treat ctrl-Z as EOF (DOS)
    lastc = c;
    if (c == -1) atEOF = true;
    return c;
}

public int read(byte [] b) throws IOException
{
    int c = read();
    if (c == -1) return -1;
    b[0] = (byte)c;
    return 1;
}

public int read(byte [] b, int off, int len) throws IOException
{
    int c = read();
    if (c == -1) return -1;
    b[off] = (byte)c;
    return 1;
}

public void reset()
{
}

public long skip(long n) throws IOException
{
    long r;
    for (r=0; r<n; r++)
    {   if (read() == -1) break;
    }
    return r;
}


}


