
package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

public class BasicRule extends Rule
{

public Pattern p;
public Graph b;

public BasicRule(Pattern p, Graph b)
{
    this.p = p;
    this.b = b;
}

public void print() throws TooManySteps
{
    p.print();
    Graph.text(" => ");
    b.print();
}

public void reduceAndPrint() throws TooManySteps
{
    p.print();
    Graph.text(" => ");
    b.print();
}

boolean makeHeadNormal()
{
    return false;
}

public Graph abs()
{
    return abs(p, b);
}

public Graph abs(Pattern p, Graph b)
{
    if (p instanceof WildPattern ||
        p instanceof PatUnit) return new Application(Graph.K, b);
    else if (p instanceof NamePattern) return b.abs(((NamePattern)p).name);
    else if (p instanceof PatTuple)
    {   PatTuple t = (PatTuple)p;    
        Pattern t1 = t.p1;
        PatTuple tt = t.p2;
        Pattern t2 = tt.p1;
        PatTuple ttt = tt.p2;
        if (ttt == null)
        {   Graph w = abs(t2, b);
            w = abs(t1, w);
	    return new Application(new U2Combinator(), w);
        }
        else
        {   Graph w = abs(tt, b);
            w = abs(t1, w);
	    return new Application(new U1Combinator(), w);
        }
    }
    Graph.text("Over-complicated abstraction, sorry");
    Graph.newline();
    return new Unit();
}

}



