package reducer;

/*
 *   Copyright (C) A C Norman, April 2000
 *   Permission is given to use this code in any way you want for
 *   purposes directly concerned with the University of Cambridge taught
 *   courses in Computer Science and associated study. Anybody who
 *   wants to re-distribute this code or use it commercially should
 *   check with ACN (acn1@cam.ac.uk) first.
 */

import java.math.BigInteger;

// I will want to have code for +, -, * etc on integers. The code
// involved has enough commonality that I will introduce an abstract
// class for a general (binary) arithmetic operation, and then
// customise it for each of the ones I actually want.

abstract class ArithCombinator extends Combinator
{

abstract Graph combine(BigInteger a, BigInteger b);

boolean makeHeadNormal() throws TooManySteps
{
    if (trail == null) return false;
    Application trail1 = (Application)trail.function;
    if (trail1 == null) return false;
// I need 2 arguments, otherwise I can not reduce at all.
    Application trail2 = (Application)trail1.function;
    Graph a = Graph.makeHeadNormal(trail.argument);
    trail.argument = a;
    if (!(a instanceof Gnumber)) return false;
    Graph c = current;
    trail.function = current;
    current = trail;
    trail = trail1;  // repair (op arg1) bit BEFORE evaluating arg2
    Graph b = Graph.makeHeadNormal(trail1.argument);
    if (!(b instanceof Gnumber))
    {   trail.argument = b;
        return false;
    }
// (recurse) reduce both arguments, and go no further if the result is
// non-numeric.
    trail.function = Graph.I;
// call a "combine" method to do the actual operation I want.
    current = combine(((Gnumber)a).value, ((Gnumber)b).value);
    trail.argument = current;
    trail = trail2;
    return false;
}

}


