/* Rosemary Francis
 * 
 * This program generates a self testing program for a given N_105 instruction
 * It is only designed to be used for alu instructions. 
 * It is assumed that the instructions not being tested work trivially
 */

/*

movi r0 <rand>
(movi r1 <rand>)
<op> r0 (r1/<rand>
mov r<index> r0

 */


import java.io.*;
import java.util.*;

public class ProgramGen
{
    public static void main(String [] args)
    {
	try
	{
	    
	if(args.length != 2)
	{
	    System.out.println("Usage : java ProgramGen <op> <prog name>");
	}
		
	    String op = args [0];
	    String prog_name = args [1];
	    
	    String readme = ";This file has been autonatically generated by a program called ProgamGen. \n ;Alter at your own risk! \n";
	    
	    BufferedWriter out = new BufferedWriter(new FileWriter(prog_name));
	    out.write(readme,0,readme.length());
	   
	    op = op.toLowerCase();

	    if (op.compareTo("not") == 0 )
		write_function_(op, out);
	    else if (op.length() > 3 && op.charAt(3) == 'i')
		if (op.compareTo("movi") == 0 || op.compareTo("movi") == 0)
			write_function_simm7(op, out);
		else if (op.compareTo("addi") == 0 || op.compareTo("subi") == 0)
			write_function_uimm7(op, out);
		else
			write_function_imm4(op, out);
	    else
		write_function_rb(op, out);



	    out.close();

	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }

    static void write_function_rb(String op, BufferedWriter out)
    {
	Random r = new Random();
	String line;
	String rand;
	int random;
	
	try
	{

	
	for (int index = 2; index < 16; index++)
	    {
		line = "\n\u0009movi r0 ";               //shift in a value for r0
		out.write(line, 0, line.length());
		rand = String.valueOf(r.nextInt() >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());
		
		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1; 
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());
		
		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1; 
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());
		
		line = "\n\u0009movi r1 ";                //shift in a value for r1
		out.write(line, 0, line.length());
		rand = String.valueOf(r.nextInt() >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009lsli r1 7";
		out.write(line, 0, line.length());
		
		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r1 ";
		else
		    {
			line = "\n\u0009subi r1 ";
			random = random * -1; 
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009lsli r1 7";
		out.write(line, 0, line.length());
		
		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r1 ";
		else
		    {
			line = "\n\u0009subi r1 ";
			random = random * -1; 
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());
		
		line = "\n\u0009";                       //test op
		out.write(line, 0, line.length());
		out.write(op, 0, op.length());
		line = " r0 r1 ";
		out.write(line, 0, line.length());

		line = "\n\u0009mov r";                      //mov to register for comparison with simulation
		out.write(line, 0, line.length());
		rand = String.valueOf(index);
		out.write(rand, 0, rand.length());
		line = " r0 \n\n";
		out.write(line, 0, line.length());
		
	    }

	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }

    static void write_function_(String op, BufferedWriter out)
    {
	Random r = new Random();
	String line;
	String rand;
	int random;
	
	try
	{

	for (int index = 2; index < 16; index++)
	    {
		line = "\n\u0009movi r0 ";               //shift value into r0
		out.write(line, 0, line.length());
		rand = String.valueOf(r.nextInt() >> 25);
		out.write(rand, 0, rand.length());
	      
		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());

		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1;
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());
		
		
		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1; 
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009";                        //test op
		out.write(line, 0, line.length());
		out.write(op, 0, op.length());
		line = " r0 ";
		out.write(line, 0, line.length());

		line = "\nmov r";                        //mov to register for comparison with simulation
		out.write(line, 0, line.length());
		rand = String.valueOf(index);
		out.write(rand, 0, rand.length());
		line = " r0 \n\n";
		out.write(line, 0, line.length());
		
	    }

	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }

    static void write_function_imm4(String op, BufferedWriter out)
    {
	Random r = new Random();
	String line;
	int random;
	String rand;
	
	try
	{

	for (int index = 2; index < 16; index++)
	    {
		line = "\n\u0009movi r0 ";               //shift value into r0
		out.write(line, 0, line.length());
		rand = String.valueOf(r.nextInt() >> 25);
		out.write(rand, 0, rand.length());
	      
		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());
		
		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1;
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());
		
		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1;
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009";                        //test op with rand imm4
		out.write(line, 0, line.length());
		out.write(op, 0, op.length());
		line = " r0 ";
		out.write(line, 0, line.length());
		rand = String.valueOf(r.nextInt() >>> 28);
		out.write(rand, 0, rand.length());

		line = "\nmov r";                        //mov to register for comparison with simulation
		out.write(line, 0, line.length());
		rand = String.valueOf(index);
		out.write(rand, 0, rand.length());
		line = " r0 \n\n";
		out.write(line, 0, line.length());
		
	    }

	}
	catch(Exception e){System.out.println(e); System.exit(0);}

    }
    
    static void write_function_simm7(String op, BufferedWriter out)
    {
	Random r = new Random();
	String line;
	String rand;
	int random;
	try
	{
	
	for (int index = 2; index < 16; index++)
	    {
		line = "\n\u0009movi r0 ";               //shift value into r0
		out.write(line, 0, line.length());
		rand = String.valueOf(r.nextInt() >> 25);
		out.write(rand, 0, rand.length());
	      
		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());

		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1; 
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());

		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1; 
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009";                        //test op with rand signed imm7
		out.write(line, 0, line.length());
		out.write(op, 0, op.length());
		line = " r0 ";
		out.write(line, 0, line.length());
		rand = String.valueOf(r.nextInt() >> 25);
		out.write(rand, 0, rand.length());

		line = "\nmov r";                        //mov to register for comparison with simulation
		out.write(line, 0, line.length());
		rand = String.valueOf(index);
		out.write(rand, 0, rand.length());
		line = " r0 \n\n";
		out.write(line, 0, line.length());
		
	    }

	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }

	static void write_function_uimm7(String op, BufferedWriter out)
    {
	Random r = new Random();
	String line;
	String rand;	
	int random;

	try
	{

	for (int index = 2; index < 16; index++)
	    {
		line = "\n\u0009movi r0 ";               //shift value into r0
		out.write(line, 0, line.length());
		rand = String.valueOf(r.nextInt() >> 25);
		out.write(rand, 0, rand.length());
	      
		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());
		
		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1; 
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009lsli r0 7";
		out.write(line, 0, line.length());
		
		random = r.nextInt();
		if(random > 0)
		    line = "\n\u0009addi r0 ";
		else
		    {
			line = "\n\u0009subi r0 ";
			random = random * -1; 
		    }
		out.write(line, 0, line.length());
		rand = String.valueOf(random >> 25);
		out.write(rand, 0, rand.length());

		line = "\n\u0009";                        //test op with rand unsigned imm7
		out.write(line, 0, line.length());
		out.write(op, 0, op.length());
		line = " r0 ";
		out.write(line, 0, line.length());
		rand = String.valueOf(r.nextInt() >>> 25); //*********** This is not Working!!!! ****************//
		out.write(rand, 0, rand.length());

		line = "\nmov r";                        //mov to register for comparison with simulation
		out.write(line, 0, line.length());
		rand = String.valueOf(index);
		out.write(rand, 0, rand.length());
		line = " r0 \n\n";
		out.write(line, 0, line.length());
		
	    }

	}
	catch(Exception e){System.out.println(e); System.exit(0);}
    }
}






























