//Copyright (C) 1991-2004 Altera Corporation
//Any megafunction design, and related net list (encrypted or decrypted),
//support information, device programming or simulation file, and any other
//associated documentation or information provided by Altera or a partner
//under Altera's Megafunction Partnership Program may be used only to
//program PLD devices (but not masked PLD devices) from Altera.  Any other
//use of such megafunction design, net list, support information, device
//programming or simulation file, or any other related documentation or
//information is prohibited for any other purpose, including, but not
//limited to modification, reverse engineering, de-compiling, or use with
//any other silicon devices, unless such use is explicitly licensed under
//a separate agreement with Altera or a megafunction partner.  Title to
//the intellectual property, including patents, copyrights, trademarks,
//trade secrets, or maskworks, embodied in any such megafunction design,
//net list, support information, device programming or simulation file, or
//any other related documentation or information provided by Altera or a
//megafunction partner, remains with Altera, the megafunction partner, or
//their respective licensors.  No other licenses, including any licenses
//needed under any third party's intellectual property, are provided herein.
//Copying or modifying any file, or portion thereof, to which this notice
//is attached violates this copyright.

// exemplar translate_off
`timescale 1ns / 100ps
// exemplar translate_on
module cpu1 (
              // inputs:
               clk,
               readdata_instr_fetch,
               readdata_mem_access,
               reset,
               waitrequest_instr_fetch,
               waitrequest_mem_access,

              // outputs:
               address_instr_fetch,
               address_mem_access,
               byteenable_instr_fetch,
               byteenable_mem_access,
               read_instr_fetch,
               read_mem_access,
               write_mem_access,
               writedata_mem_access
            );

  output  [ 15: 0] address_instr_fetch;
  output  [ 15: 0] address_mem_access;
  output  [  3: 0] byteenable_instr_fetch;
  output  [  3: 0] byteenable_mem_access;
  output           read_instr_fetch;
  output           read_mem_access;
  output           write_mem_access;
  output  [ 15: 0] writedata_mem_access;
  input            clk;
  input   [ 15: 0] readdata_instr_fetch;
  input   [ 15: 0] readdata_mem_access;
  input            reset;
  input            waitrequest_instr_fetch;
  input            waitrequest_mem_access;

  wire    [ 15: 0] address_instr_fetch;
  wire    [ 15: 0] address_mem_access;
  wire    [  3: 0] byteenable_instr_fetch;
  wire    [  3: 0] byteenable_mem_access;
  wire             read_instr_fetch;
  wire             read_mem_access;
  wire             write_mem_access;
  wire    [ 15: 0] writedata_mem_access;
  cpu the_cpu
    (
      .address_instr_fetch     (address_instr_fetch),
      .address_mem_access      (address_mem_access),
      .byteenable_instr_fetch  (byteenable_instr_fetch),
      .byteenable_mem_access   (byteenable_mem_access),
      .clk                     (clk),
      .read_instr_fetch        (read_instr_fetch),
      .read_mem_access         (read_mem_access),
      .readdata_instr_fetch    (readdata_instr_fetch),
      .readdata_mem_access     (readdata_mem_access),
      .reset                   (reset),
      .waitrequest_instr_fetch (waitrequest_instr_fetch),
      .waitrequest_mem_access  (waitrequest_mem_access),
      .write_mem_access        (write_mem_access),
      .writedata_mem_access    (writedata_mem_access)
    );



endmodule

