abstract class TSOTransactorObject  {
  TSOTransaction mostRecent;

  synchronized void enter (Transaction t)
       throws Failure 
  {
    TSOTransaction tx = (TSOTransaction) t;

    if (mostRecent != null &&
        mostRecent != tx) {
      if (tx.earlierThan (mostRecent)) {
        throw new Failure ("Too late");
      } else {
        mostRecent.waitFor ();
      }
    }
    
    mostRecent = tx;
    tx.enter (this, getState ());
  }

  abstract Object getState ();

  abstract void setState (Object o);
}
