package remifc;

import java.net.InetAddress;
import java.io.Serializable;

public class PlayerLocation implements Serializable {
	InetAddress playerAddr;
	int playerPort;

	public PlayerLocation(InetAddress player_addr, int player_port) {
		this.playerAddr = player_addr;
		this.playerPort = player_port;
	}

	public InetAddress getPlayerAddr() {
		return playerAddr;
	}

	public int getPlayerPort() {
		return playerPort;
	}

	public String toString() {
		return "(" + playerAddr + ":" + playerPort + ")";
	}

	public boolean isLessThan(PlayerLocation other) {
		return ((this.toString().compareTo(other.toString())) < 0);
	}
}
