public class BufferMultipleCondvars implements Buffer {
	int value;
	boolean valid = false;
	Mutex m = new Mutex();
	CondVar cv_empty = new CondVar();
	CondVar cv_full = new CondVar();

	public void put(int i) throws InterruptedException {
		m.acquire();
		while (valid) {
			cv_full.CVWait(m);
		}
		value = i;
		valid = true;
		cv_empty.CVNotify();
		m.release();
	}

	public int get() throws InterruptedException {
		int result;

		m.acquire();
		while (!valid) {
			cv_empty.CVWait(m);
		}
		valid = false;
		cv_full.CVNotify();
		result = value;
		m.release();

		return result;
	}
}
