public class SortExample {

   public static void main (String [] args) {
    try {
      sortints ();
      sortnums ();
      sortmixed ();
    }
    catch (IncompatibleTypeException e) {
      System.out.println ("Incompatible types: " + e.getMessage ());
    };
  };

  static void sortints () throws IncompatibleTypeException {
    Sortable [] d = {new SortableInt (3), new SortableInt (5),
                     new SortableInt (2), new SortableInt (4),
                     new SortableInt (3), new SortableInt (5)};
    print (d);
    sort (d);
    print (d);
  };

  static void sortnums () throws IncompatibleTypeException {
    Sortable [] d = {new Integer (3), new Integer (5),
                     new Integer (2), new Real (4.0f),
                     new Real (3.0f), new Real (5.0f)};
    print (d);
    sort (d);
    print (d);
  };

  static void sortmixed () throws IncompatibleTypeException {
    Sortable [] d = {new SortableInt (3), new SortableInt (5),
                     new Integer (2), new Integer (4),
                     new Real (3.0f), new Real (5.0f)};
    print (d);
    sort (d);
    print (d);
  };

  static void print (Object [] data) {
    System.out.print ("[");
    if (data.length > 0) System.out.print (data [0]);
    for (int i = 1; i < data.length; i++) System.out.print (", " + data [i]);
    System.out.println ("]");
  };

  static void sort (Sortable [] data) throws IncompatibleTypeException {
    for (int i = 1; i < data.length; i++) {
      for (int j = i; (j > 0) && (data [j] .compare (data [j-1]) < 0); j--) {
        // if (data [j] .compare (data [j-1]) >= 0) break;
        Sortable d = data [j];
        data [j] = data [j-1];
        data [j-1] = d;
      };
    };
  };

};

class IncompatibleTypeException extends Exception {
  IncompatibleTypeException (Object a, Object b) {
    super ("Can not compare " + a.getClass().getName() + " with " + b.getClass().getName());
  };
};

interface Sortable {
  public int compare (Sortable s) throws IncompatibleTypeException;
};

class SortableInt implements Sortable {
  int i;
  SortableInt (int i) {this.i = i;};
  public String toString () {return i + "";};
  public int compare (Sortable s) throws IncompatibleTypeException {
    if (s instanceof SortableInt) return i - ((SortableInt) s).i;
    else throw new IncompatibleTypeException (this, s);
  };
};

abstract class Number {
  abstract public Number add (Number n);
};

class Integer extends Number implements Sortable {
  int i;
  public Integer (int i) { this.i = i; };
  public Number add (Number n) {
    return n instanceof Integer ? (Number) new Integer (i + ((Integer) n).i)
                                : (Number) new Real (i + ((Real) n).r);
  };
  public String toString () {return i + ": Integer";};
  public int compare (Sortable s) throws IncompatibleTypeException {
    if (s instanceof Integer) return i - ((Integer) s).i;
    else if (s instanceof Real) return i - ((Real) s).r > 0 ? +1 : -1;
         else throw new IncompatibleTypeException (this, s);
  };
};

class Real extends Number implements Sortable {
  float r;
  public Real (float f) {r = f;};
  public Number add (Number n) {
    return n instanceof Integer ? new Real (r + ((Integer) n).i)
                                : new Real (r + ((Real) n).r);
  };
  public String toString () {return r + ": Real";};
  public int compare (Sortable s) throws IncompatibleTypeException {
    if (s instanceof Integer) return r - ((Integer) s).i > 0 ? +1 : -1;
    else if (s instanceof Real) return r - ((Real) s).r > 0 ? +1 : -1;
         else throw new IncompatibleTypeException (this, s);
  };

}
