public class BufferExample {
  public static void main (String [] args) {
    Buffer b = new Buffer ();
    Thread c = new Consumer (b);
    c.start ();
    try {
      for (int i = 1; i <= 7; i++) b.put (i);
    }
    catch (InterruptedException e) {
      System.out.println ("Producer interrupted!");
    };
    c.stop ();
  };
};

class Buffer {

  int value;
  boolean valid = false;

  synchronized void put (int i) throws InterruptedException {
    while (valid) wait ();
    value = i;
    valid = true;
    notify ();
  };

  synchronized int get () throws InterruptedException {
    while (! valid) wait ();
    valid = false;
    notify ();
    return value;
  };

};

class Consumer extends Thread {

  Buffer buffer;

  Consumer (Buffer b) {buffer = b;};

  public void run () {
    for (;;) {
      try {
	System.out.println ("Found " + buffer.get ());
      }
      catch (InterruptedException e) {
	System.out.println ("Interrupted while consuming!");
      };
    };
  };

};

