package uk.ac.cam.cl.dtg.testingdemo;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

import java.text.ParseException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;

import static com.google.common.truth.Truth.assertThat;

@RunWith(JUnit4.class)
public class AgeCalculatorTest {

  private AgeCalculator ageCalculator;

  @Before
  public void setup() {
    Instant today = Instant.parse("2007-12-03T10:15:30.00Z");
    Clock clock = Clock.fixed(today, ZoneId.systemDefault());
    ageCalculator = new AgeCalculator(clock);
  }

  @Test
  // <- method name is important
  // <- test one property
  public void calculateAgeInDays_returnsZero_whenIWasBorn() throws ParseException {
    // ARRANGE  // <- common structure

    // ACT
    long age = ageCalculator.calculateAgeInDays("2007-12-03");

    // ASSERT
    assertThat(age).isEqualTo(0);
  }

  @Test
  // <- method name is important
  // <- test one property
  public void calculateAgeInDays_returnsOne_whenIWasBornYesterday() throws ParseException {
    // ARRANGE  // <- common structure

    // ACT
    long age = ageCalculator.calculateAgeInDays("2007-12-02");

    // ASSERT
    assertThat(age).isEqualTo(1);
  }
}
