package uk.ac.cam.cl.dtg.testingdemo;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

class AgeCalculator {

  static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

  private final Clock clock;

  AgeCalculator(Clock clock) {
    this.clock = clock;
  }

  AgeCalculator() {
    this(Clock.systemDefaultZone());
  }

  long calculateAgeInDays(String dateOfBirth) throws ParseException {
    Instant dob = dateFormat.parse(dateOfBirth).toInstant();
    Instant currentTime = clock.instant();
    Duration age = Duration.between(dob, currentTime);
    long ageInDays = age.toDays();
    if (ageInDays < 0) {
      return 0;
    }

    return ageInDays;
  }
}
