package uk.ac.cam.cl.commerce;

import static com.google.common.truth.Truth.assertThat;

import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(JUnit4.class)
public class TestShoppingCart {

  private ShoppingCart cart;

  @Before
  public void setup() {
    cart = new ShoppingCart();
    System.out.println("Adding Apples for 1.50 GBP");
    cart.addItem("Apples", 1.5);
    System.out.println("Adding Oranges for 2.00 GBP");
    cart.addItem("Oranges", 2);
    System.out.println("Adding Pears for 1.00 GBP");
    cart.addItem("Pears", 1);
  }

  @Test
  public void test() {
    double total = cart.getTotal();
    System.out.printf("Total is %.2f GBP%n", total);
    assertThat(total).isEqualTo(4.5);

    System.out.println("Removing Apples");
    cart.removeItem("Apples");
    total = cart.getTotal();
    System.out.printf("Total is %.2f GBP%n", total);
    assertThat(total).isEqualTo(3.0);
  }

  @Test
  public void test2() {
    PaymentDetails paymentDetails = new PaymentDetails("A N Other");
    ShoppingCart.Order order = cart.createOrder(paymentDetails);

    System.out.printf(
        "Your order is: %s", order.getNames().stream().collect(Collectors.joining(",")));
    System.out.println("Charging payment card");
    order.chargePaymentCard();
  }
}
