package uk.ac.cam.cl.commerce;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class ShoppingCart {

  private ArrayList<Item> items;
  private final CardPaymentProcessor paymentProcessor;

  ShoppingCart() {
    this.items = new ArrayList<>();
    this.paymentProcessor = new CardPaymentProcessor();
  }

  void addItem(String name, double price) {
    items.add(new Item(name, price));
  }

  void removeItem(String name) {
    items =
        items
            .stream()
            .filter(item -> !item.getName().equals(name))
            .collect(Collectors.toCollection(ArrayList::new));
  }

  Order createOrder(PaymentDetails details) {
    Order order = new Order(items, details);
    items = new ArrayList<>();
    return order;
  }

  double getTotal() {
    return items.stream().mapToDouble(Item::getPrice).sum();
  }

  private static class Item {
    String name;
    double price;

    Item(String name, double price) {
      this.name = name;
      this.price = price;
    }

    String getName() {
      return name;
    }

    double getPrice() {
      return price;
    }
  }

  class Order {
    private final ArrayList<Item> items;
    private final PaymentDetails paymentDetails;

    Order(ArrayList<Item> items, PaymentDetails paymentDetails) {
      this.items = items;
      this.paymentDetails = paymentDetails;
    }

    List<String> getNames() {
      return items.stream().map(Item::getName).collect(Collectors.toList());
    }

    boolean chargePaymentCard() {
      return paymentProcessor.charge(
          paymentDetails, items.stream().mapToDouble(Item::getPrice).sum());
    }
  }
}
