/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cl.databases.moviedb;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import uk.ac.cam.cl.databases.moviedb.model.Movie;
import uk.ac.cam.cl.databases.moviedb.model.Person;

public class MovieDB
implements AutoCloseable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final EntryBinding<Integer> intBinding = TupleBinding.getPrimitiveBinding(Integer.class);
    private Environment dbEnv;
    private Database moviesDB;
    private Database peopleDB;
    private SecondaryDatabase titleIndex;
    private SecondaryDatabase nameIndex;

    public static MovieDB open(String dataDir) {
        return new MovieDB(dataDir);
    }

    private MovieDB(String dataDir) {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(false);
        this.dbEnv = new Environment(new File(dataDir), envConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setDeferredWrite(true);
        this.moviesDB = this.dbEnv.openDatabase(null, "movies", dbConfig);
        this.peopleDB = this.dbEnv.openDatabase(null, "people", dbConfig);
        SecondaryConfig titleIndexConfig = new SecondaryConfig();
        titleIndexConfig.setAllowCreate(true);
        titleIndexConfig.setAllowPopulate(true);
        titleIndexConfig.setDeferredWrite(true);
        titleIndexConfig.setKeyCreator((SecondaryKeyCreator)new TitleExtractor());
        titleIndexConfig.setSortedDuplicates(true);
        this.titleIndex = this.dbEnv.openSecondaryDatabase(null, "movies-by-title", this.moviesDB, titleIndexConfig);
        SecondaryConfig nameIndexConfig = new SecondaryConfig();
        nameIndexConfig.setAllowCreate(true);
        nameIndexConfig.setAllowPopulate(true);
        nameIndexConfig.setDeferredWrite(true);
        nameIndexConfig.setKeyCreator((SecondaryKeyCreator)new NameExtractor());
        nameIndexConfig.setSortedDuplicates(true);
        this.nameIndex = this.dbEnv.openSecondaryDatabase(null, "people-by-name", this.peopleDB, nameIndexConfig);
    }

    public void putMovie(String json) {
        if (this.moviesDB == null) {
            throw new IllegalStateException("Database is not open");
        }
        Movie movie = Movie.fromJson(json);
        DatabaseEntry key = new DatabaseEntry();
        intBinding.objectToEntry((Object)movie.getId(), key);
        DatabaseEntry value = new DatabaseEntry(json.getBytes(UTF8));
        this.moviesDB.put(null, key, value);
    }

    public void putPerson(String json) {
        if (this.peopleDB == null) {
            throw new IllegalStateException("Database is not open");
        }
        Person person = Person.fromJson(json);
        DatabaseEntry key = new DatabaseEntry();
        intBinding.objectToEntry((Object)person.getId(), key);
        DatabaseEntry value = new DatabaseEntry(json.getBytes(UTF8));
        this.peopleDB.put(null, key, value);
    }

    public Movie getMovieById(int id) {
        if (this.moviesDB == null) {
            throw new IllegalStateException("Database is not open");
        }
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        intBinding.objectToEntry((Object)id, key);
        if (this.moviesDB.get(null, key, value, null) == OperationStatus.SUCCESS) {
            return Movie.fromJson(new String(value.getData(), UTF8));
        }
        return null;
    }

    public Person getPersonById(int id) {
        if (this.peopleDB == null) {
            throw new IllegalStateException("Database is not open");
        }
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        intBinding.objectToEntry((Object)id, key);
        if (this.peopleDB.get(null, key, value, null) == OperationStatus.SUCCESS) {
            return Person.fromJson(new String(value.getData(), UTF8));
        }
        return null;
    }

    public Iterable<Movie> getByTitlePrefix(final String titlePrefix) {
        return new Iterable<Movie>(){

            @Override
            public Iterator<Movie> iterator() {
                return new SearchByPrefix<Movie>(MovieDB.this.titleIndex, titlePrefix, Movie::fromJson);
            }
        };
    }

    public Iterable<Person> getByNamePrefix(final String namePrefix) {
        return new Iterable<Person>(){

            @Override
            public Iterator<Person> iterator() {
                return new SearchByPrefix<Person>(MovieDB.this.nameIndex, namePrefix, Person::fromJson);
            }
        };
    }

    @Override
    public void close() {
        if (this.dbEnv == null) {
            return;
        }
        EnvironmentMutableConfig config = this.dbEnv.getMutableConfig();
        config.setConfigParam("je.env.runCleaner", "false");
        this.dbEnv.setMutableConfig(config);
        this.dbEnv.cleanLog();
        this.dbEnv.checkpoint(new CheckpointConfig().setForce(true));
        if (this.titleIndex != null) {
            this.titleIndex.close();
        }
        this.titleIndex = null;
        if (this.nameIndex != null) {
            this.nameIndex.close();
        }
        this.nameIndex = null;
        if (this.moviesDB != null) {
            this.moviesDB.close();
        }
        this.moviesDB = null;
        if (this.peopleDB != null) {
            this.peopleDB.close();
        }
        this.peopleDB = null;
        this.dbEnv.close();
        this.dbEnv = null;
    }

    private static class SearchByPrefix<T>
    implements Iterator<T>,
    AutoCloseable {
        private final byte[] prefix;
        private final Function<String, T> parseJson;
        private SecondaryCursor cursor;
        private DatabaseEntry key = new DatabaseEntry();
        private DatabaseEntry result = new DatabaseEntry();
        private OperationStatus status;
        private T next;

        private SearchByPrefix(SecondaryDatabase index, String titlePrefix, Function<String, T> parseJson) {
            if (index == null) {
                throw new IllegalStateException("Database is not open");
            }
            this.prefix = titlePrefix.getBytes(UTF8);
            this.key.setData(Arrays.copyOf(this.prefix, this.prefix.length));
            this.parseJson = parseJson;
            this.cursor = index.openCursor(null, null);
            this.status = this.cursor.getSearchKeyRange(this.key, this.result, null);
            this.loadRecord();
        }

        private void loadRecord() {
            if (this.cursor == null || this.status != OperationStatus.SUCCESS || !Arrays.equals(this.prefix, Arrays.copyOf(this.key.getData(), this.prefix.length))) {
                this.close();
            } else {
                this.next = this.parseJson.apply(new String(this.result.getData(), UTF8));
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator has finished");
            }
            T toReturn = this.next;
            this.status = this.cursor.getNext(this.key, this.result, null);
            this.loadRecord();
            return toReturn;
        }

        @Override
        public void close() {
            if (this.cursor != null) {
                this.cursor.close();
            }
            this.cursor = null;
            this.next = null;
        }
    }

    private static class NameExtractor
    implements SecondaryKeyCreator {
        private NameExtractor() {
        }

        public boolean createSecondaryKey(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry value, DatabaseEntry result) {
            Person person = Person.fromJson(new String(value.getData(), UTF8));
            result.setData(person.getName().getBytes(UTF8));
            return true;
        }
    }

    private static class TitleExtractor
    implements SecondaryKeyCreator {
        private TitleExtractor() {
        }

        public boolean createSecondaryKey(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry value, DatabaseEntry result) {
            Movie movie = Movie.fromJson(new String(value.getData(), UTF8));
            result.setData(movie.getTitle().getBytes(UTF8));
            return true;
        }
    }
}

