/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.acr31.bitvisualiser;

import uk.ac.cam.acr31.bitvisualiser.Util;

public class DecimalToBinary {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: DecimalToBinary [decimalnumber]");
            System.exit(-1);
        }
        int v = 0;
        try {
            v = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.out.println("Please provide a valid number");
            System.exit(-1);
        }
        if (v < 0 || v > 255) {
            System.out.println("This program only converts 8-bit positive numbers in the range 0 to 255");
            System.exit(-1);
        }
        System.out.println("Converting the target number v=" + v + " to an 8-bit unsigned binary number");
        System.out.println("The most significant bit (written as the left-most character) is at position 7 and represents 2^7 (128)");
        System.out.println("The least significant bit (written as the right-most character) is at position 0 and represents 2^0 (0)");
        String result = "";
        int i = 7;
        while (i >= 0) {
            Util.type("Position " + i + " represents");
            Util.type(" 2^" + i + " (" + (1 << i) + ") and v=" + v);
            if (v >= 1 << i) {
                Util.type(" since " + v + ">=" + (1 << i) + " then bit " + i + " must be a ");
                Util.type("1");
                System.out.println();
                Util.type("Now do v-=" + (1 << i) + " to remove this position's contribution from v");
                v -= 1 << i;
                System.out.println();
                result = String.valueOf(result) + "1";
            } else {
                Util.type(" since " + v + "<" + (1 << i) + " then bit " + i + " must be a ");
                Util.type("0");
                System.out.println();
                Util.type("This bit contributes nothing to the total so leave v unchanged");
                System.out.println();
                result = String.valueOf(result) + "0";
            }
            --i;
        }
        System.out.println();
        Util.type("Therefore the binary value is " + result);
        System.out.println();
    }
}

