/*
 * Decompiled with CFR 0.152.
 */
package ttcasm.comparch.cl.cam.ac.uk;

import ttcasm.comparch.cl.cam.ac.uk.Generator;
import ttcasm.comparch.cl.cam.ac.uk.Instruction;
import ttcasm.comparch.cl.cam.ac.uk.Program;

public class ILcImm
implements Instruction {
    private byte rw = 0;
    private int imm = 0;

    protected ILcImm(byte by, int n) {
        this.rw = by;
        this.imm = n;
    }

    @Override
    public void Validate(Program program) throws Exception {
        if (this.imm >> 24 != 0) {
            throw new Exception("Invalid constant (limited to 24 bits) ");
        }
        if (this.rw < 0 | this.rw > 127) {
            throw new Exception("Invalid register (index not in range [0..127]) ");
        }
    }

    @Override
    public void Generate(Generator generator) throws Exception {
        generator.writeHeader();
        generator.write(this.rw, 7);
        generator.write(1, 1);
        generator.write(this.imm, 24);
        generator.writeFooter();
    }

    @Override
    public String toString() {
        return "LC RW=R" + this.rw + " IMM=" + this.imm;
    }
}

